/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AdminDialog;
import com.sun.messaging.jmq.admin.apps.console.util.IntegerField;
import com.sun.messaging.jmq.admin.apps.console.util.LabelValuePanel;
import com.sun.messaging.jmq.admin.apps.console.util.LabelledComponent;
import com.sun.messaging.jmq.admin.bkrutil.BrokerAdminUtil;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import com.sun.messaging.jmq.admin.resources.AdminConsoleResources;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class BrokerServicePropsDialog
extends AdminDialog {
    private static final long serialVersionUID = 692779940571027259L;
    private static AdminResources ar = Globals.getAdminResources();
    private static AdminConsoleResources acr = Globals.getAdminConsoleResources();
    private static String[] close;
    private JLabel svcName;
    private JRadioButton dynamicPortButton;
    private JRadioButton staticPortButton;
    private JLabel dynamicPortLabel;
    private IntegerField staticPortIF;
    private JLabel svcState;
    private IntegerField minThreads;
    private IntegerField maxThreads;
    private JLabel numConnections;
    private JLabel allocatedThreads;
    private ServiceInfo svcInfo;
    private LabelledComponent svcPortComponent;

    public BrokerServicePropsDialog(Frame parent) {
        super(parent, acr.getString("A1409"), 81);
        this.setHelpId("service_properties");
    }

    @Override
    public JPanel createWorkPanel() {
        JPanel workPanel = new JPanel();
        GridBagLayout workGridbag = new GridBagLayout();
        workPanel.setLayout(workGridbag);
        GridBagConstraints workConstraints = new GridBagConstraints();
        workConstraints.gridx = 0;
        workConstraints.gridy = 0;
        workConstraints.anchor = 17;
        workConstraints.fill = 0;
        workConstraints.insets = new Insets(5, 0, 5, 0);
        workConstraints.ipadx = 0;
        workConstraints.ipady = 0;
        workConstraints.weightx = 1.0;
        LabelledComponent[] lvpItems = new LabelledComponent[3];
        this.svcName = new JLabel();
        LabelledComponent tmpLabelC = new LabelledComponent(ar.getString("A1420") + ":", this.svcName);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        lvpItems[0] = tmpLabelC;
        JPanel servicePanel = new JPanel();
        GridBagLayout serviceGridbag = new GridBagLayout();
        servicePanel.setLayout(serviceGridbag);
        GridBagConstraints serviceConstraints = new GridBagConstraints();
        serviceConstraints.anchor = 17;
        serviceConstraints.insets = new Insets(0, 0, 0, 0);
        serviceConstraints.gridx = 0;
        serviceConstraints.gridy = 0;
        this.dynamicPortButton = new JRadioButton();
        this.dynamicPortButton.addActionListener(this);
        serviceGridbag.setConstraints(this.dynamicPortButton, serviceConstraints);
        servicePanel.add(this.dynamicPortButton);
        serviceConstraints.gridx = 0;
        serviceConstraints.gridy = 1;
        this.staticPortButton = new JRadioButton();
        this.staticPortButton.addActionListener(this);
        serviceGridbag.setConstraints(this.staticPortButton, serviceConstraints);
        servicePanel.add(this.staticPortButton);
        ButtonGroup servicePortGroup = new ButtonGroup();
        servicePortGroup.add(this.dynamicPortButton);
        servicePortGroup.add(this.staticPortButton);
        serviceConstraints.gridx = 1;
        serviceConstraints.gridy = 0;
        JLabel dynamicLabel = new JLabel(acr.getString("A1451") + ":");
        serviceGridbag.setConstraints(dynamicLabel, serviceConstraints);
        servicePanel.add(dynamicLabel);
        serviceConstraints.gridx = 1;
        serviceConstraints.gridy = 1;
        JLabel staticLabel = new JLabel(acr.getString("A1452") + ":");
        serviceGridbag.setConstraints(staticLabel, serviceConstraints);
        servicePanel.add(staticLabel);
        serviceConstraints.gridx = 2;
        serviceConstraints.gridy = 0;
        serviceConstraints.insets = new Insets(0, 5, 0, 0);
        this.dynamicPortLabel = new JLabel();
        serviceGridbag.setConstraints(this.dynamicPortLabel, serviceConstraints);
        servicePanel.add(this.dynamicPortLabel);
        serviceConstraints.gridx = 2;
        serviceConstraints.gridy = 1;
        serviceConstraints.insets = new Insets(0, 5, 0, 0);
        this.staticPortIF = new IntegerField(0L, Integer.MAX_VALUE, 15);
        this.staticPortIF.setEnabled(false);
        serviceGridbag.setConstraints(this.staticPortIF, serviceConstraints);
        servicePanel.add(this.staticPortIF);
        tmpLabelC = new LabelledComponent(ar.getString("A1421") + ":", (JComponent)servicePanel, 0);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        lvpItems[1] = tmpLabelC;
        this.svcPortComponent = lvpItems[1];
        this.svcState = new JLabel();
        tmpLabelC = new LabelledComponent(ar.getString("A1422") + ":", this.svcState);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        lvpItems[2] = tmpLabelC;
        LabelValuePanel lvp = new LabelValuePanel(lvpItems, 4, 0);
        workGridbag.setConstraints(lvp, workConstraints);
        workPanel.add(lvp);
        workConstraints.gridy = 1;
        JSeparator sep = new JSeparator();
        workConstraints.fill = 2;
        workGridbag.setConstraints(sep, workConstraints);
        workPanel.add(sep);
        workConstraints.fill = 0;
        workConstraints.gridy = 2;
        lvpItems = new LabelledComponent[2];
        this.allocatedThreads = new JLabel();
        tmpLabelC = new LabelledComponent(ar.getString("A1425") + ":", this.allocatedThreads);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        lvpItems[0] = tmpLabelC;
        this.numConnections = new JLabel();
        tmpLabelC = new LabelledComponent(ar.getString("A1426") + ":", this.numConnections);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        lvpItems[1] = tmpLabelC;
        lvp = new LabelValuePanel(lvpItems, 4, 0);
        workGridbag.setConstraints(lvp, workConstraints);
        workPanel.add(lvp);
        workConstraints.gridy = 3;
        sep = new JSeparator();
        workConstraints.fill = 2;
        workGridbag.setConstraints(sep, workConstraints);
        workPanel.add(sep);
        workConstraints.fill = 0;
        workConstraints.gridy = 4;
        lvpItems = new LabelledComponent[2];
        this.minThreads = new IntegerField(0L, Integer.MAX_VALUE, 15);
        this.minThreads.addActionListener(this);
        tmpLabelC = new LabelledComponent(ar.getString("A1423") + ":", this.minThreads);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        workPanel.add(tmpLabelC);
        lvpItems[0] = tmpLabelC;
        this.maxThreads = new IntegerField(0L, Integer.MAX_VALUE, 15);
        this.maxThreads.addActionListener(this);
        tmpLabelC = new LabelledComponent(ar.getString("A1424") + ":", this.maxThreads);
        workGridbag.setConstraints(tmpLabelC, workConstraints);
        lvpItems[1] = tmpLabelC;
        lvp = new LabelValuePanel(lvpItems, 4, 0);
        workGridbag.setConstraints(lvp, workConstraints);
        workPanel.add(lvp);
        return workPanel;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void doOK() {
        int portValue = -1;
        if (this.staticPortButton.isSelected()) {
            String portText = this.staticPortIF.getText();
            if ("".equals(portText)) {
                JOptionPane.showOptionDialog(this, acr.getString("A3044"), acr.getString("A1409") + ": " + acr.getString("A1218", "A3044"), 0, 0, null, close, close[0]);
                return;
            }
            portValue = Integer.parseInt(portText);
        } else if (this.dynamicPortButton.isSelected()) {
            portValue = this.svcInfo.port == -1 ? -1 : 0;
        }
        int minThreadsValue = Integer.parseInt(this.minThreads.getText());
        int maxThreadsValue = Integer.parseInt(this.maxThreads.getText());
        BrokerAdminEvent bae = new BrokerAdminEvent(this, 6);
        bae.setPort(portValue);
        bae.setMinThreads(minThreadsValue);
        bae.setMaxThreads(maxThreadsValue);
        bae.setOKAction(true);
        this.fireAdminEventDispatched(bae);
    }

    @Override
    public void doReset() {
    }

    @Override
    public void doCancel() {
        this.setVisible(false);
    }

    @Override
    public void doClose() {
        this.setVisible(false);
        this.doClear();
    }

    @Override
    public void doClear() {
        this.svcName.setText(" ");
        this.dynamicPortButton.setSelected(true);
        this.staticPortButton.setSelected(false);
        this.dynamicPortLabel.setText(" ");
        this.staticPortIF.setText("");
        this.svcState.setText(" ");
        this.minThreads.setText("0");
        this.maxThreads.setText("0");
        this.allocatedThreads.setText("0");
        this.numConnections.setText("0");
        this.svcPortComponent.setEnabled(true);
    }

    public void show(ServiceInfo svcInfo) {
        this.svcInfo = svcInfo;
        if (svcInfo == null) {
            this.doClear();
            return;
        }
        this.svcName.setText(svcInfo.name);
        if (svcInfo.port == -1) {
            this.enableServicePort(false);
        } else {
            this.enableServicePort(true);
            if (svcInfo.dynamicPort) {
                this.dynamicPortButton.setSelected(true);
                this.staticPortIF.setEnabled(false);
                this.staticPortIF.setText("");
                switch (svcInfo.state) {
                    case -1: {
                        this.dynamicPortLabel.setText(" ");
                        break;
                    }
                    default: {
                        this.dynamicPortLabel.setText(Integer.toString(svcInfo.port));
                        break;
                    }
                }
            } else {
                this.staticPortButton.setSelected(true);
                this.staticPortIF.setEnabled(true);
                this.staticPortIF.setText(Integer.toString(svcInfo.port));
                this.dynamicPortLabel.setText(" ");
            }
        }
        this.svcState.setText(BrokerAdminUtil.getServiceState(svcInfo.state));
        this.maxThreads.setText(Integer.toString(svcInfo.minThreads));
        this.allocatedThreads.setText(Integer.toString(svcInfo.currentThreads));
        this.numConnections.setText(Integer.toString(svcInfo.nConnections));
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.dynamicPortButton) {
            this.doDynamicPortButton();
        } else if (source == this.staticPortButton) {
            this.doStaticPortButton();
        } else {
            super.actionPerformed(e);
        }
    }

    private void doDynamicPortButton() {
        this.staticPortIF.setEnabled(false);
    }

    private void doStaticPortButton() {
        this.staticPortIF.setEnabled(true);
    }

    private void enableServicePort(boolean b) {
        this.svcPortComponent.setEnabled(b);
        if (!b) {
            this.dynamicPortButton.setSelected(true);
            this.staticPortButton.setSelected(false);
            this.dynamicPortLabel.setText(" ");
            this.staticPortIF.setText("");
        }
    }

    static {
        String[] stringArray = new String[1];
        stringArray[0] = acr.getString("A1081");
        close = stringArray;
    }
}

