/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.InvalidPropertyException;
import com.sun.messaging.InvalidPropertyValueException;
import com.sun.messaging.Queue;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.ReadOnlyPropertyException;
import com.sun.messaging.Topic;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrOptions;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrPrinter;
import com.sun.messaging.jmq.admin.apps.objmgr.ObjMgrProperties;
import com.sun.messaging.jmq.admin.apps.objmgr.Utils;
import com.sun.messaging.jmq.admin.objstore.AuthenticationException;
import com.sun.messaging.jmq.admin.objstore.AuthenticationNotSupportedException;
import com.sun.messaging.jmq.admin.objstore.CommunicationException;
import com.sun.messaging.jmq.admin.objstore.GeneralNamingException;
import com.sun.messaging.jmq.admin.objstore.InitializationException;
import com.sun.messaging.jmq.admin.objstore.NameAlreadyExistsException;
import com.sun.messaging.jmq.admin.objstore.NameNotFoundException;
import com.sun.messaging.jmq.admin.objstore.NoPermissionException;
import com.sun.messaging.jmq.admin.objstore.ObjStore;
import com.sun.messaging.jmq.admin.objstore.ObjStoreAttrs;
import com.sun.messaging.jmq.admin.objstore.ObjStoreException;
import com.sun.messaging.jmq.admin.objstore.ObjStoreManager;
import com.sun.messaging.jmq.admin.objstore.SchemaViolationException;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.admin.util.JMSObjFactory;
import com.sun.messaging.jmq.util.Password;
import com.sun.messaging.naming.MissingVersionNumberException;
import com.sun.messaging.naming.UnsupportedVersionNumberException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.directory.Attributes;

public class CmdRunner
implements ObjMgrOptions {
    private static AdminResources ar = Globals.getAdminResources();
    private ObjMgrProperties objMgrProps;

    public CmdRunner(ObjMgrProperties props) {
        this.objMgrProps = props;
    }

    public int runCommands() {
        int exitcode = 0;
        String cmd = this.objMgrProps.getCommand();
        if (cmd.equals("add")) {
            exitcode = this.runAddCommand(this.objMgrProps);
        } else if (cmd.equals("delete")) {
            exitcode = this.runDeleteCommand(this.objMgrProps);
        } else if (cmd.equals("query")) {
            exitcode = this.runQueryCommand(this.objMgrProps);
        } else if (cmd.equals("list")) {
            this.runListCommand(this.objMgrProps);
        } else if (cmd.equals("update")) {
            exitcode = this.runUpdateCommand(this.objMgrProps);
        }
        return exitcode;
    }

    private ObjStore createStore(ObjStoreAttrs osa) {
        if (osa == null) {
            return null;
        }
        ObjStore os = null;
        try {
            ObjStoreManager osmgr = ObjStoreManager.getObjStoreManager();
            os = osmgr.createStore(osa);
        }
        catch (NameNotFoundException nnfe) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
        }
        catch (ObjStoreException e) {
            this.handleRunCommandExceptions(e);
        }
        return os;
    }

    private void openStore(ObjStore os) throws ObjStoreException {
        os.open();
    }

    private void printAddCmdDescription(Object newObj, String type, String lookupName, ObjStoreAttrs osa, String readOnlyValue) {
        Globals.stdOutPrintln(ar.getString("A1100", Utils.getObjTypeString(type)));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(2, 4);
        omp.printObjPropertiesFromObj((AdministeredObject)newObj);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1101"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(readOnlyValue);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1102"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp2 = new ObjMgrPrinter(osa, 2, 4);
        omp2.print();
        Globals.stdOutPrintln("");
    }

    private int runAddCommand(ObjMgrProperties objMgrProps) {
        int exitcode = 0;
        String input = null;
        Object object = null;
        String yes = ar.getString("A5016");
        String yesShort = ar.getString("A5015");
        String no = ar.getString("A5018");
        String noShort = ar.getString("A5017");
        String type = objMgrProps.getObjType();
        Properties objProps = objMgrProps.getObjProperties();
        String lookupName = objMgrProps.getLookupName();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        this.checkObjStoreAttrs(osa);
        Attributes bindAttrs = objMgrProps.getBindAttrs();
        boolean force = objMgrProps.forceModeSet();
        Object newObj = null;
        try {
            if (type.equals("q")) {
                newObj = JMSObjFactory.createQueue(objProps);
            } else if (type.equals("t")) {
                newObj = JMSObjFactory.createTopic(objProps);
            } else if (type.equals("qf")) {
                newObj = JMSObjFactory.createQueueConnectionFactory(objProps);
            } else if (type.equals("tf")) {
                newObj = JMSObjFactory.createTopicConnectionFactory(objProps);
            } else if (type.equals("cf")) {
                newObj = JMSObjFactory.createConnectionFactory(objProps);
            } else if (type.equals("xtf")) {
                newObj = JMSObjFactory.createXATopicConnectionFactory(objProps);
            } else if (type.equals("xqf")) {
                newObj = JMSObjFactory.createXAQueueConnectionFactory(objProps);
            } else if (type.equals("xcf")) {
                newObj = JMSObjFactory.createXAConnectionFactory(objProps);
            }
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1027"));
            return 1;
        }
        JMSObjFactory.doReadOnlyForAdd(newObj, objMgrProps.readOnlyValue());
        this.printAddCmdDescription(newObj, type, lookupName, osa, objMgrProps.readOnlyValue());
        ObjStore os = this.createStore(osa);
        if (os == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1027"));
            return 1;
        }
        if (!force) {
            os = this.promptForAuthentication(os);
        }
        try {
            this.openStore(os);
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1027"));
            return 1;
        }
        if (!force) {
            try {
                object = os.retrieve(lookupName);
            }
            catch (NameNotFoundException e) {
            }
            catch (Exception e) {
                this.handleRunCommandExceptions(e, lookupName);
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1027"));
                return 1;
            }
            if (object != null) {
                Globals.stdOutPrintln(ar.getCString("A1000"), ar.getString("A2000", lookupName));
                Globals.stdOutPrintln(ar.getCString("A1000"), ar.getString("A2001"));
                input = this.getUserInput(ar.getString("A5000"), noShort);
            }
        }
        if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1023"));
        } else if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || object == null || force) {
            try {
                if (bindAttrs.size() > 0) {
                    os.add(lookupName, newObj, bindAttrs, true);
                } else {
                    os.add(lookupName, newObj, true);
                }
            }
            catch (NameAlreadyExistsException e) {
            }
            catch (NameNotFoundException nnfe) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
                exitcode = 1;
            }
            catch (Exception e) {
                this.handleRunCommandExceptions(e, lookupName);
                exitcode = 1;
            }
            if (exitcode == 0) {
                Globals.stdOutPrintln(ar.getString("A1020"));
            } else {
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1027"));
            }
        } else {
            Globals.stdOutPrintln(ar.getString("A1026", input));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1023"));
            exitcode = 1;
        }
        return exitcode;
    }

    private void printDeleteCmdDescription(String lookupName, ObjStoreAttrs osa) {
        Globals.stdOutPrintln(ar.getString("A1103"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1104"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
    }

    private int runDeleteCommand(ObjMgrProperties objMgrProps) {
        int exitcode = 0;
        String lookupName = objMgrProps.getLookupName();
        Object object = null;
        String input = null;
        String yes = ar.getString("A5016");
        String yesShort = ar.getString("A5015");
        String no = ar.getString("A5018");
        String noShort = ar.getString("A5017");
        boolean force = objMgrProps.forceModeSet();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        this.checkObjStoreAttrs(osa);
        this.printDeleteCmdDescription(lookupName, osa);
        ObjStore os = this.createStore(osa);
        if (os == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        if (!force) {
            os = this.promptForAuthentication(os);
        }
        try {
            this.openStore(os);
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        try {
            object = os.retrieve(lookupName);
        }
        catch (NameNotFoundException nnfe) {
            Globals.stdErrPrintln(ar.getKString("A3051", lookupName));
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            return 1;
        }
        if (object != null) {
            if (!force) {
                input = this.getUserInput(ar.getString("A5001"), noShort);
            }
            if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
                try {
                    os.delete(lookupName);
                }
                catch (Exception e) {
                    this.handleRunCommandExceptions(e, lookupName);
                    exitcode = 1;
                }
                if (exitcode == 0) {
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(ar.getString("A1021"));
                } else {
                    Globals.stdOutPrintln("");
                    Globals.stdOutPrintln(ar.getString("A1028"));
                }
            } else if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1024"));
            } else {
                Globals.stdOutPrintln(ar.getString("A1026", input));
                Globals.stdOutPrintln("");
                Globals.stdOutPrintln(ar.getString("A1024"));
                exitcode = 1;
            }
        } else {
            Globals.stdErrPrintln(ar.getKString("A3051"), lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1028"));
            exitcode = 1;
        }
        return exitcode;
    }

    private void printQueryCmdDescription(String lookupName, ObjStoreAttrs osa) {
        Globals.stdOutPrintln(ar.getString("A1105"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1106"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
    }

    private int runQueryCommand(ObjMgrProperties objMgrProps) {
        int exitcode = 0;
        String lookupName = objMgrProps.getLookupName();
        Object object = null;
        boolean force = objMgrProps.forceModeSet();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        this.checkObjStoreAttrs(osa);
        this.printQueryCmdDescription(lookupName, osa);
        ObjStore os = this.createStore(osa);
        if (os == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1030"));
            return 1;
        }
        if (!force) {
            os = this.promptForAuthentication(os);
        }
        try {
            this.openStore(os);
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1030"));
            return 1;
        }
        try {
            object = os.retrieve(lookupName);
        }
        catch (NameNotFoundException nnfe) {
            Globals.stdErrPrintln(ar.getKString("A3051", lookupName));
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1030"));
            return 1;
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1030"));
            return 1;
        }
        if (object != null) {
            ObjMgrPrinter omp = new ObjMgrPrinter(2, 4);
            omp.printJMSObject(object);
            Globals.stdOutPrintln("");
            ObjMgrPrinter.printReadOnly(((AdministeredObject)object).isReadOnly());
        } else {
            Globals.stdErrPrintln(ar.getKString("A3051", lookupName));
            exitcode = 1;
        }
        if (exitcode == 0) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1029"));
        } else {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1030"));
        }
        return exitcode;
    }

    private void printListCmdDescription(String type, ObjStoreAttrs osa) {
        String typeString = Utils.getObjTypeString(type);
        if (typeString == null) {
            Globals.stdOutPrintln(ar.getString("A1107"));
        } else {
            Globals.stdOutPrintln(ar.getString("A1108", typeString));
        }
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(osa, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
    }

    private int runListCommand(ObjMgrProperties objMgrProps) {
        int exitcode = 0;
        String type = objMgrProps.getObjType();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        this.checkObjStoreAttrs(osa);
        boolean force = objMgrProps.forceModeSet();
        this.printListCmdDescription(type, osa);
        ObjStore os = this.createStore(osa);
        if (os == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1033"));
            return 1;
        }
        if (!force) {
            os = this.promptForAuthentication(os);
        }
        try {
            this.openStore(os);
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1033"));
            return 1;
        }
        exitcode = type != null ? this.listByType(os, type) : this.listAll(os);
        if (exitcode == 0) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1032"));
        } else {
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1033"));
        }
        return exitcode;
    }

    private void printUpdateCmdDescription(String type, String lookupName, Properties objProps, ObjStoreAttrs osa, String readOnlyValue) {
        Globals.stdOutPrintln(ar.getString("A1109"));
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(lookupName);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1111"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter omp = new ObjMgrPrinter(objProps, 2, 4);
        omp.print();
        Globals.stdOutPrintln("");
        ObjMgrPrinter.printReadOnly(readOnlyValue);
        Globals.stdOutPrintln("");
        Globals.stdOutPrintln(ar.getString("A1112"));
        Globals.stdOutPrintln("");
        ObjMgrPrinter ompOsa = new ObjMgrPrinter(osa, 2, 4);
        ompOsa.print();
        Globals.stdOutPrintln("");
    }

    private int runUpdateCommand(ObjMgrProperties objMgrProps) {
        int exitcode = 0;
        String input = null;
        Object object = null;
        String type = null;
        String yes = ar.getString("A5016");
        String yesShort = ar.getString("A5015");
        String no = ar.getString("A5018");
        String noShort = ar.getString("A5017");
        String lookupName = objMgrProps.getLookupName();
        boolean force = objMgrProps.forceModeSet();
        ObjStoreAttrs osa = objMgrProps.getObjStoreAttrs();
        this.checkObjStoreAttrs(osa);
        Properties objProps = objMgrProps.getObjProperties();
        type = objMgrProps.getObjType();
        Attributes bindAttrs = objMgrProps.getBindAttrs();
        this.printUpdateCmdDescription(type, lookupName, objProps, osa, objMgrProps.readOnlyValue());
        ObjStore os = this.createStore(osa);
        if (os == null) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1031"));
            return 1;
        }
        if (!force) {
            os = this.promptForAuthentication(os);
        }
        try {
            this.openStore(os);
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1031"));
            return 1;
        }
        try {
            object = os.retrieve(lookupName);
        }
        catch (NameNotFoundException nnfe) {
            Globals.stdErrPrintln(ar.getKString("A3051", lookupName));
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1031"));
            return 1;
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e, lookupName);
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1031"));
            return 1;
        }
        if (object != null) {
            if ((type = this.checkObjectType(object, type)) == null) {
                Globals.stdOutPrintln("");
                Globals.stdErrPrintln(ar.getString("A1031"));
                return 1;
            }
        } else {
            Globals.stdErrPrintln(ar.getKString("A3051", lookupName));
            Globals.stdOutPrintln("");
            Globals.stdErrPrintln(ar.getString("A1031"));
            return 1;
        }
        if (!force) {
            if (object instanceof AdministeredObject) {
                AdministeredObject adminObj = (AdministeredObject)object;
                String curVersion = adminObj.getVERSION();
                String objVersion = adminObj.getStoredVersion();
                if (!adminObj.isStoredVersionCompatible()) {
                    Globals.stdErrPrintln(ar.getString("A2004", objVersion, curVersion));
                }
            }
            input = this.getUserInput(ar.getString("A5002"), noShort);
        }
        if (noShort.equalsIgnoreCase(input) || no.equalsIgnoreCase(input)) {
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1025"));
        } else if (yesShort.equalsIgnoreCase(input) || yes.equalsIgnoreCase(input) || force) {
            Object updatedObject = this.updateObject(object, type, objMgrProps);
            if (updatedObject == null) {
                return 1;
            }
            try {
                if (bindAttrs.size() > 0) {
                    os.add(lookupName, updatedObject, bindAttrs, true);
                } else {
                    os.add(lookupName, updatedObject, true);
                }
            }
            catch (NameAlreadyExistsException naee) {
                exitcode = 1;
            }
            catch (Exception e) {
                this.handleRunCommandExceptions(e, lookupName);
                exitcode = 1;
            }
            if (exitcode == 0) {
                if (!force) {
                    Globals.stdErrPrintln("");
                }
                Globals.stdOutPrintln(ar.getString("A1022"));
            } else {
                Globals.stdErrPrintln("");
                Globals.stdErrPrintln(ar.getString("A1031"));
            }
        } else {
            Globals.stdOutPrintln(ar.getString("A1026", input));
            Globals.stdErrPrintln("");
            Globals.stdOutPrintln(ar.getString("A1025"));
            exitcode = 1;
        }
        return exitcode;
    }

    private String checkObjectType(Object object, String type) {
        if (type == null) {
            if (object instanceof Topic) {
                type = "t";
            } else if (object instanceof Queue) {
                type = "q";
            } else if (object instanceof XAQueueConnectionFactory) {
                type = "xqf";
            } else if (object instanceof XATopicConnectionFactory) {
                type = "xcf";
            } else if (object instanceof XAConnectionFactory) {
                type = "xtf";
            } else if (object instanceof TopicConnectionFactory) {
                type = "tf";
            } else if (object instanceof QueueConnectionFactory) {
                type = "qf";
            } else if (object instanceof ConnectionFactory) {
                type = "cf";
            }
        } else if (!(object instanceof Topic && "t".equals(type) || object instanceof Queue && "q".equals(type) || object instanceof XATopicConnectionFactory && "xtf".equals(type) || object instanceof XAQueueConnectionFactory && "xqf".equals(type) || object instanceof XAConnectionFactory && "xcf".equals(type) || object instanceof QueueConnectionFactory && "qf".equals(type) || object instanceof TopicConnectionFactory && "tf".equals(type) || object instanceof ConnectionFactory && "cf".equals(type))) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3058"));
            return null;
        }
        return type;
    }

    private Object updateObject(Object object, String type, ObjMgrProperties objMgrProps) {
        Properties objProps = objMgrProps.getObjProperties();
        Object updatedObject = null;
        String readOnlyValue = objMgrProps.readOnlyValue();
        try {
            if (type.equals("q")) {
                updatedObject = JMSObjFactory.updateQueue(object, objProps, readOnlyValue);
            } else if (type.equals("t")) {
                updatedObject = JMSObjFactory.updateTopic(object, objProps, readOnlyValue);
            } else if (type.equals("qf")) {
                updatedObject = JMSObjFactory.updateQueueConnectionFactory(object, objProps, readOnlyValue);
            } else if (type.equals("tf")) {
                updatedObject = JMSObjFactory.updateTopicConnectionFactory(object, objProps, readOnlyValue);
            } else if (type.equals("cf")) {
                updatedObject = JMSObjFactory.updateConnectionFactory(object, objProps, readOnlyValue);
            } else if (type.equals("xqf")) {
                updatedObject = JMSObjFactory.updateXAQueueConnectionFactory(object, objProps, readOnlyValue);
            } else if (type.equals("xtf")) {
                updatedObject = JMSObjFactory.updateXATopicConnectionFactory(object, objProps, readOnlyValue);
            } else if (type.equals("xcf")) {
                updatedObject = JMSObjFactory.updateXAConnectionFactory(object, objProps, readOnlyValue);
            }
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e);
            Globals.stdOutPrintln("");
            Globals.stdOutPrintln(ar.getString("A1031"));
            return null;
        }
        return updatedObject;
    }

    private int listByType(ObjStore os, String type) {
        Vector v = null;
        try {
            v = os.list();
        }
        catch (NameNotFoundException nnfe) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
            return 1;
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e);
            return 1;
        }
        ObjMgrPrinter omp = new ObjMgrPrinter(2, 4);
        Object[] row = new String[2];
        row[0] = ar.getString("A1044");
        row[1] = ar.getString("A1045");
        omp.addTitle((String[])row);
        for (int i = 0; i < v.size(); ++i) {
            NameClassPair obj = (NameClassPair)v.get(i);
            if (!(type.equals("t") && Topic.class.getName().equals(obj.getClassName()) || type.equals("q") && Queue.class.getName().equals(obj.getClassName()) || type.equals("tf") && TopicConnectionFactory.class.getName().equals(obj.getClassName()) || type.equals("qf") && QueueConnectionFactory.class.getName().equals(obj.getClassName()) || type.equals("cf") && ConnectionFactory.class.getName().equals(obj.getClassName()) || type.equals("xtf") && XATopicConnectionFactory.class.getName().equals(obj.getClassName()) || type.equals("xqf") && XAQueueConnectionFactory.class.getName().equals(obj.getClassName())) && (!type.equals("xcf") || !XAConnectionFactory.class.getName().equals(obj.getClassName()))) continue;
            row[0] = obj.getName();
            row[1] = obj.getClassName();
            omp.add(row);
        }
        omp.print();
        return 0;
    }

    private int listAll(ObjStore os) {
        Vector v = null;
        try {
            v = os.list();
        }
        catch (NameNotFoundException nnfe) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3052"));
            return 1;
        }
        catch (Exception e) {
            this.handleRunCommandExceptions(e);
            return 1;
        }
        ObjMgrPrinter omp = new ObjMgrPrinter(2, 4);
        Object[] row = new String[2];
        row[0] = ar.getString("A1044");
        row[1] = ar.getString("A1045");
        omp.addTitle((String[])row);
        for (int i = 0; i < v.size(); ++i) {
            NameClassPair obj = (NameClassPair)v.get(i);
            if (!Topic.class.getName().equals(obj.getClassName()) && !Queue.class.getName().equals(obj.getClassName()) && !TopicConnectionFactory.class.getName().equals(obj.getClassName()) && !QueueConnectionFactory.class.getName().equals(obj.getClassName()) && !ConnectionFactory.class.getName().equals(obj.getClassName()) && !XATopicConnectionFactory.class.getName().equals(obj.getClassName()) && !XAQueueConnectionFactory.class.getName().equals(obj.getClassName()) && !XAConnectionFactory.class.getName().equals(obj.getClassName())) continue;
            row[0] = obj.getName();
            row[1] = obj.getClassName();
            omp.add(row);
        }
        omp.print();
        return 0;
    }

    private String getUserInput(String question) {
        return this.getUserInput(question, null);
    }

    private String getUserInput(String question, String defaultResponse) {
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            Globals.stdOutPrint(question);
            String s = in.readLine();
            if (s.equals("") && defaultResponse != null) {
                s = defaultResponse;
            }
            return s;
        }
        catch (IOException ex) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3081"));
            return null;
        }
    }

    private String getPassword(String question) {
        Password pw = new Password();
        if (pw.echoPassword()) {
            Globals.stdOutPrintln(ar.getString("A2015"));
        }
        Globals.stdOutPrint(question);
        return pw.getPassword();
    }

    private void handleRunCommandExceptions(Exception e) {
        this.handleRunCommandExceptions(e, null);
    }

    private void handleRunCommandExceptions(Exception e, String lookupName) {
        if (e instanceof InitializationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3050"));
        } else if (e instanceof AuthenticationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3053"));
        } else if (e instanceof AuthenticationNotSupportedException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3054"));
        } else if (e instanceof NoPermissionException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3055"));
        } else if (e instanceof CommunicationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3056"));
        } else if (e instanceof InvalidPropertyException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3070", e.getMessage()));
            Globals.stdErrPrintln("");
            Globals.stdErrPrintln(ar.getString("A1623"));
        } else if (e instanceof InvalidPropertyValueException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3072", e.getMessage()));
        } else if (e instanceof ReadOnlyPropertyException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3071"));
        } else if (e instanceof SchemaViolationException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3057"));
        } else if (e instanceof GeneralNamingException) {
            Exception newe = ((GeneralNamingException)e).getLinkedException();
            if (newe instanceof UnsupportedVersionNumberException) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3059", ((UnsupportedVersionNumberException)newe).getExplanation(), lookupName));
            } else if (newe instanceof MissingVersionNumberException) {
                Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3060", lookupName));
            } else {
                Globals.stdErrPrintln(newe.toString());
            }
        } else if (e instanceof ObjStoreException) {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A3061"));
            Globals.stdErrPrintln(e.toString());
            Globals.stdErrPrintln(((ObjStoreException)e).getLinkedException().toString());
        } else {
            Globals.stdErrPrintln(ar.getString("A1001"), ar.getKString("A4000"));
            Globals.stdErrPrintln(e.toString());
        }
    }

    private void checkObjStoreAttrs(ObjStoreAttrs osa) {
        String[] mandatoryAttrs = new String[]{"java.naming.factory.initial", "java.naming.provider.url"};
        for (int i = 0; i < mandatoryAttrs.length; ++i) {
            String propName = (String)osa.get(mandatoryAttrs[i]);
            if (propName != null) continue;
            Globals.stdErrPrintln(ar.getString("A2002", mandatoryAttrs[i]));
        }
        System.out.println("");
    }

    private ObjStore promptForAuthentication(ObjStore os) {
        ObjStoreAttrs osa = os.getObjStoreAttrs();
        Vector missingAuthInfo = os.checkAuthentication(osa);
        int missingAuthInfoSize = missingAuthInfo.size();
        boolean carriageReturnNeeded = false;
        for (int i = 0; i < missingAuthInfoSize; ++i) {
            carriageReturnNeeded = true;
            String name = (String)missingAuthInfo.elementAt(i);
            String value = null;
            value = name.equals("java.naming.security.credentials") ? this.getPassword(ar.getString("A5019", name)) : this.getUserInput(ar.getString("A5019", name));
            os.addObjStoreAttr(name, value);
        }
        if (carriageReturnNeeded) {
            Globals.stdOutPrintln("");
        }
        return os;
    }
}

