/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.lucene;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.derby.io.StorageFile;
import org.apache.derby.optional.api.LuceneIndexDescriptor;
import org.apache.derby.optional.api.LuceneUtils;
import org.apache.derby.optional.lucene.DerbyLuceneDir;
import org.apache.derby.optional.lucene.LuceneSupport;
import org.apache.derby.optional.utils.ToolUtilities;
import org.apache.derby.vti.StringColumnVTI;
import org.apache.derby.vti.VTIContext;
import org.apache.derby.vti.VTITemplate;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;

class LuceneQueryVTI
extends StringColumnVTI {
    private Connection _connection;
    private String _queryText;
    private int _windowSize;
    private Float _scoreCeiling;
    private String _schema;
    private String _table;
    private String _column;
    private ScoreDoc[] _hits;
    private IndexReader _indexReader;
    private IndexSearcher _searcher;
    private int _hitIndex = -1;
    private int _minKeyID;
    private int _maxKeyID;
    private int _docIDColumnID;
    private int _scoreColumnID;
    private boolean _wasNull;

    LuceneQueryVTI(String string, int n, Float f) throws SQLException {
        super(null);
        LuceneSupport.checkNotNull("QUERY", string);
        this._connection = LuceneSupport.getDefaultConnection();
        this._queryText = string;
        this._windowSize = n;
        this._scoreCeiling = f;
    }

    public String getRawColumn(int n) throws SQLException {
        this._wasNull = false;
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (this.isKeyID(n)) {
                return this._searcher.doc(n2).get(this.getColumnName(n));
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public boolean getBoolean(int n) throws SQLException {
        String string = this.getRawColumn(n);
        if (string == null) {
            this._wasNull = true;
            return false;
        }
        return Boolean.valueOf(string);
    }

    public float getFloat(int n) throws SQLException {
        try {
            if (n == this._scoreColumnID) {
                return this.getScoreDoc().score;
            }
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return 0.0f;
                }
                return number.floatValue();
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public double getDouble(int n) throws SQLException {
        try {
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return 0.0;
                }
                return number.doubleValue();
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public byte getByte(int n) throws SQLException {
        return (byte)this.getInt(n);
    }

    public short getShort(int n) throws SQLException {
        return (short)this.getInt(n);
    }

    public long getLong(int n) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return 0L;
                }
                return number.longValue();
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public Date getDate(int n) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return null;
                }
                return new Date(number.longValue());
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public Time getTime(int n) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return null;
                }
                return new Time(number.longValue());
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return null;
                }
                return new Timestamp(number.longValue());
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    public int getInt(int n) throws SQLException {
        this._wasNull = false;
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (n == this._docIDColumnID) {
                return n2;
            }
            if (this.isKeyID(n)) {
                Number number = this.getNumberValue(n);
                if (number == null) {
                    return 0;
                }
                return number.intValue();
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    private Number getNumberValue(int n) throws IOException {
        IndexableField indexableField = this._searcher.doc(this.getScoreDoc().doc).getField(this.getColumnName(n));
        if (indexableField == null) {
            this._wasNull = true;
            return null;
        }
        this._wasNull = false;
        Number number = indexableField.numericValue();
        return number;
    }

    public byte[] getBytes(int n) throws SQLException {
        try {
            ScoreDoc scoreDoc = this.getScoreDoc();
            int n2 = scoreDoc.doc;
            if (this.isKeyID(n)) {
                BytesRef bytesRef;
                Document document = this._searcher.doc(n2);
                String string = this.getColumnName(n);
                if (string != null && (bytesRef = document.getBinaryValue(string)) != null) {
                    return bytesRef.bytes;
                }
                this._wasNull = true;
                return null;
            }
            throw this.invalidColumnPosition(n);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
    }

    private SQLException invalidColumnPosition(int n) {
        return ToolUtilities.newSQLException("XCL14.S", n, this.getColumnCount());
    }

    private ScoreDoc getScoreDoc() throws IOException {
        return this._hits[this._hitIndex];
    }

    public boolean next() throws SQLException {
        this._wasNull = false;
        if (this._schema == null) {
            this.initScan();
        }
        ++this._hitIndex;
        if (this._hitIndex < this._hits.length) {
            return true;
        }
        this.closeReader();
        return false;
    }

    public void close() throws SQLException {
        this._hits = null;
        this._hitIndex = 0;
        this.closeReader();
    }

    public boolean wasNull() throws SQLException {
        return this._wasNull;
    }

    protected void finalize() {
        try {
            if (this._indexReader != null) {
                this._indexReader.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void closeReader() throws SQLException {
        if (this._indexReader == null) {
            return;
        }
        try {
            this._indexReader.close();
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
        finally {
            this._indexReader = null;
        }
    }

    private void initScan() throws SQLException {
        try {
            VTIContext vTIContext = this.getContext();
            this._schema = vTIContext.vtiSchema();
            String[] stringArray = LuceneSupport.decodeFunctionName(vTIContext.vtiTable());
            this._table = stringArray[0];
            this._column = stringArray[1];
            VTITemplate.ColumnDescriptor[] columnDescriptorArray = this.getReturnTableSignature(this._connection);
            String[] stringArray2 = new String[columnDescriptorArray.length];
            for (int i = 0; i < columnDescriptorArray.length; ++i) {
                stringArray2[i] = columnDescriptorArray[i].columnName;
            }
            this.setColumnNames(stringArray2);
            this._scoreColumnID = this.getColumnCount();
            this._docIDColumnID = this._scoreColumnID - 1;
            this._maxKeyID = this._docIDColumnID - 1;
            this._minKeyID = 1;
            this.vetPrivileges();
            String string = LuceneSupport.delimitID(this._column);
            DerbyLuceneDir derbyLuceneDir = LuceneSupport.getDerbyLuceneDir(this._connection, this._schema, this._table, string);
            StorageFile storageFile = LuceneSupport.getIndexPropertiesFile(derbyLuceneDir);
            Properties properties = LuceneQueryVTI.readIndexProperties(storageFile);
            String string2 = properties.getProperty("derby.lucene.index.descriptor.maker");
            LuceneIndexDescriptor luceneIndexDescriptor = LuceneQueryVTI.getIndexDescriptor(string2);
            Analyzer analyzer = luceneIndexDescriptor.getAnalyzer();
            QueryParser queryParser = luceneIndexDescriptor.getQueryParser();
            this.vetLuceneVersion(properties.getProperty("derby.lucene.version"));
            this._indexReader = LuceneQueryVTI.getIndexReader(derbyLuceneDir);
            this._searcher = new IndexSearcher(this._indexReader);
            Query query = queryParser.parse(this._queryText);
            TopScoreDocCollector topScoreDocCollector = TopScoreDocCollector.create((int)this._windowSize, (boolean)true);
            if (this._scoreCeiling != null) {
                topScoreDocCollector = TopScoreDocCollector.create((int)this._windowSize, (ScoreDoc)new ScoreDoc(0, this._scoreCeiling.floatValue()), (boolean)true);
            }
            this.searchAndScore(query, topScoreDocCollector);
        }
        catch (IOException iOException) {
            throw ToolUtilities.wrap(iOException);
        }
        catch (ParseException parseException) {
            throw ToolUtilities.wrap(parseException);
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw ToolUtilities.wrap(privilegedActionException);
        }
    }

    private void vetLuceneVersion(String string) throws SQLException {
        Version version = LuceneUtils.currentVersion();
        Version version2 = null;
        try {
            version2 = Version.parseLeniently((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (version2 == null || !version.onOrAfter(version2)) {
            throw ToolUtilities.newSQLException("42XBK", version.toString(), string);
        }
    }

    private void vetPrivileges() throws SQLException {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.getColumnCount() - 2;
        stringBuilder.append("select ");
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(LuceneSupport.delimitID(this.getColumnName(i + 1)));
        }
        stringBuilder.append(", " + LuceneSupport.delimitID(this._column));
        stringBuilder.append(" from " + LuceneSupport.makeTableName(this._schema, this._table));
        stringBuilder.append(" where 1=2");
        this._connection.prepareStatement(stringBuilder.toString()).executeQuery().close();
    }

    private boolean isKeyID(int n) {
        return n > 0 && n <= this._maxKeyID;
    }

    private static IndexReader getIndexReader(final DerbyLuceneDir derbyLuceneDir) throws IOException, PrivilegedActionException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<IndexReader>(){

                @Override
                public IndexReader run() throws IOException {
                    return DirectoryReader.open((Directory)derbyLuceneDir);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private static Properties readIndexProperties(final StorageFile storageFile) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Properties>(){

                @Override
                public Properties run() throws IOException {
                    return LuceneSupport.readIndexPropertiesNoPrivs(storageFile);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    private static LuceneIndexDescriptor getIndexDescriptor(final String string) throws PrivilegedActionException, SQLException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<LuceneIndexDescriptor>(){

            @Override
            public LuceneIndexDescriptor run() throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException {
                return LuceneSupport.getIndexDescriptorNoPrivs(string);
            }
        });
    }

    private void searchAndScore(final Query query, final TopScoreDocCollector topScoreDocCollector) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IOException {
                    LuceneQueryVTI.this._searcher.search(query, (Collector)topScoreDocCollector);
                    TopDocs topDocs = topScoreDocCollector.topDocs();
                    LuceneQueryVTI.access$102(LuceneQueryVTI.this, topDocs.scoreDocs);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getCause();
        }
    }

    static /* synthetic */ ScoreDoc[] access$102(LuceneQueryVTI luceneQueryVTI, ScoreDoc[] scoreDocArray) {
        luceneQueryVTI._hits = scoreDocArray;
        return scoreDocArray;
    }
}

