/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class JvmOptions {
    Map<String, String> sysProps = new LinkedHashMap<String, String>();
    Map<String, String> xxProps = new LinkedHashMap<String, String>();
    Map<String, String> xProps = new LinkedHashMap<String, String>();
    Map<String, String> longProps = new LinkedHashMap<String, String>();
    Map<String, String> plainProps = new LinkedHashMap<String, String>();
    int osgiPort = -1;

    JvmOptions(List<String> options) throws GFLauncherException {
        for (String s : options) {
            if ((s = StringUtils.removeEnclosingQuotes((String)s)).startsWith("-D")) {
                this.addSysProp(s);
                continue;
            }
            if (s.startsWith("-XX")) {
                this.addXxProp(s);
                continue;
            }
            if (s.startsWith("-X")) {
                this.addXProp(s);
                continue;
            }
            if (s.startsWith("--")) {
                this.addLongProp(s);
                continue;
            }
            if (s.startsWith("-")) {
                this.addPlainProp(s);
                continue;
            }
            throw new GFLauncherException("UnknownJvmOptionFormat", s);
        }
        this.filter();
        this.addMissing();
        this.setOsgiPort();
    }

    public String toString() {
        List<String> options = this.toList();
        StringBuilder sb = new StringBuilder();
        for (String option : options) {
            sb.append(option).append('\n');
        }
        return sb.toString();
    }

    List<String> toList() {
        String value;
        ArrayList<String> options = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.xxProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                options.add("-XX" + entry.getKey() + "=" + value);
                continue;
            }
            options.add("-XX" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.xProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                options.add("-X" + entry.getKey() + "=" + value);
                continue;
            }
            options.add("-X" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.longProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                options.add("--" + entry.getKey() + "=" + value);
                continue;
            }
            options.add("--" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.plainProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                options.add("-" + entry.getKey() + "=" + value);
                continue;
            }
            options.add("-" + entry.getKey());
        }
        for (Map.Entry<String, String> entry : this.sysProps.entrySet()) {
            value = entry.getValue();
            if (value != null) {
                options.add("-D" + entry.getKey() + "=" + value);
                continue;
            }
            options.add("-D" + entry.getKey());
        }
        return this.postProcessOrdering(options);
    }

    Map<String, String> getCombinedMap() {
        HashMap<String, String> all = new HashMap<String, String>(this.plainProps);
        all.putAll(this.longProps);
        all.putAll(this.xProps);
        all.putAll(this.xxProps);
        all.putAll(this.sysProps);
        return all;
    }

    int getOsgiPort() {
        return this.osgiPort;
    }

    private void addLongProp(String s) {
        s = s.substring(2);
        CompoundNameValue nv = new CompoundNameValue(s);
        this.longProps.put(nv.name, nv.value);
    }

    private void addPlainProp(String s) {
        s = s.substring(1);
        NameValue nv = new NameValue(s);
        this.plainProps.put(nv.name, nv.value);
    }

    private void addSysProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.sysProps.put(nv.name, nv.value);
    }

    private void addXProp(String s) {
        s = s.substring(2);
        NameValue nv = new NameValue(s);
        this.xProps.put(nv.name, nv.value);
    }

    private void addXxProp(String s) {
        s = s.substring(3);
        NameValue nv = new NameValue(s);
        this.xxProps.put(nv.name, nv.value);
    }

    private List<String> postProcessOrdering(List<String> unsorted) {
        ArrayList<String> sorted = new ArrayList<String>(unsorted.size());
        for (String s : unsorted) {
            if (!this.hasMagic(s)) continue;
            sorted.add(s);
        }
        for (String s : unsorted) {
            if (this.hasMagic(s)) continue;
            sorted.add(s);
        }
        return sorted;
    }

    private boolean hasMagic(String s) {
        String magic = "-XX:+Unlock";
        return s != null && s.startsWith("-XX:+Unlock");
    }

    private void filter() {
        String key = "javax.management.builder.initial";
        String forbiddenStart = "com.sun.enterprise";
        String forbiddenEnd = "AppServerMBeanServerBuilder";
        String val = this.sysProps.get("javax.management.builder.initial");
        if (val != null && val.startsWith("com.sun.enterprise") && val.endsWith("AppServerMBeanServerBuilder")) {
            this.sysProps.remove("javax.management.builder.initial");
        }
        if (OS.isDarwin() && System.getProperty("java.vm.vendor").equals("Apple Inc.")) {
            Pattern pattern = Pattern.compile("d\\d+");
            boolean settingPresent = false;
            for (String propName : this.plainProps.keySet()) {
                Matcher m = pattern.matcher(propName);
                if (!m.matches()) continue;
                settingPresent = true;
            }
            if (!settingPresent) {
                this.addPlainProp("-d32");
            }
        }
    }

    private void addMissing() {
        if (this.sysProps.get("java.util.logging.manager") == null) {
            this.sysProps.put("java.util.logging.manager", "org.glassfish.main.jul.GlassFishLogManager");
        }
        if (this.sysProps.get("java.util.logging.config.block") == null && this.sysProps.get("java.util.logging.manager").equals("org.glassfish.main.jul.GlassFishLogManager")) {
            this.sysProps.put("java.util.logging.config.block", "true");
        }
    }

    private void setOsgiPort() {
        String s = this.sysProps.get("osgi.shell.telnet.port");
        if (!StringUtils.ok((String)s)) {
            return;
        }
        try {
            this.osgiPort = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class CompoundNameValue {
        private String name;
        private String value;

        CompoundNameValue(String s) {
            int index = Math.min(s.indexOf("="), s.indexOf(" "));
            if (index < 0) {
                this.name = s;
            } else {
                int index2 = s.indexOf("=", index + 1);
                if (index2 >= 0) {
                    if (s.charAt(index) == ' ') {
                        s = s.replaceFirst(" ", "=");
                    }
                    index = index2;
                }
                this.name = s.substring(0, index);
                if (index + 1 < s.length()) {
                    this.value = s.substring(index + 1);
                }
            }
        }
    }

    private static class NameValue {
        private String name;
        private String value;

        NameValue(String s) {
            int index = s.indexOf("=");
            if (index < 0) {
                this.name = s;
            } else {
                this.name = s.substring(0, index);
                if (index + 1 < s.length()) {
                    this.value = s.substring(index + 1);
                }
            }
        }
    }
}

