/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.component.factory.basic.GenericFactory;
import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.ViewRootUtil;
import com.sun.jsftemplating.layout.descriptors.ComponentType;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutComposition;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutElementBase;
import com.sun.jsftemplating.layout.descriptors.LayoutInsert;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerDefinition;
import com.sun.jsftemplating.layout.descriptors.handler.IODescriptor;
import com.sun.jsftemplating.layout.facelets.DbFactory;
import com.sun.jsftemplating.layout.facelets.NSContext;
import com.sun.jsftemplating.layout.template.TemplateLayoutDefinitionManager;
import com.sun.jsftemplating.util.FileUtil;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.Util;
import jakarta.faces.context.FacesContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class LayoutDefinitionManager {
    private static final String HD_MAP = "__jsft_HandlerDefs";
    private static final String LDMS = "__jsft_LayoutDefMgrs";
    private static final String LDM_KEYS = "__jsft_LayoutDefMgrKeys";
    private static final String LD_MAP = "__jsft_LayoutDefMap";
    private static final String CT_MAP = "__jsft_ComponentTypeMap";
    private static final String RES_MAP = "__jsft_ResourceMap";
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private static Map<String, ComponentType> _globalComponentTypes = null;
    private static final HandlerDefinition NOOP_HD = new HandlerDefinition("_NOOP_");
    public static final String DEFAULT_TYPE = "Object";
    public static final String LAYOUT_DEFINITION_MANAGER_KEY = "LayoutDefinitionManagerImpl";
    public static final String DEBUG_FLAG = "com.sun.jsftemplating.DEBUG";
    public static final String CACHE_PREFIX = "_LDCache";

    protected LayoutDefinitionManager() {
    }

    public abstract LayoutDefinition getLayoutDefinition(String var1) throws LayoutDefinitionException;

    public abstract boolean accepts(String var1);

    public static LayoutDefinition getLayoutDefinition(FacesContext ctx, String key) throws LayoutDefinitionException {
        String cacheKey = FileUtil.cleanUpPath(key.startsWith("/") ? key : FileUtil.getAbsolutePath(ctx, key));
        LayoutDefinition def = LayoutDefinitionManager.getCachedLayoutDefinition(ctx, cacheKey);
        if (def == null) {
            def = LayoutDefinitionManager.getLayoutDefinitionManager(ctx, key).getLayoutDefinition(key);
            LayoutDefinitionManager.putCachedLayoutDefinition(ctx, cacheKey, def);
        } else {
            def.dispatchInitPageHandlers(ctx, def);
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LayoutComponent getLayoutComponent(FacesContext ctx, String ldKey, String clientId) throws LayoutDefinitionException {
        LayoutElementBase layElt = null;
        if (ldKey != null) {
            layElt = LayoutDefinitionManager.getLayoutDefinition(ctx, ldKey);
            if (layElt == null) {
                throw new LayoutDefinitionException("Unable to find LayoutDefinition ('" + ldKey + "')");
            }
        } else {
            layElt = ViewRootUtil.getLayoutDefinition(FacesContext.getCurrentInstance().getViewRoot());
        }
        Stack<LayoutElement> oldStack = LayoutComposition.getCompositionStack(ctx);
        try {
            LayoutComposition.setCompositionStack(ctx, new Stack<LayoutElement>());
            StringTokenizer tok = new StringTokenizer(clientId, ":");
            String id = null;
            LayoutComponent match = null;
            while (tok.hasMoreTokens()) {
                id = tok.nextToken();
                match = LayoutDefinitionManager.findById(ctx, layElt, id);
                if (match == null) {
                    break;
                }
                layElt = match;
            }
        }
        finally {
            LayoutComposition.setCompositionStack(ctx, oldStack);
        }
        if (layElt instanceof LayoutDefinition) {
            layElt = null;
        }
        return (LayoutComponent)layElt;
    }

    /*
     * Unable to fully structure code
     */
    private static LayoutComponent findById(FacesContext ctx, LayoutElement elt, String id) {
        shouldPop = false;
        if (elt instanceof LayoutComposition) {
            viewId = ((LayoutComposition)elt).getTemplate();
            if (viewId != null) {
                LayoutComposition.push(ctx, elt);
                shouldPop = true;
                try {
                    elt = LayoutDefinitionManager.getLayoutDefinition(ctx, viewId);
                }
                catch (LayoutDefinitionException ex) {
                    if (!((LayoutComposition)elt).isRequired()) ** GOTO lbl16
                    throw ex;
                }
            }
        } else if (elt instanceof LayoutInsert) {
            // empty if block
        }
lbl16:
        // 6 sources

        comp = null;
        for (LayoutElement child : elt.getChildLayoutElements()) {
            if (!child.getId(ctx, null).equals(id) || !(child instanceof LayoutComponent)) continue;
            comp = (LayoutComponent)child;
        }
        if (comp == null) {
            var5_6 = elt.getChildLayoutElements().iterator();
            while (var5_6.hasNext() && (comp = LayoutDefinitionManager.findById(ctx, child = var5_6.next(), id)) == null) {
            }
        }
        if (shouldPop) {
            LayoutComposition.pop(ctx);
        }
        return comp;
    }

    public static LayoutDefinitionManager getLayoutDefinitionManager(FacesContext ctx, String key) throws LayoutDefinitionException {
        List<String> ldms = LayoutDefinitionManager.getLayoutDefinitionManagers(ctx);
        LayoutDefinitionManager mgr = null;
        for (String className : ldms) {
            mgr = LayoutDefinitionManager.getLayoutDefinitionManagerByClass(ctx, className);
            if (!mgr.accepts(key)) continue;
            return mgr;
        }
        throw new LayoutDefinitionException("No LayoutDefinitionManager available for '" + key + "'.  This may mean the file cannot be found, or is unrecognizable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getLayoutDefinitionManagers(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        List<String> keys = null;
        if (ctx != null) {
            keys = (List)ctx.getExternalContext().getApplicationMap().get(LDM_KEYS);
        }
        if (keys == null) {
            String tplFormat;
            Map initParams;
            keys = new ArrayList();
            if (ctx != null && (initParams = ctx.getExternalContext().getInitParameterMap()).containsKey(LAYOUT_DEFINITION_MANAGER_KEY)) {
                keys.add(((String)initParams.get(LAYOUT_DEFINITION_MANAGER_KEY)).trim());
            }
            if (!keys.contains(tplFormat = TemplateLayoutDefinitionManager.class.getName())) {
                keys.add(tplFormat);
            }
            try {
                BufferedReader rdr = null;
                InputStream is = null;
                String line = null;
                Enumeration<URL> urls = Util.getClassLoader(ctx).getResources("META-INF/jsftemplating/FormatDefinition.map");
                while (urls.hasMoreElements()) {
                    try {
                        is = urls.nextElement().openStream();
                        rdr = new BufferedReader(new InputStreamReader(is));
                        line = rdr.readLine();
                        while (line != null) {
                            if (!((line = line.trim()).equals("") || line.startsWith("#") || keys.contains(line))) {
                                keys.add(line);
                            }
                            line = rdr.readLine();
                        }
                    }
                    catch (Throwable throwable) {
                        Util.closeStream(is);
                        throw throwable;
                    }
                    Util.closeStream(is);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(LDM_KEYS, keys);
            }
        }
        return keys;
    }

    public static LayoutDefinitionManager getLayoutDefinitionManagerByClass(FacesContext ctx, String className) {
        LayoutDefinitionManager ldm;
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        HashMap<String, LayoutDefinitionManager> ldms = null;
        if (ctx != null) {
            ldms = (Map)ctx.getExternalContext().getApplicationMap().get(LDMS);
        }
        if (ldms == null) {
            ldms = new HashMap<String, LayoutDefinitionManager>(4);
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(LDMS, ldms);
            }
        }
        if ((ldm = (LayoutDefinitionManager)ldms.get(className)) == null) {
            try {
                ldm = (LayoutDefinitionManager)Util.loadClass(className, className).getMethod("getInstance", null).invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException ex) {
                throw new LayoutDefinitionException("Unable to find LDM: '" + className + "'.", ex);
            }
            catch (NoSuchMethodException ex) {
                throw new LayoutDefinitionException("LDM '" + className + "' does not have a 'getInstance()' method!", ex);
            }
            catch (IllegalAccessException ex) {
                throw new LayoutDefinitionException("Unable to access LDM: '" + className + "'!", ex);
            }
            catch (InvocationTargetException ex) {
                throw new LayoutDefinitionException("Error while attempting to get LDM: '" + className + "'!", ex);
            }
            catch (ClassCastException ex) {
                throw new LayoutDefinitionException("LDM '" + className + "' must extend from '" + LayoutDefinitionManager.class.getName() + " and must be loaded from the same ClassLoader!", ex);
            }
            catch (NullPointerException ex) {
                throw new LayoutDefinitionException(ex);
            }
            ldms.put(className, ldm);
        }
        return ldm;
    }

    private static LayoutDefinition getCachedLayoutDefinition(FacesContext ctx, String key) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        if (LayoutDefinitionManager.isDebug(ctx)) {
            if (ctx != null) {
                return (LayoutDefinition)ctx.getExternalContext().getRequestMap().get(CACHE_PREFIX + key);
            }
            return null;
        }
        return LayoutDefinitionManager.getLayoutDefinitionMap(ctx).get(key);
    }

    private static Map<String, LayoutDefinition> getLayoutDefinitionMap(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        ConcurrentHashMap ldMap = null;
        if (ctx != null) {
            ldMap = (ConcurrentHashMap)ctx.getExternalContext().getApplicationMap().get(LD_MAP);
        }
        if (ldMap == null) {
            ldMap = new ConcurrentHashMap(400, 0.75f, 2);
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(LD_MAP, ldMap);
            }
        }
        return ldMap;
    }

    public static void putCachedLayoutDefinition(FacesContext ctx, String key, LayoutDefinition value) {
        if (LayoutDefinitionManager.isDebug(ctx)) {
            if (ctx != null) {
                ctx.getExternalContext().getRequestMap().put(CACHE_PREFIX + key, value);
            }
        } else {
            LayoutDefinitionManager.getLayoutDefinitionMap(ctx).put(key, value);
        }
    }

    public Object getAttribute(String key) {
        return this._attributes.get(key);
    }

    public void setAttribute(String key, Object value) {
        this._attributes.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ComponentType> getGlobalComponentTypes(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        ConcurrentHashMap<String, ComponentType> types = null;
        if (ctx != null) {
            types = (ConcurrentHashMap<String, ComponentType>)ctx.getExternalContext().getApplicationMap().get(CT_MAP);
        }
        if (types == null) {
            types = new ConcurrentHashMap<String, ComponentType>(200, 0.75f, 2);
            try {
                Properties props = null;
                URL url = null;
                String id = null;
                Enumeration<URL> urls = Util.getClassLoader(types).getResources("META-INF/jsftemplating/UIComponentFactory.map");
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    props = new Properties();
                    InputStream is = null;
                    try {
                        is = url.openStream();
                        props.load(is);
                        for (Map.Entry<Object, Object> entry : props.entrySet()) {
                            id = (String)entry.getKey();
                            types.put(id, new ComponentType(id, (String)entry.getValue()));
                        }
                    }
                    finally {
                        Util.closeStream(is);
                    }
                }
                LayoutDefinitionManager.readComponentsFromTaglibXml(types);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(CT_MAP, types);
            }
        }
        return types;
    }

    private static void readComponentsFromTaglibXml(Map<String, ComponentType> types) throws IOException {
        Enumeration<URL> urls = Util.getClassLoader(types).getResources("META-INF/");
        HashSet<URL> files = new HashSet<URL>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            conn.setDefaultUseCaches(false);
            if (!(conn instanceof JarURLConnection)) continue;
            JarURLConnection jarConn = (JarURLConnection)conn;
            JarFile jarFile = jarConn.getJarFile();
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith("META-INF") || !entryName.endsWith("taglib.xml")) continue;
                Enumeration<URL> e = Util.getClassLoader(types).getResources(entryName);
                while (e.hasMoreElements()) {
                    files.add(e.nextElement());
                }
            }
        }
        if (files.size() > 0) {
            for (URL url : files) {
                LayoutDefinitionManager.processTaglibXml(url, types);
            }
        }
    }

    private static void processTaglibXml(URL url, Map<String, ComponentType> types) {
        InputStream is = null;
        try {
            is = url.openStream();
            DocumentBuilder builder = DbFactory.getInstance();
            Document document = builder.parse(is);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NSContext ns = new NSContext();
            ns.addNamespace("f", "jakarta.faces.facelets");
            xpath.setNamespaceContext(ns);
            String nameSpace = xpath.evaluate("/f:facelet-taglib/f:namespace", document);
            NodeList nl = (NodeList)xpath.evaluate("/f:facelet-taglib/f:tag", document, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                String tagName = xpath.evaluate("f:tag-name", node);
                String componentType = xpath.evaluate("f:component/f:component-type", node);
                String id = nameSpace + ":" + tagName;
                types.put(id, new ComponentType(id, GenericFactory.class.getName(), (Serializable)((Object)componentType)));
            }
        }
        catch (Exception e) {
            if (LogUtil.severeEnabled()) {
                LogUtil.severe(e.getMessage());
            }
            throw new RuntimeException(e);
        }
        finally {
            Util.closeStream(is);
        }
    }

    public static ComponentType getGlobalComponentType(FacesContext ctx, String typeID) {
        return LayoutDefinitionManager.getGlobalComponentTypes(ctx).get(typeID);
    }

    public static void addGlobalComponentType(FacesContext ctx, ComponentType type) {
        LayoutDefinitionManager.getGlobalComponentTypes(ctx).put(type.getId(), type);
    }

    public static void clearGlobalComponentTypes(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        if (ctx != null) {
            ctx.getExternalContext().getApplicationMap().remove(CT_MAP);
        }
    }

    public static Map<String, HandlerDefinition> getGlobalHandlerDefinitions() {
        return LayoutDefinitionManager.getGlobalHandlerDefinitions("META-INF/jsftemplating/Handler.map");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized Map<String, HandlerDefinition> getGlobalHandlerDefinitions(String filename) {
        Map<String, HandlerDefinition> handlers = LayoutDefinitionManager.getApplicationHandlerDefinitions(null);
        if (handlers.containsKey(filename)) {
            return handlers;
        }
        handlers = new HashMap<String, HandlerDefinition>(handlers);
        handlers.put(filename, NOOP_HD);
        Properties props = null;
        URL url = null;
        try {
            Enumeration<URL> urls = Util.getClassLoader(filename).getResources(filename);
            InputStream is = null;
            while (urls.hasMoreElements()) {
                try {
                    url = urls.nextElement();
                    props = new Properties();
                    is = url.openStream();
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        if (!((String)entry.getKey()).endsWith(".class")) continue;
                        LayoutDefinitionManager.readGlobalHandlerDefinition(handlers, props, entry);
                    }
                }
                catch (Throwable throwable) {
                    Util.closeStream(is);
                    throw throwable;
                }
                Util.closeStream(is);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx == null) {
            System.out.println("#### FacesContext is null!");
        }
        ctx.getExternalContext().getApplicationMap().put(HD_MAP, handlers);
        return handlers;
    }

    private static Map<String, HandlerDefinition> getApplicationHandlerDefinitions(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        Map map = null;
        if (ctx != null) {
            map = (Map)ctx.getExternalContext().getApplicationMap().get(HD_MAP);
        }
        if (map == null) {
            map = new HashMap();
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(HD_MAP, map);
            }
        }
        return map;
    }

    private static void readGlobalHandlerDefinition(Map<String, HandlerDefinition> hdMap, Map<String, String> props, Map.Entry<Object, Object> entry) {
        String key = (String)entry.getKey();
        key = key.substring(0, key.lastIndexOf(46));
        HandlerDefinition def = new HandlerDefinition(key);
        String value = props.get(key + ".method");
        def.setHandlerMethod((String)entry.getValue(), value);
        def.setInputDefs(LayoutDefinitionManager.readIODefs(props, key, true));
        def.setOutputDefs(LayoutDefinitionManager.readIODefs(props, key, false));
        hdMap.put(key, def);
    }

    private static Map<String, IODescriptor> readIODefs(Map<String, String> map, String key, boolean input) {
        String inOrOut = input ? "input" : "output";
        int count = 0;
        IODescriptor desc = null;
        HashMap<String, IODescriptor> defs = new HashMap<String, IODescriptor>(5);
        String value = map.get(key + "." + inOrOut + "[" + count + "].name");
        while (value != null) {
            String type = map.get(key + "." + inOrOut + "[" + count + "].type");
            if (type == null) {
                type = DEFAULT_TYPE;
            }
            desc = new IODescriptor(value, type);
            defs.put(value, desc);
            if (input) {
                value = map.get(key + "." + inOrOut + "[" + count + "].required");
                if (value != null && Boolean.valueOf(value).booleanValue()) {
                    desc.setRequired(true);
                }
                if ((value = map.get(key + "." + inOrOut + "[" + count + "].defaultValue")) != null && !value.equals("jsfTempNULLString")) {
                    desc.setDefault(value);
                }
            }
            value = map.get(key + "." + inOrOut + "[" + ++count + "].name");
        }
        return defs;
    }

    public static HandlerDefinition getGlobalHandlerDefinition(String id) {
        return LayoutDefinitionManager.getGlobalHandlerDefinitions().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGlobalHandlerDefinition(HandlerDefinition def) {
        Class<LayoutDefinitionManager> clazz = LayoutDefinitionManager.class;
        synchronized (LayoutDefinitionManager.class) {
            LayoutDefinitionManager.getGlobalHandlerDefinitions().put(def.getId(), def);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void clearGlobalHandlerDefinitions(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        if (ctx != null) {
            ctx.getExternalContext().getApplicationMap().remove(HD_MAP);
        }
    }

    public static void addGlobalResource(Resource res) {
        LayoutDefinitionManager.getGlobalResources(null).add(res);
    }

    public static List<Resource> getGlobalResources(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        List globalResources = null;
        if (ctx != null) {
            globalResources = (List)ctx.getExternalContext().getApplicationMap().get(RES_MAP);
        }
        if (globalResources == null) {
            globalResources = new CopyOnWriteArrayList();
            if (ctx != null) {
                ctx.getExternalContext().getApplicationMap().put(RES_MAP, globalResources);
            }
        }
        return globalResources;
    }

    public static void clearGlobalResources(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        if (ctx != null) {
            ctx.getExternalContext().getApplicationMap().remove(RES_MAP);
        }
    }

    public static boolean isDebug() {
        return LayoutDefinitionManager.isDebug(null);
    }

    public static boolean isDebug(FacesContext ctx) {
        if (ctx == null) {
            ctx = FacesContext.getCurrentInstance();
        }
        Object objVal = null;
        if (ctx != null && (objVal = ctx.getExternalContext().getApplicationMap().get(DEBUG_FLAG)) != null) {
            return objVal;
        }
        String flag = System.getProperty(DEBUG_FLAG);
        if (flag == null && ctx != null) {
            flag = ctx.getExternalContext().getInitParameter(DEBUG_FLAG);
        }
        boolean isDebug = false;
        if (ctx != null && flag != null) {
            isDebug = Boolean.parseBoolean(flag);
            ctx.getExternalContext().getApplicationMap().put(DEBUG_FLAG, isDebug);
        }
        return isDebug;
    }

    public static void setDebug(FacesContext ctx, boolean flag) {
        ctx.getExternalContext().getApplicationMap().put(DEBUG_FLAG, flag);
    }
}

