/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLConnection;

public class CachedURLConnection<T>
extends URLConnection {
    private WeakReference<T> weakRef = null;

    public CachedURLConnection(URL url, WeakReference<T> weakRef) {
        super(url);
        if (weakRef == null || weakRef.get() == null) {
            throw new IllegalArgumentException("The weakRef is required in order to create a CachedURLConnection!");
        }
        this.weakRef = weakRef;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            byte[] bytes = null;
            Object obj = this.weakRef.get();
            bytes = obj instanceof byte[] ? (byte[])obj : obj.toString().getBytes();
            return new ByteArrayInputStream(bytes);
        }
        catch (NullPointerException ex) {
            throw new IOException("Cached object was null!");
        }
    }

    @Override
    public void connect() throws IOException {
    }
}

