/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.asm;

import java.io.DataOutputStream;
import java.io.IOException;
import org.glassfish.rmic.tools.asm.ConstantPool;
import org.glassfish.rmic.tools.asm.ConstantPoolData;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;

final class ClassConstantData
extends ConstantPoolData {
    String name;

    ClassConstantData(ConstantPool tab, ClassDeclaration clazz) {
        String sig = clazz.getType().getTypeSignature();
        this.name = sig.substring(1, sig.length() - 1);
        tab.put(this.name);
    }

    ClassConstantData(ConstantPool tab, Type t) {
        this.name = t.getTypeSignature();
        tab.put(this.name);
    }

    @Override
    void write(Environment env, DataOutputStream out, ConstantPool tab) throws IOException {
        out.writeByte(7);
        out.writeShort(tab.index(this.name));
    }

    @Override
    int order() {
        return 1;
    }

    public String toString() {
        return "ClassConstantData[" + this.name + "]";
    }
}

