/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.encoding;

import com.sun.corba.ee.impl.corba.CORBAObjectImpl;
import com.sun.corba.ee.impl.corba.PrincipalImpl;
import com.sun.corba.ee.impl.corba.TypeCodeImpl;
import com.sun.corba.ee.impl.encoding.BufferManagerRead;
import com.sun.corba.ee.impl.encoding.CDRInputStreamBase;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.MarkAndResetHandler;
import com.sun.corba.ee.impl.encoding.RestorableInputStream;
import com.sun.corba.ee.impl.misc.CacheTable;
import com.sun.corba.ee.impl.misc.ClassInfoCache;
import com.sun.corba.ee.impl.misc.ORBUtility;
import com.sun.corba.ee.impl.misc.RepositoryIdFactory;
import com.sun.corba.ee.impl.misc.RepositoryIdInterface;
import com.sun.corba.ee.impl.misc.RepositoryIdStrings;
import com.sun.corba.ee.impl.misc.RepositoryIdUtility;
import com.sun.corba.ee.impl.util.JDKBridge;
import com.sun.corba.ee.impl.util.RepositoryId;
import com.sun.corba.ee.impl.util.Utility;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.IORFactories;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.OMGSystemException;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.orb.ClassCodeBaseHandler;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.presentation.rmi.PresentationDefaults;
import com.sun.corba.ee.spi.presentation.rmi.PresentationManager;
import com.sun.corba.ee.spi.presentation.rmi.StubAdapter;
import com.sun.corba.ee.spi.protocol.ClientDelegate;
import com.sun.corba.ee.spi.trace.CdrRead;
import com.sun.corba.ee.spi.trace.PrimitiveRead;
import com.sun.corba.ee.spi.transport.ByteBufferPool;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.rmi.server.RMIClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import javax.rmi.CORBA.EnumDesc;
import javax.rmi.CORBA.ProxyDesc;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.ValueHandler;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.InvokeHandler;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueFactory;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.SendingContext.RunTime;

@CdrRead
@PrimitiveRead
public class CDRInputStream_1_0
extends CDRInputStreamBase
implements RestorableInputStream {
    protected static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final OMGSystemException omgWrapper = OMGSystemException.self;
    private static final String K_READ_METHOD = "read";
    private static final int MAX_BLOCK_LENGTH = 0x7FFFFF00;
    protected BufferManagerRead bufferManagerRead;
    protected ByteBuffer byteBuffer;
    protected com.sun.corba.ee.spi.orb.ORB orb;
    protected ValueHandler valueHandler = null;
    private CacheTable<java.lang.Object> valueCache = null;
    private CacheTable<String> repositoryIdCache = null;
    private CacheTable<String> codebaseCache = null;
    protected int blockLength = 0x7FFFFF00;
    protected int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    protected int valueIndirection = 0;
    protected int stringIndirection = 0;
    protected boolean isChunked = false;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.BTCConverter charConverter;
    private CodeSetConversion.BTCConverter wcharConverter;
    private boolean specialNoOptionalDataState = false;
    private static final String _id = "IDL:omg.org/CORBA/DataInputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataInputStream:1.0"};
    protected MarkAndResetHandler markAndResetHandler = null;

    final String newEmptyString() {
        return new String("");
    }

    @Override
    public CDRInputStreamBase dup() {
        CDRInputStreamBase result = null;
        try {
            result = (CDRInputStreamBase)this.getClass().newInstance();
        }
        catch (Exception e) {
            throw wrapper.couldNotDuplicateCdrInputStream(e);
        }
        result.init((ORB)this.orb, this.byteBuffer, this.byteBuffer.limit(), this.byteBuffer.order(), this.bufferManagerRead);
        return result;
    }

    @Override
    void init(ORB orb, ByteBuffer byteBuffer, int bufferSize, ByteOrder byteOrder, BufferManagerRead bufferManager) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
        this.bufferManagerRead = bufferManager;
        this.byteBuffer = byteBuffer;
        this.byteBuffer.position(0);
        this.byteBuffer.order(byteOrder);
        this.byteBuffer.limit(bufferSize);
        this.markAndResetHandler = this.bufferManagerRead.getMarkAndResetHandler();
    }

    @Override
    void performORBVersionSpecificInit() {
        this.createRepositoryIdHandlers();
    }

    private void createRepositoryIdHandlers() {
        this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
        this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    @Override
    void setHeaderPadding(boolean headerPadding) {
        throw wrapper.giopVersionError();
    }

    protected final int computeAlignment(int index, int align) {
        int incr;
        if (align > 1 && (incr = index & align - 1) != 0) {
            return align - incr;
        }
        return 0;
    }

    @InfoMethod
    private void notChunked() {
    }

    @CdrRead
    protected void checkBlockLength(int align, int dataSize) {
        if (!this.isChunked) {
            this.notChunked();
            return;
        }
        if (this.specialNoOptionalDataState) {
            throw omgWrapper.rmiiiopOptionalDataIncompatible1();
        }
        boolean checkForEndTag = false;
        if (this.blockLength == this.get_offset()) {
            this.blockLength = 0x7FFFFF00;
            this.start_block();
            if (this.blockLength == 0x7FFFFF00) {
                checkForEndTag = true;
            }
        } else if (this.blockLength < this.get_offset()) {
            throw wrapper.chunkOverflow();
        }
        int requiredNumBytes = this.computeAlignment(this.byteBuffer.position(), align) + dataSize;
        if (this.blockLength != 0x7FFFFF00 && this.blockLength < this.get_offset() + requiredNumBytes) {
            throw omgWrapper.rmiiiopOptionalDataIncompatible2();
        }
        if (checkForEndTag) {
            int nextLong = this.read_long();
            this.byteBuffer.position(this.byteBuffer.position() - 4);
            if (nextLong < 0) {
                throw omgWrapper.rmiiiopOptionalDataIncompatible3();
            }
        }
    }

    @CdrRead
    protected void alignAndCheck(int align, int n) {
        this.checkBlockLength(align, n);
        int alignResult = this.computeAlignment(this.byteBuffer.position(), align);
        this.byteBuffer.position(this.byteBuffer.position() + alignResult);
        if (this.byteBuffer.position() + n > this.byteBuffer.limit()) {
            this.grow(align, n);
        }
    }

    @CdrRead
    protected void grow(int align, int n) {
        this.byteBuffer = this.bufferManagerRead.underflow(this.byteBuffer);
    }

    @Override
    public final void consumeEndian() {
        ByteOrder byteOrder = this.read_boolean() ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.byteBuffer.order(byteOrder);
    }

    @Override
    public final boolean read_boolean() {
        return this.read_octet() != 0;
    }

    @Override
    public final char read_char() {
        this.alignAndCheck(1, 1);
        return this.getConvertedChars(1, this.getCharConverter())[0];
    }

    @Override
    @CdrRead
    public char read_wchar() {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw wrapper.wcharDataInGiop10();
        }
        return (char)this.byteBuffer.getShort();
    }

    @Override
    @CdrRead
    public final byte read_octet() {
        this.alignAndCheck(1, 1);
        return this.byteBuffer.get();
    }

    @Override
    @CdrRead
    public final short read_short() {
        this.alignAndCheck(2, 2);
        return this.byteBuffer.getShort();
    }

    @Override
    public final short read_ushort() {
        return this.read_short();
    }

    @Override
    @CdrRead
    public final int read_long() {
        this.alignAndCheck(4, 4);
        return this.byteBuffer.getInt();
    }

    @Override
    public final int read_ulong() {
        return this.read_long();
    }

    @Override
    @CdrRead
    public final long read_longlong() {
        this.alignAndCheck(8, 8);
        return this.byteBuffer.getLong();
    }

    @Override
    public final long read_ulonglong() {
        return this.read_longlong();
    }

    @Override
    public final float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    @Override
    public final double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    protected final void checkForNegativeLength(int length) {
        if (length < 0) {
            throw wrapper.negativeStringLength(length);
        }
    }

    @CdrRead
    protected final String readStringOrIndirection(boolean allowIndirection) {
        String result = "";
        int len = this.read_long();
        if (allowIndirection) {
            if (len == -1) {
                return null;
            }
            this.stringIndirection = this.get_offset() - 4;
        }
        this.checkForNegativeLength(len);
        result = this.internalReadString(len);
        return result;
    }

    @CdrRead
    private String internalReadString(int len) {
        if (len == 0) {
            return this.newEmptyString();
        }
        char[] result = this.getConvertedChars(len - 1, this.getCharConverter());
        this.read_octet();
        return new String(result, 0, this.getCharConverter().getNumChars());
    }

    @Override
    public final String read_string() {
        return this.readStringOrIndirection(false);
    }

    @Override
    @CdrRead
    public String read_wstring() {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw wrapper.wcharDataInGiop10();
        }
        int len = this.read_long();
        if (len == 0) {
            return this.newEmptyString();
        }
        this.checkForNegativeLength(len);
        char[] c = new char[--len];
        for (int i = 0; i < len; ++i) {
            c[i] = this.read_wchar();
        }
        this.read_wchar();
        return new String(c);
    }

    @Override
    @CdrRead
    public final void read_octet_array(byte[] buffer, int offset, int length) {
        int count;
        if (buffer == null) {
            throw wrapper.nullParam();
        }
        if (length == 0) {
            return;
        }
        this.alignAndCheck(1, 1);
        for (int numWritten = 0; numWritten < length; numWritten += count) {
            if (!this.byteBuffer.hasRemaining()) {
                this.grow(1, 1);
            }
            count = Math.min(length - numWritten, this.byteBuffer.remaining());
            this.byteBuffer.get(buffer, numWritten + offset, count);
        }
    }

    @Override
    public Principal read_Principal() {
        int len = this.read_long();
        byte[] pvalue = new byte[len];
        this.read_octet_array(pvalue, 0, len);
        PrincipalImpl p = new PrincipalImpl();
        p.name(pvalue);
        return p;
    }

    @Override
    @CdrRead
    public TypeCode read_TypeCode() {
        TypeCodeImpl tc = new TypeCodeImpl(this.orb);
        tc.read_value(this.parent);
        return tc;
    }

    @Override
    @CdrRead
    public Any read_any() {
        TypeCodeImpl tc;
        Any any;
        block2: {
            any = null;
            any = this.orb.create_any();
            tc = new TypeCodeImpl(this.orb);
            try {
                tc.read_value(this.parent);
            }
            catch (MARSHAL ex) {
                if (tc.kind().value() == 29) break block2;
                throw ex;
            }
        }
        any.read_value((org.omg.CORBA.portable.InputStream)this.parent, (TypeCode)tc);
        return any;
    }

    @Override
    @CdrRead
    public Object read_Object() {
        return this.read_Object(null);
    }

    @InfoMethod
    private void nullIOR() {
    }

    @InfoMethod
    private void className(String name) {
    }

    @InfoMethod
    private void stubFactory(PresentationManager.StubFactory fact) {
    }

    @Override
    @CdrRead
    public Object read_Object(Class clz) {
        IOR ior = IORFactories.makeIOR(this.orb, this.parent);
        if (ior.isNil()) {
            this.nullIOR();
            return null;
        }
        PresentationManager.StubFactoryFactory sff = com.sun.corba.ee.spi.orb.ORB.getStubFactoryFactory();
        String codeBase = ior.getProfile().getCodebase();
        PresentationManager.StubFactory stubFactory = null;
        if (clz == null) {
            RepositoryId rid = RepositoryId.cache.getId(ior.getTypeId());
            String className = rid.getClassName();
            this.className(className);
            boolean isIDLInterface = rid.isIDLType();
            if (className == null || className.equals("")) {
                stubFactory = null;
            } else {
                try {
                    stubFactory = sff.createStubFactory(className, isIDLInterface, codeBase, null, null);
                }
                catch (Exception exc) {
                    stubFactory = null;
                }
            }
            this.stubFactory(stubFactory);
        } else if (StubAdapter.isStubClass(clz)) {
            stubFactory = PresentationDefaults.makeStaticStubFactory(clz);
            this.stubFactory(stubFactory);
        } else {
            boolean isIDL = ClassInfoCache.get(clz).isAIDLEntity(clz);
            stubFactory = sff.createStubFactory(clz.getName(), isIDL, codeBase, clz, clz.getClassLoader());
            this.stubFactory(stubFactory);
        }
        return CDRInputStream_1_0.internalIORToObject(ior, stubFactory, this.orb);
    }

    @CdrRead
    public static Object internalIORToObject(IOR ior, PresentationManager.StubFactory stubFactory, com.sun.corba.ee.spi.orb.ORB orb) {
        java.lang.Object servant = ior.getProfile().getServant();
        if (servant != null) {
            if (servant instanceof Tie) {
                String codebase = ior.getProfile().getCodebase();
                Object objref = (Object)Utility.loadStub((Tie)servant, stubFactory, codebase, false);
                if (objref != null) {
                    return objref;
                }
                throw wrapper.readObjectException();
            }
            if (servant instanceof Object) {
                if (!(servant instanceof InvokeHandler)) {
                    return (Object)servant;
                }
            } else {
                throw wrapper.badServantReadObject();
            }
        }
        ClientDelegate del = ORBUtility.makeClientDelegate(ior);
        CORBAObjectImpl objref = null;
        if (stubFactory == null) {
            objref = new CORBAObjectImpl();
        } else {
            try {
                objref = stubFactory.makeStub();
            }
            catch (Throwable e) {
                wrapper.stubCreateError(e);
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                objref = new CORBAObjectImpl();
            }
        }
        StubAdapter.setDelegate((java.lang.Object)objref, (Delegate)del);
        return objref;
    }

    @Override
    @CdrRead
    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    @Override
    public java.lang.Object read_abstract_interface(Class clz) {
        boolean object = this.read_boolean();
        if (object) {
            return this.read_Object(clz);
        }
        return this.read_value();
    }

    @Override
    @CdrRead
    public Serializable read_value() {
        return this.read_value((Class)null);
    }

    @InfoMethod
    private void indirectionValue(int indir) {
    }

    @CdrRead
    private Serializable handleIndirection() {
        int indirection = this.read_long() + this.get_offset() - 4;
        this.indirectionValue(indirection);
        if (this.valueCache != null && this.valueCache.containsVal(indirection)) {
            Serializable cachedValue = (Serializable)this.valueCache.getKey(indirection);
            return cachedValue;
        }
        throw new IndirectionException(indirection);
    }

    private String readRepositoryIds(int valueTag, Class<?> expectedType, ClassInfoCache.ClassInfo cinfo, String expectedTypeRepId) {
        return this.readRepositoryIds(valueTag, expectedType, cinfo, expectedTypeRepId, null);
    }

    private String readRepositoryIds(int valueTag, Class<?> expectedType, ClassInfoCache.ClassInfo cinfo, String expectedTypeRepId, BoxedValueHelper factory) {
        switch (this.repIdUtil.getTypeInfo(valueTag)) {
            case 0: {
                if (expectedType == null) {
                    if (expectedTypeRepId != null) {
                        return expectedTypeRepId;
                    }
                    if (factory != null) {
                        return factory.get_id();
                    }
                    throw wrapper.expectedTypeNullAndNoRepId();
                }
                return this.repIdStrs.createForAnyType(expectedType, cinfo);
            }
            case 2: {
                return this.read_repositoryId();
            }
            case 6: {
                return this.read_repositoryIds();
            }
        }
        throw wrapper.badValueTag(Integer.toHexString(valueTag));
    }

    @CdrRead
    private java.lang.Object readRMIIIOPValueType(int indirection, Class<?> valueClass, String repositoryIDString) {
        try {
            if (this.valueHandler == null) {
                this.valueHandler = ORBUtility.createValueHandler();
            }
            return this.valueHandler.readValue((org.omg.CORBA.portable.InputStream)this.parent, indirection, valueClass, repositoryIDString, (RunTime)this.getCodeBase());
        }
        catch (SystemException sysEx) {
            throw sysEx;
        }
        catch (Exception ex) {
            throw wrapper.valuehandlerReadException(ex);
        }
        catch (Error e) {
            throw wrapper.valuehandlerReadError(e);
        }
    }

    @InfoMethod
    private void repositoryIdString(String str) {
    }

    @InfoMethod
    private void valueClass(Class cls) {
    }

    @InfoMethod
    private void noProxyInterfaces() {
    }

    @Override
    @CdrRead
    public Serializable read_value(Class expectedType) {
        EnumDesc desc;
        java.lang.Object value = null;
        int vType = this.readValueTag();
        if (vType == 0) {
            return null;
        }
        if (vType == -1) {
            value = this.handleIndirection();
        } else {
            ClassInfoCache.ClassInfo cinfo = null;
            if (expectedType != null) {
                cinfo = ClassInfoCache.get(expectedType);
            }
            int indirection = this.get_offset() - 4;
            boolean saveIsChunked = this.isChunked;
            this.isChunked = this.repIdUtil.isChunkedEncoding(vType);
            String codebase_URL = null;
            if (this.repIdUtil.isCodeBasePresent(vType)) {
                codebase_URL = this.read_codebase_URL();
            }
            String repositoryIDString = this.readRepositoryIds(vType, expectedType, cinfo, null);
            this.repositoryIdString(repositoryIDString);
            this.start_block();
            --this.end_flag;
            if (this.isChunked) {
                --this.chunkedValueNestingLevel;
            }
            if (repositoryIDString.equals(this.repIdStrs.getWStringValueRepId())) {
                value = this.read_wstring();
            } else if (repositoryIDString.equals(this.repIdStrs.getClassDescValueRepId())) {
                value = this.readClass();
            } else {
                Class<?> valueClass = expectedType;
                if (valueClass == null || !repositoryIDString.equals(this.repIdStrs.createForAnyType(expectedType, cinfo))) {
                    valueClass = this.getClassFromString(repositoryIDString, codebase_URL, expectedType);
                    cinfo = ClassInfoCache.get(valueClass);
                }
                this.valueClass(valueClass);
                if (valueClass == null) {
                    RepositoryIdInterface repositoryID = this.repIdStrs.getFromString(repositoryIDString);
                    throw wrapper.couldNotFindClass(repositoryID.getClassName());
                }
                if (cinfo.isEnum()) {
                    Class enumClass = ClassInfoCache.getEnumClass(cinfo, valueClass);
                    String enumValue = this.read_string();
                    value = Enum.valueOf(enumClass, enumValue);
                } else {
                    value = valueClass != null && cinfo.isAIDLEntity(valueClass) ? this.readIDLValue(indirection, repositoryIDString, valueClass, cinfo, codebase_URL) : this.readRMIIIOPValueType(indirection, valueClass, repositoryIDString);
                }
            }
            this.handleEndOfValue();
            this.readEndTag();
            if (this.valueCache == null) {
                this.valueCache = new CacheTable("Input valueCache", this.orb, false);
            }
            this.valueCache.put(value, indirection);
            this.isChunked = saveIsChunked;
            this.start_block();
        }
        if (value.getClass() == EnumDesc.class) {
            Class current;
            desc = (EnumDesc)EnumDesc.class.cast(value);
            Class cls = null;
            try {
                cls = JDKBridge.loadClass(desc.className, null, null);
            }
            catch (ClassNotFoundException cnfe) {
                throw wrapper.enumClassNotFound(cnfe, desc.className);
            }
            for (current = cls; current != null && !current.isEnum(); current = current.getSuperclass()) {
            }
            if (current != null) {
                value = Enum.valueOf(current, desc.value);
            } else {
                throw wrapper.couldNotUnmarshalEnum(desc.className, (Serializable)((java.lang.Object)desc.value));
            }
        }
        if (value.getClass() == ProxyDesc.class) {
            desc = (ProxyDesc)ProxyDesc.class.cast(value);
            int numberOfInterfaces = desc.interfaces.length;
            if (numberOfInterfaces == 0) {
                this.noProxyInterfaces();
                return null;
            }
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                RMIClassLoader.loadProxyClass(desc.codebase, desc.interfaces, value.getClass().getClassLoader());
            }
            catch (ClassNotFoundException cnfe) {
                throw wrapper.proxyClassNotFound(cnfe, this.getInterfacesList(desc.interfaces));
            }
            catch (MalformedURLException mue) {
                throw wrapper.malformedProxyUrl(mue, this.getInterfacesList(desc.interfaces), desc.codebase);
            }
            Class[] list = new Class[desc.interfaces.length];
            for (int i = 0; i < numberOfInterfaces; ++i) {
                try {
                    list[i] = JDKBridge.loadClass(desc.interfaces[i], desc.codebase, cl);
                    continue;
                }
                catch (ClassNotFoundException cnfe) {
                    throw wrapper.proxyClassNotFound(cnfe, desc.interfaces[i]);
                }
            }
            try {
                value = Proxy.newProxyInstance(cl, list, desc.handler);
            }
            catch (IllegalArgumentException iage) {
                throw wrapper.proxyWithIllegalArgs(iage);
            }
            catch (NullPointerException npe) {
                throw wrapper.emptyProxyInterfaceList(npe);
            }
        }
        return value;
    }

    private List<String> getInterfacesList(String[] interfaces) {
        return Arrays.asList(interfaces);
    }

    @Override
    @CdrRead
    public Serializable read_value(BoxedValueHelper factory) {
        String repositoryIDString;
        int vType = this.readValueTag();
        if (vType == 0) {
            return null;
        }
        if (vType == -1) {
            int indirection = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(indirection)) {
                Serializable cachedValue = (Serializable)this.valueCache.getKey(indirection);
                return cachedValue;
            }
            throw new IndirectionException(indirection);
        }
        int indirection = this.get_offset() - 4;
        boolean saveIsChunked = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(vType);
        java.lang.Object value = null;
        String codebase_URL = null;
        if (this.repIdUtil.isCodeBasePresent(vType)) {
            codebase_URL = this.read_codebase_URL();
        }
        if (!(repositoryIDString = this.readRepositoryIds(vType, null, null, null, factory)).equals(factory.get_id())) {
            factory = Utility.getHelper(null, codebase_URL, repositoryIDString);
        }
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        if (factory instanceof ValueHelper) {
            value = this.readIDLValueWithHelper((ValueHelper)factory, indirection);
        } else {
            this.valueIndirection = indirection;
            value = factory.read_value((org.omg.CORBA.portable.InputStream)this.parent);
        }
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable("Input valueCache", this.orb, false);
        }
        this.valueCache.put(value, indirection);
        this.isChunked = saveIsChunked;
        this.start_block();
        return (Serializable)value;
    }

    private boolean isCustomType(ValueHelper helper) {
        try {
            TypeCode tc = helper.get_type();
            int kind = tc.kind().value();
            if (kind == 29) {
                return tc.type_modifier() == 1;
            }
        }
        catch (BadKind ex) {
            throw wrapper.badKind(ex);
        }
        return false;
    }

    @Override
    @CdrRead
    public Serializable read_value(Serializable value) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable("Input valueCache", this.orb, false);
        }
        this.valueCache.put(value, this.valueIndirection);
        if (value instanceof StreamableValue) {
            ((StreamableValue)value)._read((org.omg.CORBA.portable.InputStream)this.parent);
        } else if (value instanceof CustomValue) {
            ((CustomValue)value).unmarshal((DataInputStream)this.parent);
        }
        return value;
    }

    @Override
    @CdrRead
    public Serializable read_value(String repositoryId) {
        int vType = this.readValueTag();
        if (vType == 0) {
            return null;
        }
        if (vType == -1) {
            int indirection = this.read_long() + this.get_offset() - 4;
            if (this.valueCache != null && this.valueCache.containsVal(indirection)) {
                Serializable cachedValue = (Serializable)this.valueCache.getKey(indirection);
                return cachedValue;
            }
            throw new IndirectionException(indirection);
        }
        int indirection = this.get_offset() - 4;
        boolean saveIsChunked = this.isChunked;
        this.isChunked = this.repIdUtil.isChunkedEncoding(vType);
        Serializable value = null;
        String codebase_URL = null;
        if (this.repIdUtil.isCodeBasePresent(vType)) {
            codebase_URL = this.read_codebase_URL();
        }
        String repositoryIDString = this.readRepositoryIds(vType, null, null, repositoryId);
        ValueFactory factory = Utility.getFactory(null, codebase_URL, (ORB)this.orb, repositoryIDString);
        this.start_block();
        --this.end_flag;
        if (this.isChunked) {
            --this.chunkedValueNestingLevel;
        }
        this.valueIndirection = indirection;
        value = factory.read_value((InputStream)this.parent);
        this.handleEndOfValue();
        this.readEndTag();
        if (this.valueCache == null) {
            this.valueCache = new CacheTable("Input valueCache", this.orb, false);
        }
        this.valueCache.put(value, indirection);
        this.isChunked = saveIsChunked;
        this.start_block();
        return value;
    }

    @InfoMethod
    private void readClassCodebases(String codebases, String repoId) {
    }

    @CdrRead
    private Class<?> readClass() {
        String classRepId;
        String codebases;
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            codebases = (String)((java.lang.Object)this.read_value(String.class));
            classRepId = (String)((java.lang.Object)this.read_value(String.class));
        } else {
            classRepId = (String)((java.lang.Object)this.read_value(String.class));
            codebases = (String)((java.lang.Object)this.read_value(String.class));
        }
        this.readClassCodebases(codebases, classRepId);
        Class cl = null;
        RepositoryIdInterface repositoryID = this.repIdStrs.getFromString(classRepId);
        try {
            cl = repositoryID.getClassFromType(codebases);
        }
        catch (ClassNotFoundException cnfe) {
            throw wrapper.cnfeReadClass(cnfe, repositoryID.getClassName());
        }
        catch (MalformedURLException me) {
            throw wrapper.malformedUrl(me, repositoryID.getClassName(), codebases);
        }
        return cl;
    }

    @CdrRead
    private java.lang.Object readIDLValueWithHelper(ValueHelper helper, int indirection) {
        Method readMethod;
        try {
            readMethod = helper.getClass().getDeclaredMethod(K_READ_METHOD, org.omg.CORBA.portable.InputStream.class, helper.get_class());
        }
        catch (NoSuchMethodException nsme) {
            Serializable result = helper.read_value((org.omg.CORBA.portable.InputStream)this.parent);
            return result;
        }
        java.lang.Object val = null;
        try {
            val = helper.get_class().newInstance();
        }
        catch (InstantiationException ie) {
            throw wrapper.couldNotInstantiateHelper(ie, helper.get_class());
        }
        catch (IllegalAccessException iae) {
            return helper.read_value((org.omg.CORBA.portable.InputStream)this.parent);
        }
        if (this.valueCache == null) {
            this.valueCache = new CacheTable("Input valueCache", this.orb, false);
        }
        this.valueCache.put(val, indirection);
        if (val instanceof CustomMarshal && this.isCustomType(helper)) {
            ((CustomMarshal)val).unmarshal((DataInputStream)this.parent);
            return val;
        }
        try {
            readMethod.invoke((java.lang.Object)helper, this.parent, val);
            return val;
        }
        catch (IllegalAccessException iae2) {
            throw wrapper.couldNotInvokeHelperReadMethod(iae2, helper.get_class());
        }
        catch (InvocationTargetException ite) {
            throw wrapper.couldNotInvokeHelperReadMethod(ite, helper.get_class());
        }
    }

    @CdrRead
    private java.lang.Object readBoxedIDLEntity(Class<?> clazz, String codebase) {
        Class cls = null;
        try {
            ClassLoader clazzLoader = clazz.getClassLoader();
            final Class helperClass = cls = Utility.loadClassForClass(clazz.getName() + "Helper", codebase, clazzLoader, clazz, clazzLoader);
            Method readMethod = null;
            try {
                readMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws NoSuchMethodException {
                        return helperClass.getDeclaredMethod(CDRInputStream_1_0.K_READ_METHOD, org.omg.CORBA.portable.InputStream.class);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (NoSuchMethodException)pae.getException();
            }
            return readMethod.invoke(null, this.parent);
        }
        catch (ClassNotFoundException cnfe) {
            throw wrapper.couldNotInvokeHelperReadMethod(cnfe, cls);
        }
        catch (NoSuchMethodException nsme) {
            throw wrapper.couldNotInvokeHelperReadMethod(nsme, cls);
        }
        catch (IllegalAccessException iae) {
            throw wrapper.couldNotInvokeHelperReadMethod(iae, cls);
        }
        catch (InvocationTargetException ite) {
            throw wrapper.couldNotInvokeHelperReadMethod(ite, cls);
        }
    }

    @CdrRead
    private java.lang.Object readIDLValue(int indirection, String repId, Class<?> clazz, ClassInfoCache.ClassInfo cinfo, String codebase) {
        ValueFactory factory;
        try {
            factory = Utility.getFactory(clazz, codebase, (ORB)this.orb, repId);
        }
        catch (MARSHAL marshal) {
            wrapper.marshalErrorInReadIDLValue(marshal);
            if (!cinfo.isAStreamableValue(clazz) && !cinfo.isACustomValue(clazz) && cinfo.isAValueBase(clazz)) {
                BoxedValueHelper helper = Utility.getHelper(clazz, codebase, repId);
                if (helper instanceof ValueHelper) {
                    return this.readIDLValueWithHelper((ValueHelper)helper, indirection);
                }
                return helper.read_value((org.omg.CORBA.portable.InputStream)this.parent);
            }
            return this.readBoxedIDLEntity(clazz, codebase);
        }
        this.valueIndirection = indirection;
        return factory.read_value((InputStream)this.parent);
    }

    @InfoMethod
    private void endTag(int endTag) {
    }

    @InfoMethod
    private void chunkedNestingLevel(int nl) {
    }

    @InfoMethod
    private void endFlag(int value) {
    }

    @CdrRead
    private void readEndTag() {
        if (this.isChunked) {
            int anEndTag = this.read_long();
            this.endTag(anEndTag);
            if (anEndTag >= 0) {
                throw wrapper.positiveEndTag(anEndTag, this.get_offset() - 4);
            }
            if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
                if (anEndTag < this.chunkedValueNestingLevel) {
                    throw wrapper.unexpectedEnclosingValuetype(anEndTag, this.chunkedValueNestingLevel);
                }
                if (anEndTag != this.chunkedValueNestingLevel) {
                    this.byteBuffer.position(this.byteBuffer.position() - 4);
                }
            } else if (anEndTag != this.end_flag) {
                this.byteBuffer.position(this.byteBuffer.position() - 4);
            }
            ++this.chunkedValueNestingLevel;
            this.chunkedNestingLevel(this.chunkedValueNestingLevel);
        }
        ++this.end_flag;
        this.endFlag(this.end_flag);
    }

    protected int get_offset() {
        return this.byteBuffer.position();
    }

    @InfoMethod
    private void unreadLastLong() {
    }

    @CdrRead
    private void start_block() {
        if (!this.isChunked) {
            return;
        }
        this.blockLength = 0x7FFFFF00;
        this.blockLength = this.read_long();
        if (this.blockLength > 0 && this.blockLength < 0x7FFFFF00) {
            this.blockLength += this.get_offset();
        } else {
            this.blockLength = 0x7FFFFF00;
            this.byteBuffer.position(this.byteBuffer.position() - 4);
        }
    }

    @InfoMethod
    private void peekNextLong(long val) {
    }

    @CdrRead
    private void handleEndOfValue() {
        if (!this.isChunked) {
            return;
        }
        while (this.blockLength != 0x7FFFFF00) {
            this.end_block();
            this.start_block();
        }
        int nextLong = this.read_long();
        this.peekNextLong(nextLong);
        this.byteBuffer.position(this.byteBuffer.position() - 4);
        if (nextLong < 0) {
            return;
        }
        if (nextLong != 0 && nextLong < 0x7FFFFF00) {
            throw wrapper.couldNotSkipBytes(nextLong, this.get_offset());
        }
        this.read_value();
        this.handleEndOfValue();
    }

    @CdrRead
    private void end_block() {
        if (this.blockLength != 0x7FFFFF00) {
            if (this.blockLength == this.get_offset()) {
                this.blockLength = 0x7FFFFF00;
            } else if (this.blockLength > this.get_offset()) {
                this.skipToOffset(this.blockLength);
            } else {
                throw wrapper.badChunkLength(this.blockLength, this.get_offset());
            }
        }
    }

    @CdrRead
    private int readValueTag() {
        return this.read_long();
    }

    @Override
    public ORB orb() {
        return this.orb;
    }

    @Override
    public final void read_boolean_array(boolean[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_boolean();
        }
    }

    @Override
    public final void read_char_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_char();
        }
    }

    @Override
    public final void read_wchar_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_wchar();
        }
    }

    @Override
    public final void read_short_array(short[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_short();
        }
    }

    @Override
    public final void read_ushort_array(short[] value, int offset, int length) {
        this.read_short_array(value, offset, length);
    }

    @Override
    public final void read_long_array(int[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_long();
        }
    }

    @Override
    public final void read_ulong_array(int[] value, int offset, int length) {
        this.read_long_array(value, offset, length);
    }

    @Override
    public final void read_longlong_array(long[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_longlong();
        }
    }

    @Override
    public final void read_ulonglong_array(long[] value, int offset, int length) {
        this.read_longlong_array(value, offset, length);
    }

    @Override
    public final void read_float_array(float[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_float();
        }
    }

    @Override
    public final void read_double_array(double[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_double();
        }
    }

    public final void read_any_array(Any[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[i + offset] = this.read_any();
        }
    }

    @CdrRead
    private String read_repositoryIds() {
        int numRepIds = this.read_long();
        if (numRepIds == -1) {
            int indirection = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null && this.repositoryIdCache.containsVal(indirection)) {
                return this.repositoryIdCache.getKey(indirection);
            }
            throw wrapper.unableToLocateRepIdArray(indirection);
        }
        int indirection = this.get_offset();
        String repID = this.read_repositoryId();
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable("Input repositoryIdCache", this.orb, false);
        }
        this.repositoryIdCache.put(repID, indirection);
        for (int i = 1; i < numRepIds; ++i) {
            this.read_repositoryId();
        }
        return repID;
    }

    @CdrRead
    private String read_repositoryId() {
        String result = this.readStringOrIndirection(true);
        if (result == null) {
            int indirection = this.read_long() + this.get_offset() - 4;
            if (this.repositoryIdCache != null) {
                result = this.repositoryIdCache.getKey(indirection);
            }
        } else {
            if (this.repositoryIdCache == null) {
                this.repositoryIdCache = new CacheTable("Input repositoryIdCache", this.orb, false);
            }
            this.repositoryIdCache.put(result, this.stringIndirection);
        }
        if (result != null) {
            return result;
        }
        throw wrapper.badRepIdIndirection(this.byteBuffer.position());
    }

    @CdrRead
    private String read_codebase_URL() {
        String result = this.readStringOrIndirection(true);
        if (result == null) {
            int indirection = this.read_long() + this.get_offset() - 4;
            if (this.codebaseCache != null) {
                result = this.codebaseCache.getKey(indirection);
            }
        } else {
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable("Input codebaseCache", this.orb, false);
            }
            this.codebaseCache.put(result, this.stringIndirection);
        }
        if (result != null) {
            return result;
        }
        throw wrapper.badCodebaseIndirection(this.byteBuffer.position());
    }

    @Override
    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    @Override
    public Serializable read_Value() {
        return this.read_value();
    }

    @Override
    public void read_any_array(AnySeqHolder seq, int offset, int length) {
        this.read_any_array(seq.value, offset, length);
    }

    @Override
    public void read_boolean_array(BooleanSeqHolder seq, int offset, int length) {
        this.read_boolean_array(seq.value, offset, length);
    }

    @Override
    public void read_char_array(CharSeqHolder seq, int offset, int length) {
        this.read_char_array(seq.value, offset, length);
    }

    @Override
    public void read_wchar_array(WCharSeqHolder seq, int offset, int length) {
        this.read_wchar_array(seq.value, offset, length);
    }

    @Override
    public void read_octet_array(OctetSeqHolder seq, int offset, int length) {
        this.read_octet_array(seq.value, offset, length);
    }

    @Override
    public void read_short_array(ShortSeqHolder seq, int offset, int length) {
        this.read_short_array(seq.value, offset, length);
    }

    @Override
    public void read_ushort_array(UShortSeqHolder seq, int offset, int length) {
        this.read_ushort_array(seq.value, offset, length);
    }

    @Override
    public void read_long_array(LongSeqHolder seq, int offset, int length) {
        this.read_long_array(seq.value, offset, length);
    }

    @Override
    public void read_ulong_array(ULongSeqHolder seq, int offset, int length) {
        this.read_ulong_array(seq.value, offset, length);
    }

    @Override
    public void read_ulonglong_array(ULongLongSeqHolder seq, int offset, int length) {
        this.read_ulonglong_array(seq.value, offset, length);
    }

    @Override
    public void read_longlong_array(LongLongSeqHolder seq, int offset, int length) {
        this.read_longlong_array(seq.value, offset, length);
    }

    @Override
    public void read_float_array(FloatSeqHolder seq, int offset, int length) {
        this.read_float_array(seq.value, offset, length);
    }

    @Override
    public void read_double_array(DoubleSeqHolder seq, int offset, int length) {
        this.read_double_array(seq.value, offset, length);
    }

    @Override
    public BigDecimal read_fixed(short digits, short scale) {
        StringBuffer buffer = this.read_fixed_buffer();
        if (digits != buffer.length()) {
            throw wrapper.badFixed(digits, buffer.length());
        }
        buffer.insert(digits - scale, '.');
        return new BigDecimal(buffer.toString());
    }

    @Override
    public BigDecimal read_fixed() {
        return new BigDecimal(this.read_fixed_buffer().toString());
    }

    private StringBuffer read_fixed_buffer() {
        StringBuffer buffer = new StringBuffer(64);
        boolean wroteFirstDigit = false;
        boolean more = true;
        while (more) {
            byte doubleDigit = this.read_octet();
            int firstDigit = (doubleDigit & 0xF0) >> 4;
            int secondDigit = doubleDigit & 0xF;
            if (wroteFirstDigit || firstDigit != 0) {
                buffer.append(Character.forDigit(firstDigit, 10));
                wroteFirstDigit = true;
            }
            if (secondDigit == 12) {
                if (!wroteFirstDigit) {
                    return new StringBuffer("0.0");
                }
                more = false;
                continue;
            }
            if (secondDigit == 13) {
                buffer.insert(0, '-');
                more = false;
                continue;
            }
            buffer.append(Character.forDigit(secondDigit, 10));
            wroteFirstDigit = true;
        }
        return buffer;
    }

    @Override
    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    @Override
    public int getBufferLength() {
        return this.byteBuffer.limit();
    }

    @Override
    public void setBufferLength(int value) {
        this.byteBuffer.limit(value);
    }

    @Override
    public void setIndex(int value) {
        this.byteBuffer.position(value);
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteBuffer.order();
    }

    @Override
    public void orb(ORB orb) {
        this.orb = (com.sun.corba.ee.spi.orb.ORB)orb;
    }

    @Override
    public BufferManagerRead getBufferManager() {
        return this.bufferManagerRead;
    }

    @CdrRead
    private void skipToOffset(int offset) {
        int bytes;
        int len = offset - this.get_offset();
        for (int n = 0; n < len; n += bytes) {
            int avail;
            int wanted;
            if (!this.byteBuffer.hasRemaining()) {
                this.grow(1, 1);
            }
            bytes = (wanted = len - n) < (avail = this.byteBuffer.remaining()) ? wanted : avail;
            this.byteBuffer.position(this.byteBuffer.position() + bytes);
        }
    }

    @Override
    public java.lang.Object createStreamMemento() {
        return new StreamMemento();
    }

    @Override
    public void restoreInternalState(java.lang.Object streamMemento) {
        StreamMemento mem = (StreamMemento)streamMemento;
        this.blockLength = mem.blockLength_;
        this.end_flag = mem.end_flag_;
        this.chunkedValueNestingLevel = mem.chunkedValueNestingLevel_;
        this.valueIndirection = mem.valueIndirection_;
        this.stringIndirection = mem.stringIndirection_;
        this.isChunked = mem.isChunked_;
        this.valueHandler = mem.valueHandler_;
        this.specialNoOptionalDataState = mem.specialNoOptionalDataState_;
        this.byteBuffer = mem.byteBuffer_;
    }

    @Override
    public int getPosition() {
        return this.get_offset();
    }

    @Override
    public void mark(int readlimit) {
        this.markAndResetHandler.mark(this);
    }

    @Override
    public void reset() {
        this.markAndResetHandler.reset();
    }

    @Override
    CodeBase getCodeBase() {
        return this.parent.getCodeBase();
    }

    @CdrRead
    private Class<?> getClassFromString(String repositoryIDString, String codebaseURL, Class<?> expectedType) {
        String className;
        Class<?> result;
        RepositoryIdInterface repositoryID = this.repIdStrs.getFromString(repositoryIDString);
        ClassCodeBaseHandler ccbh = this.orb.classCodeBaseHandler();
        if (ccbh != null && (result = ccbh.loadClass(codebaseURL, className = repositoryID.getClassName())) != null) {
            return result;
        }
        try {
            try {
                return repositoryID.getClassFromType(expectedType, codebaseURL);
            }
            catch (ClassNotFoundException cnfeOuter) {
                try {
                    if (this.getCodeBase() == null) {
                        return null;
                    }
                    codebaseURL = this.getCodeBase().implementation(repositoryIDString);
                    if (codebaseURL == null) {
                        return null;
                    }
                    return repositoryID.getClassFromType(expectedType, codebaseURL);
                }
                catch (ClassNotFoundException cnfeInner) {
                    return null;
                }
            }
        }
        catch (MalformedURLException mue) {
            throw wrapper.malformedUrl(mue, repositoryIDString, codebaseURL);
        }
    }

    char[] getConvertedChars(int numBytes, CodeSetConversion.BTCConverter converter) {
        if (this.byteBuffer.remaining() >= numBytes) {
            int pos = this.byteBuffer.position();
            char[] result = converter.getChars(this.byteBuffer.slice(), 0, numBytes);
            this.byteBuffer.position(pos + numBytes);
            return result;
        }
        byte[] bytes = new byte[numBytes];
        this.read_octet_array(bytes, 0, bytes.length);
        return converter.getChars(bytes, 0, numBytes);
    }

    protected CodeSetConversion.BTCConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharBTCConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.BTCConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharBTCConverter();
        }
        return this.wcharConverter;
    }

    @Override
    void alignOnBoundary(int octetBoundary) {
        int needed = this.computeAlignment(this.byteBuffer.position(), octetBoundary);
        if (this.byteBuffer.position() + needed <= this.byteBuffer.limit()) {
            this.byteBuffer.position(this.byteBuffer.position() + needed);
        }
    }

    @Override
    public void resetCodeSetConverters() {
        this.charConverter = null;
        this.wcharConverter = null;
    }

    @InfoMethod
    private void valueTag(int value) {
    }

    @Override
    @CdrRead
    public void start_value() {
        int vType = this.readValueTag();
        this.valueTag(vType);
        if (vType == 0) {
            this.specialNoOptionalDataState = true;
            return;
        }
        if (vType == -1) {
            throw wrapper.customWrapperIndirection();
        }
        if (this.repIdUtil.isCodeBasePresent(vType)) {
            throw wrapper.customWrapperWithCodebase();
        }
        if (this.repIdUtil.getTypeInfo(vType) != 2) {
            throw wrapper.customWrapperNotSingleRepid();
        }
        this.read_repositoryId();
        this.start_block();
        --this.end_flag;
        --this.chunkedValueNestingLevel;
    }

    @Override
    @CdrRead
    public void end_value() {
        if (this.specialNoOptionalDataState) {
            this.specialNoOptionalDataState = false;
            return;
        }
        this.handleEndOfValue();
        this.readEndTag();
        this.start_block();
    }

    @Override
    @CdrRead
    public void close() throws IOException {
        this.getBufferManager().close(this.byteBuffer);
        if (this.byteBuffer != null) {
            ByteBufferPool byteBufferPool = this.orb.getByteBufferPool();
            byteBufferPool.releaseByteBuffer(this.byteBuffer);
            this.byteBuffer = null;
        }
    }

    protected class StreamMemento {
        private int blockLength_;
        private int end_flag_;
        private int chunkedValueNestingLevel_;
        private int valueIndirection_;
        private int stringIndirection_;
        private boolean isChunked_;
        private ValueHandler valueHandler_;
        private ByteBuffer byteBuffer_;
        private boolean specialNoOptionalDataState_;

        public StreamMemento() {
            this.blockLength_ = CDRInputStream_1_0.this.blockLength;
            this.end_flag_ = CDRInputStream_1_0.this.end_flag;
            this.chunkedValueNestingLevel_ = CDRInputStream_1_0.this.chunkedValueNestingLevel;
            this.valueIndirection_ = CDRInputStream_1_0.this.valueIndirection;
            this.stringIndirection_ = CDRInputStream_1_0.this.stringIndirection;
            this.isChunked_ = CDRInputStream_1_0.this.isChunked;
            this.valueHandler_ = CDRInputStream_1_0.this.valueHandler;
            this.specialNoOptionalDataState_ = CDRInputStream_1_0.this.specialNoOptionalDataState;
            this.byteBuffer_ = CDRInputStream_1_0.this.byteBuffer.duplicate();
            this.byteBuffer_.order(CDRInputStream_1_0.this.byteBuffer.order());
        }
    }
}

