/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;

public class AggregateCollectionChangeRecord
extends CollectionChangeRecord
implements org.eclipse.persistence.sessions.changesets.AggregateCollectionChangeRecord {
    protected List<ObjectChangeSet> changedValues;

    public AggregateCollectionChangeRecord() {
    }

    public AggregateCollectionChangeRecord(ObjectChangeSet owner) {
        this.owner = owner;
    }

    @Override
    public List<ObjectChangeSet> getChangedValues() {
        if (this.changedValues == null) {
            this.changedValues = new ArrayList<ObjectChangeSet>(2);
        }
        return this.changedValues;
    }

    @Override
    ClassDescriptor getReferenceDescriptor(Object object, AbstractSession session) {
        return ((AggregateCollectionMapping)this.mapping).getReferenceDescriptor(object.getClass(), session);
    }

    @Override
    public void mergeRecord(ChangeRecord mergeFromRecord, UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        this.setChangedValues(((AggregateCollectionChangeRecord)mergeFromRecord).getChangedValues());
        for (ObjectChangeSet change : this.getChangedValues()) {
            change.updateReferences(mergeToChangeSet, mergeFromChangeSet);
        }
    }

    public void setChangedValues(List<ObjectChangeSet> newValues) {
        this.changedValues = newValues;
    }

    @Override
    public void updateReferences(UnitOfWorkChangeSet mergeToChangeSet, UnitOfWorkChangeSet mergeFromChangeSet) {
        for (ObjectChangeSet mergedChangeSet : this.getChangedValues()) {
            Object localObject = mergeToChangeSet.getUOWCloneForObjectChangeSet(mergedChangeSet);
            if (localObject != null) continue;
            mergeToChangeSet.addObjectChangeSetForIdentity(mergedChangeSet, mergeFromChangeSet.getUOWCloneForObjectChangeSet(mergedChangeSet));
        }
    }
}

