/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.server;

import org.eclipse.persistence.exceptions.ConcurrencyException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.server.ConnectionPool;
import org.eclipse.persistence.sessions.server.ServerSession;

public class ExternalConnectionPool
extends ConnectionPool {
    protected Accessor cachedConnection;

    public ExternalConnectionPool() {
    }

    public ExternalConnectionPool(String name, Login login, ServerSession owner) {
        super(name, login, 0, 0, 0, owner);
    }

    @Override
    public Accessor acquireConnection() throws ConcurrencyException {
        if (this.isDead) {
            return this.failover();
        }
        Accessor connection = (Accessor)this.cachedConnection.clone();
        if (this.owner.shouldLog(1, "connection")) {
            Object[] args = new Object[]{this.name};
            this.owner.log(1, "connection", "acquire_connection", args, connection);
        }
        return connection;
    }

    protected Accessor getCachedConnection() {
        return this.cachedConnection;
    }

    @Override
    public boolean hasConnectionAvailable() {
        return true;
    }

    @Override
    public boolean isThereConflictBetweenLoginAndType() {
        return !this.getLogin().shouldUseExternalConnectionPooling();
    }

    @Override
    public void releaseConnection(Accessor connection) throws DatabaseException {
        if (this.owner.shouldLog(1, "connection")) {
            Object[] args = new Object[]{this.name};
            this.owner.log(1, "connection", "release_connection", args, connection);
        }
        if (!this.failoverConnectionPools.isEmpty()) {
            if (!connection.isValid()) {
                if (this.checkConnections) {
                    this.isDead = true;
                } else {
                    this.checkConnections = true;
                }
            } else {
                this.checkConnections = false;
            }
        }
        connection.closeConnection();
        connection.releaseCustomizer();
    }

    protected void setCachedConnection(Accessor cachedConnection) {
        this.cachedConnection = cachedConnection;
    }

    @Override
    public void setCheckConnections() {
    }

    @Override
    public synchronized void shutDown() {
        this.setIsConnected(false);
    }

    @Override
    public synchronized void startUp() {
        this.setCachedConnection(this.buildConnection());
        this.setIsConnected(true);
    }
}

