/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.parsson;

import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.parsson.JsonContext;
import org.eclipse.parsson.JsonWriterImpl;

class JsonWriterFactoryImpl
implements JsonWriterFactory {
    private final JsonContext jsonContext;

    JsonWriterFactoryImpl(JsonContext jsonContext) {
        this.jsonContext = jsonContext;
    }

    public JsonWriter createWriter(Writer writer) {
        return new JsonWriterImpl(writer, this.jsonContext);
    }

    public JsonWriter createWriter(OutputStream out) {
        return new JsonWriterImpl(out, this.jsonContext);
    }

    public JsonWriter createWriter(OutputStream out, Charset charset) {
        return new JsonWriterImpl(out, charset, this.jsonContext);
    }

    public Map<String, ?> getConfigInUse() {
        return this.jsonContext.config();
    }
}

