/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.runtime.deployer.cfg;

import com.sun.enterprise.deployment.types.ConcurrencyContextType;
import java.io.Serializable;
import java.util.Set;
import org.glassfish.concurrent.config.ManagedScheduledExecutorService;
import org.glassfish.concurrent.runtime.deployer.cfg.CfgParser;
import org.glassfish.concurrent.runtime.deployer.cfg.ConcurrentServiceCfg;

public class ManagedScheduledExecutorServiceCfg
implements Serializable {
    private static final long serialVersionUID = -1935790471020746933L;
    private final ConcurrentServiceCfg serviceConfig;
    private final int hungAfterSeconds;
    private final boolean hungLoggerPrintOnce;
    private final long hungLoggerInitialDelaySeconds;
    private final long hungLoggerIntervalSeconds;
    private final boolean longRunningTasks;
    private final int threadPriority;
    private final int corePoolSize;
    private final long keepAliveSeconds;
    private final long threadLifeTimeSeconds;

    public ManagedScheduledExecutorServiceCfg(ManagedScheduledExecutorService config) {
        Set<ConcurrencyContextType> propagated = CfgParser.parseContextInfo(config.getContextInfo(), config.getContextInfoEnabled());
        this.serviceConfig = new ConcurrentServiceCfg(config.getJndiName(), propagated, config.getContext());
        this.hungAfterSeconds = CfgParser.parseInt(config.getHungAfterSeconds(), 0);
        this.hungLoggerPrintOnce = Boolean.valueOf(config.getHungLoggerPrintOnce());
        this.hungLoggerInitialDelaySeconds = CfgParser.parseLong(config.getHungLoggerInitialDelaySeconds(), 60L);
        this.hungLoggerIntervalSeconds = CfgParser.parseLong(config.getHungLoggerIntervalSeconds(), 60L);
        this.longRunningTasks = Boolean.valueOf(config.getLongRunningTasks());
        this.threadPriority = CfgParser.parseInt(config.getThreadPriority(), 5);
        this.corePoolSize = CfgParser.parseInt(config.getCorePoolSize(), 0);
        this.keepAliveSeconds = CfgParser.parseLong(config.getKeepAliveSeconds(), 60L);
        this.threadLifeTimeSeconds = CfgParser.parseLong(config.getThreadLifetimeSeconds(), 0L);
    }

    public ConcurrentServiceCfg getServiceConfig() {
        return this.serviceConfig;
    }

    public int getHungAfterSeconds() {
        return this.hungAfterSeconds;
    }

    public boolean isHungLoggerPrintOnce() {
        return this.hungLoggerPrintOnce;
    }

    public long getHungLoggerInitialDelaySeconds() {
        return this.hungLoggerInitialDelaySeconds;
    }

    public long getHungLoggerIntervalSeconds() {
        return this.hungLoggerIntervalSeconds;
    }

    public boolean isLongRunningTasks() {
        return this.longRunningTasks;
    }

    public int getThreadPriority() {
        return this.threadPriority;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public long getKeepAliveSeconds() {
        return this.keepAliveSeconds;
    }

    public long getThreadLifeTimeSeconds() {
        return this.threadLifeTimeSeconds;
    }
}

