/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node;

import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.InjectionTargetNode;
import com.sun.enterprise.deployment.node.XMLElement;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EjbReferenceNode
extends DeploymentDescriptorNode<EjbReferenceDescriptor> {
    protected EjbReferenceDescriptor descriptor;

    public EjbReferenceNode() {
        this.registerElementHandler(new XMLElement("injection-target"), InjectionTargetNode.class, "addInjectionTarget");
    }

    @Override
    public EjbReferenceDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new EjbReferenceDescriptor();
            this.descriptor.setLocal(false);
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("ejb-ref-name", "setName");
        table.put("ejb-ref-type", "setType");
        table.put("home", "setEjbHomeInterface");
        table.put("remote", "setEjbInterface");
        table.put("local-home", "setEjbHomeInterface");
        table.put("local", "setEjbInterface");
        table.put("ejb-link", "setLinkName");
        table.put("mapped-name", "setMappedName");
        table.put("lookup-name", "setLookupName");
        return table;
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, EjbReferenceDescriptor ejbRefDesc) {
        Element ejbRefNode = EjbReferenceNode.appendChild(parent, nodeName);
        EjbReferenceNode.writeLocalizedDescriptions(ejbRefNode, ejbRefDesc);
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "ejb-ref-name", ejbRefDesc.getName());
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "ejb-ref-type", ejbRefDesc.getType());
        if (ejbRefDesc.isLocal()) {
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "local-home", ejbRefDesc.getEjbHomeInterface());
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "local", ejbRefDesc.getEjbInterface());
        } else {
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "home", ejbRefDesc.getEjbHomeInterface());
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "remote", ejbRefDesc.getEjbInterface());
        }
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "ejb-link", ejbRefDesc.getLinkName());
        EjbReferenceNode.appendTextChild((Node)ejbRefNode, "mapped-name", ejbRefDesc.getMappedName());
        if (ejbRefDesc.isInjectable()) {
            InjectionTargetNode ijNode = new InjectionTargetNode();
            for (InjectionTarget target : ejbRefDesc.getInjectionTargets()) {
                ijNode.writeDescriptor((Node)ejbRefNode, "injection-target", target);
            }
        }
        if (ejbRefDesc.hasLookupName()) {
            EjbReferenceNode.appendTextChild((Node)ejbRefNode, "lookup-name", ejbRefDesc.getLookupName());
        }
        return ejbRefNode;
    }
}

