/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.connector.AdminObjectNode;
import com.sun.enterprise.deployment.node.connector.ConfigPropertyNode;
import com.sun.enterprise.deployment.node.connector.InBoundRANode;
import com.sun.enterprise.deployment.node.connector.OutBoundRANode;
import com.sun.enterprise.deployment.node.connector.SecurityPermissionNode;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RANode
extends DeploymentDescriptorNode<ConnectorDescriptor> {
    private ConnectorDescriptor descriptor;

    public RANode() {
        this.register();
    }

    public RANode(XMLElement element) {
        this.setXMLRootTag(element);
        this.register();
    }

    private void register() {
        this.registerElementHandler(new XMLElement("outbound-resourceadapter"), OutBoundRANode.class);
        this.registerElementHandler(new XMLElement("inbound-resourceadapter"), InBoundRANode.class);
        this.registerElementHandler(new XMLElement("config-property"), ConfigPropertyNode.class, "addConfigProperty");
        this.registerElementHandler(new XMLElement("adminobject"), AdminObjectNode.class, "addAdminObject");
        this.registerElementHandler(new XMLElement("security-permission"), SecurityPermissionNode.class, "addSecurityPermission");
    }

    @Override
    public ConnectorDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = (ConnectorDescriptor)this.getParentNode().getDescriptor();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("resourceadapter-class", "setResourceAdapterClass");
        return table;
    }

    public static Node writeConnectorDescriptor(Node connectorNode, ConnectorDescriptor connDescriptor) {
        Element raNode = RANode.appendChild(connectorNode, "resourceadapter");
        RANode.appendTextChild((Node)raNode, "resourceadapter-class", connDescriptor.getResourceAdapterClass());
        ConfigPropertyNode.write((Node)raNode, connDescriptor);
        if (connDescriptor.getOutBoundDefined()) {
            OutBoundRANode.writeOutboundResourceAdapter(raNode, connDescriptor.getOutboundResourceAdapter());
        }
        if (connDescriptor.getInBoundDefined()) {
            InBoundRANode.writeInboundResourceAdapter(raNode, connDescriptor.getInboundResourceAdapter());
        }
        AdminObjectNode.writeAdminObjects(raNode, connDescriptor.getAdminObjects());
        SecurityPermissionNode.writeSecurityPermissions(raNode, connDescriptor.getSecurityPermissions());
        return connectorNode;
    }
}

