/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.MessageDestinationDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Map;
import org.glassfish.api.naming.SimpleJndiName;
import org.w3c.dom.Node;

public class MessageDestinationRuntimeNode
extends DeploymentDescriptorNode<MessageDestinationDescriptor> {
    private MessageDestinationDescriptor descriptor;

    @Override
    public MessageDestinationDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> table = super.getDispatchTable();
        table.put("jndi-name", "setJndiName");
        return table;
    }

    @Override
    public void setElementValue(XMLElement element, String value) {
        if ("message-destination-name".equals(element.getQName())) {
            Object parentDesc = this.getParentNode().getDescriptor();
            if (parentDesc instanceof BundleDescriptor) {
                try {
                    this.descriptor = ((BundleDescriptor)parentDesc).getMessageDestinationByName(value);
                }
                catch (IllegalArgumentException iae) {
                    DOLUtils.getDefaultLogger().warning(iae.getMessage());
                }
            }
        } else if ("jndi-name".equals(element.getQName())) {
            if (this.descriptor != null) {
                this.descriptor.setJndiName(SimpleJndiName.of((String)value));
            }
        } else {
            super.setElementValue(element, value);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MessageDestinationDescriptor msgDest) {
        SimpleJndiName jndiName = msgDest.getJndiName();
        Node msgDestNode = null;
        if (jndiName != null && !jndiName.isEmpty()) {
            msgDestNode = super.writeDescriptor(parent, nodeName, msgDest);
            MessageDestinationRuntimeNode.appendTextChild(msgDestNode, "message-destination-name", msgDest.getName());
            MessageDestinationRuntimeNode.appendTextChild(msgDestNode, "jndi-name", msgDest.getJndiName());
        }
        return msgDestNode;
    }
}

