/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.asyncqueue.AsyncQueueRecord;
import org.glassfish.grizzly.http2.frames.DataFrame;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.utils.ChunkedCompletionHandler;

public class Http2OutputQueueRecord
extends AsyncQueueRecord<WriteResult> {
    private final int streamId;
    private ChunkedCompletionHandler chunkedCompletionHandler;
    private final CompletionHandler<WriteResult> originalCompletionHandler;
    private Buffer buffer;
    private final boolean isLast;
    private final boolean isZeroSizeData;

    Http2OutputQueueRecord(int streamId, Buffer buffer, CompletionHandler<WriteResult> completionHandler, boolean isLast) {
        super(null, null, null);
        this.streamId = streamId;
        this.buffer = buffer;
        this.isZeroSizeData = !buffer.hasRemaining();
        this.originalCompletionHandler = completionHandler;
        this.isLast = isLast;
    }

    @Override
    public void notifyFailure(Throwable e) {
        CompletionHandler<WriteResult> chLocal = this.getCompletionHandler();
        if (chLocal != null) {
            chLocal.failed(e);
        }
    }

    @Override
    public void recycle() {
    }

    @Override
    public WriteResult getCurrentResult() {
        return null;
    }

    CompletionHandler<WriteResult> getCompletionHandler() {
        return this.chunkedCompletionHandler != null ? this.chunkedCompletionHandler : this.originalCompletionHandler;
    }

    boolean isZeroSizeData() {
        return this.isZeroSizeData;
    }

    boolean isFinished() {
        return this.buffer == null;
    }

    int serializeTo(List<Http2Frame> frames, int maxDataSize) {
        int recordSize = this.buffer.remaining();
        if (recordSize <= maxDataSize) {
            DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(this.streamId)).data(this.buffer).endStream(this.isLast).build();
            frames.add(dataFrame);
            this.buffer = null;
            return recordSize;
        }
        if (this.originalCompletionHandler != null && this.chunkedCompletionHandler == null) {
            this.chunkedCompletionHandler = new ChunkedCompletionHandler(this.originalCompletionHandler);
        }
        if (this.chunkedCompletionHandler != null) {
            this.chunkedCompletionHandler.incChunks();
        }
        Buffer remainder = this.buffer.split(this.buffer.position() + maxDataSize);
        DataFrame dataFrame = ((DataFrame.DataFrameBuilder)DataFrame.builder().streamId(this.streamId)).data(this.buffer).endStream(false).build();
        frames.add(dataFrame);
        this.buffer = remainder;
        return maxDataSize;
    }
}

