/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class Cache<K, V> {
    private final ConcurrentMap<K, V> cache = new ConcurrentHashMap();
    private final Factory<K, V> factory;

    public Cache(Factory<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        Object result = this.cache.get(key);
        if (result == null) {
            try {
                result = this.factory.newInstance(key);
            }
            catch (InterruptedException ie) {
                throw new RuntimeException(ie);
            }
            V oldResult = this.cache.putIfAbsent(key, result);
            if (oldResult != null) {
                result = oldResult;
            }
        }
        return result;
    }

    public V remove(K key) {
        return this.cache.remove(key);
    }

    public static interface Factory<K, V> {
        public V newInstance(K var1) throws InterruptedException;
    }
}

