/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionListener;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.UID;
import jakarta.inject.Singleton;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jvnet.hk2.annotations.Contract;

@Contract
@Singleton
public interface ClusterManager
extends PartitionListener {
    public static final String TRANSPORT_PROPERTY = "imq.cluster.transport";
    public static final String HOST_PROPERTY = "imq.cluster.hostname";
    public static final String PORT_PROPERTY = "imq.cluster.port";
    public static final String CLUSTERURL_PROPERTY = "imq.cluster.url";
    public static final String CONFIG_SERVER = "imq.cluster.masterbroker";
    public static final String CLUSTER_PING_INTERVAL_PROP = "imq.cluster.ping.interval";
    public static final int CLUSTER_PING_INTERVAL_DEFAULT = 60;
    public static final String AUTOCONNECT_PROPERTY = "imq.cluster.brokerlist";

    public String initialize(MQAddress var1) throws BrokerException;

    public int getClusterPingInterval();

    public String getClusterId();

    public void setMQAddress(MQAddress var1) throws Exception;

    public MQAddress getMQAddress();

    public void addEventListener(ClusterListener var1);

    public boolean removeEventListener(ClusterListener var1);

    public ClusteredBroker getLocalBroker();

    public int getKnownBrokerCount();

    public int getConfigBrokerCount();

    public int getActiveBrokerCount();

    public Iterator getKnownBrokers(boolean var1);

    public Iterator getActiveBrokers();

    public Iterator getConfigBrokers();

    public ClusteredBroker getBroker(String var1);

    public String activateBroker(MQAddress var1, UID var2, String var3, Object var4) throws BrokerException;

    public String activateBroker(String var1, UID var2, String var3, Object var4) throws BrokerException;

    public void deactivateBroker(MQAddress var1, Object var2);

    public void deactivateBroker(String var1, Object var2);

    public String lookupBrokerID(MQAddress var1);

    public String lookupStoreSessionOwner(UID var1);

    public String getStoreSessionCreator(UID var1);

    public String lookupBrokerSessionUID(UID var1);

    public ClusteredBroker getMasterBroker();

    public String getTransport();

    public int getClusterPort();

    public String getClusterHost();

    public boolean isHA();

    public UID getStoreSessionUID();

    public UID getBrokerSessionUID();

    public Set getSupportedStoreSessionUIDs();

    public void reloadConfig() throws BrokerException;

    public MQAddress getBrokerNextToMe();

    public LinkedHashSet parseBrokerList(String var1) throws MalformedURLException, UnknownHostException;

    public ClusteredBroker getBrokerByNodeName(String var1) throws BrokerException;
}

