/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.common.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ConsumerSpi;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;

public class FlowHandler
extends PacketHandler {
    private Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;

    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        if (DEBUG) {
            this.logger.log(1, "FlowHandler: handle() [ Received Flow  Message]");
        }
        assert (msg.getPacketType() == 52);
        Hashtable props = null;
        try {
            props = msg.getProperties();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "RESUME-FLOW Packet.getProperties()", ex);
            props = new Hashtable();
        }
        Integer bufsize = null;
        ConsumerSpi consumer = null;
        if (props != null) {
            Long cuid;
            bufsize = (Integer)props.get("JMQSize");
            if (bufsize == null) {
                bufsize = (Integer)props.get("JMQRBufferSize");
            }
            if ((cuid = (Long)props.get("JMQConsumerID")) != null) {
                ConsumerUID tmpuid = new ConsumerUID(cuid);
                consumer = this.coreLifecycle.getConsumer(tmpuid);
            }
        }
        if (DEBUG) {
            this.logger.log(4, "Setting JMQRBufferSize -" + bufsize);
        }
        if (consumer != null) {
            int size = bufsize == null ? -1 : bufsize;
            this.consumerFlow(consumer, size);
        } else {
            int size = bufsize == null ? -1 : bufsize;
            this.connectionFlow(con, size);
        }
        return true;
    }

    public void consumerFlow(ConsumerSpi consumer, int cprefetch) {
        try {
            int prefetch = this.coreLifecycle.calcPrefetch(consumer, cprefetch);
            consumer.resumeFlow(prefetch);
        }
        catch (Exception ex) {
            this.logger.logStack(32, Globals.getBrokerResources().getString("B4117", "protocol error, bad rbuf size"), ex);
            consumer.resumeFlow(-1);
        }
    }

    public void connectionFlow(IMQConnection con, int size) {
        con.resumeFlow(size);
    }
}

