/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ConnectionUtil;
import com.sun.messaging.jmq.jmsserver.management.util.DestinationUtil;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.net.IPAddress;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ConnectionMonitor
extends MQMBeanReadOnly {
    private long id;
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;

    public ConnectionMonitor(long id) {
        this.id = id;
    }

    public String getClientID() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        return cxnInfo.clientID;
    }

    public String getClientPlatform() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        return cxnInfo.userAgent;
    }

    public String getConnectionID() {
        return Long.toString(this.id);
    }

    public String getHost() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        String host = null;
        if (cxnInfo.remoteIP != null) {
            host = String.valueOf(IPAddress.rawIPToString(cxnInfo.remoteIP, true, true));
        }
        return host;
    }

    public Integer getNumConsumers() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        return cxnInfo.nconsumers;
    }

    public Integer getNumProducers() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        return cxnInfo.nproducers;
    }

    public Integer getPort() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        return cxnInfo.remPort;
    }

    public ObjectName getService() throws MBeanException {
        String serviceName = ConnectionUtil.getServiceOfConnection(this.id);
        ObjectName oName = null;
        try {
            oName = MQObjectName.createServiceMonitor(serviceName);
        }
        catch (Exception e) {
            this.handleOperationException("getService", e);
        }
        return oName;
    }

    public Long getCreationTime() {
        long ts = ConnectionUtil.getCreationTime(this.id);
        return ts;
    }

    public String getServiceName() {
        String serviceName = ConnectionUtil.getServiceOfConnection(this.id);
        return serviceName;
    }

    public String getUser() {
        ConnectionInfo cxnInfo = ConnectionUtil.getConnectionInfo(this.id);
        return cxnInfo.user;
    }

    public String[] getConsumerIDs() throws MBeanException {
        List consumerIDs = ConnectionUtil.getConsumerIDs(this.id);
        if (consumerIDs == null || consumerIDs.size() == 0) {
            return null;
        }
        String[] ids = new String[consumerIDs.size()];
        Iterator iter = consumerIDs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ConsumerUID cid = (ConsumerUID)iter.next();
            long conID = cid.longValue();
            try {
                String id;
                ids[i] = id = Long.toString(conID);
            }
            catch (Exception ex) {
                this.handleOperationException("getConsumerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public String[] getProducerIDs() throws MBeanException {
        List producerIDs = ConnectionUtil.getProducerIDs(this.id);
        if (producerIDs == null || producerIDs.size() == 0) {
            return null;
        }
        String[] ids = new String[producerIDs.size()];
        Iterator iter = producerIDs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            ProducerUID pid = (ProducerUID)iter.next();
            long prdID = pid.longValue();
            try {
                String id;
                ids[i] = id = Long.toString(prdID);
            }
            catch (Exception ex) {
                this.handleOperationException("getProducerIDs", ex);
            }
            ++i;
        }
        return ids;
    }

    public ObjectName[] getTemporaryDestinations() throws MBeanException {
        List dests = DestinationUtil.getVisibleTemporaryDestinations(this.id);
        if (dests.size() == 0) {
            return null;
        }
        ObjectName[] destONames = new ObjectName[dests.size()];
        for (int i = 0; i < dests.size(); ++i) {
            Destination d = (Destination)dests.get(i);
            try {
                ObjectName o;
                destONames[i] = o = MQObjectName.createDestinationMonitor(d.isQueue() ? "q" : "t", d.getDestinationName());
                continue;
            }
            catch (Exception e) {
                this.handleOperationException("getTemporaryDestinations", e);
            }
        }
        return destONames;
    }

    @Override
    public String getMBeanName() {
        return "ConnectionMonitor";
    }

    @Override
    public String getMBeanDescription() {
        return mbr.getString("MB1057");
    }

    @Override
    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    @Override
    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    @Override
    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[10];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("ClientID", String.class.getName(), mbr.getString("MB1044"), true, false, false);
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("ClientPlatform", String.class.getName(), mbr.getString("MB1045"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("ConnectionID", String.class.getName(), mbr.getString("MB1046"), true, false, false);
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("CreationTime", Long.class.getName(), mbr.getString("MB1267"), true, false, false);
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("Host", String.class.getName(), mbr.getString("MB1047"), true, false, false);
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("NumConsumers", Integer.class.getName(), mbr.getString("MB1048"), true, false, false);
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("NumProducers", Integer.class.getName(), mbr.getString("MB1049"), true, false, false);
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("Port", Integer.class.getName(), mbr.getString("MB1050"), true, false, false);
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("ServiceName", String.class.getName(), mbr.getString("MB1051"), true, false, false);
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("User", String.class.getName(), mbr.getString("MB1052"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[4];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getConsumerIDs", mbr.getString("MB1053"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("getProducerIDs", mbr.getString("MB1054"), null, String[].class.getName(), 0);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("getService", mbr.getString("MB1055"), null, ObjectName.class.getName(), 0);
        mBeanOperationInfoArray[3] = new MBeanOperationInfo("getTemporaryDestinations", mbr.getString("MB1056"), null, ObjectName[].class.getName(), 0);
        ops = mBeanOperationInfoArray;
    }
}

