/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jmq.util.MetricData;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;

public class MetricManager
implements ConfigListener {
    private Hashtable deadTotalsByService = new Hashtable();
    private MetricTask task = null;
    private long lastSampleTime = 0L;
    private MetricCounters lastSample;
    private static String INTERVAL_PROPERTY = "imq.metrics.interval";
    private static String ENABLED_PROPERTY = "imq.metrics.enabled";
    private BrokerResources rb = Globals.getBrokerResources();
    private MQTimer timer = Globals.getTimer();
    private Logger logger = Globals.getLogger();

    public static boolean isEnabled() {
        return Globals.getConfig().getBooleanProperty(ENABLED_PROPERTY);
    }

    public MetricManager() {
        this.lastSample = new MetricCounters();
    }

    public synchronized void depositTotals(String service, MetricCounters counters) {
        MetricCounters mc = (MetricCounters)this.deadTotalsByService.get(service);
        if (mc == null) {
            mc = new MetricCounters();
            this.deadTotalsByService.put(service, mc);
        }
        mc.update(counters);
    }

    public synchronized void reset() {
        this.deadTotalsByService.clear();
        this.lastSample = new MetricCounters();
    }

    public synchronized void setInterval(long interval) {
        if (interval > 0L && MetricManager.isEnabled()) {
            if (this.task != null) {
                this.task.cancel();
            }
            this.task = new MetricTask();
            this.timer.schedule((TimerTask)this.task, interval, interval * 1000L);
        } else if (this.task != null) {
            this.task.cancel();
        }
    }

    @Override
    public void validate(String name, String value) throws PropertyUpdateException {
        if (!name.equals(INTERVAL_PROPERTY)) {
            throw new PropertyUpdateException(this.rb.getString("B4028", name));
        }
        this.getLongProperty(name, value);
    }

    @Override
    public boolean update(String name, String value) {
        if (name.equals(INTERVAL_PROPERTY)) {
            try {
                this.setInterval(this.getLongProperty(name, value));
                return true;
            }
            catch (PropertyUpdateException propertyUpdateException) {
                // empty catch block
            }
        }
        return false;
    }

    public long getLongProperty(String name, String value) throws PropertyUpdateException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new PropertyUpdateException(this.rb.getString("B4027", name + "=" + value));
        }
    }

    public void setParameters(Hashtable params) {
        try {
            String value = (String)params.get(INTERVAL_PROPERTY);
            this.validate(INTERVAL_PROPERTY, value);
            this.update(INTERVAL_PROPERTY, value);
        }
        catch (PropertyUpdateException e) {
            this.logger.logStack(16, "B2063", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MetricCounters getMetricCounters(String serviceName) {
        ConnectionManager cm = Globals.getConnectionManager();
        MetricCounters totals = new MetricCounters();
        if (serviceName == null) {
            Enumeration e = this.deadTotalsByService.elements();
            while (e.hasMoreElements()) {
                totals.update((MetricCounters)e.nextElement());
            }
        } else {
            MetricCounters deadTotals = (MetricCounters)this.deadTotalsByService.get(serviceName);
            if (deadTotals != null) {
                totals.update((MetricCounters)this.deadTotalsByService.get(serviceName));
            }
        }
        int n = 0;
        ConnectionManager connectionManager = cm;
        synchronized (connectionManager) {
            Collection connections = cm.values();
            for (Connection con : connections) {
                Service svc = con.getService();
                if (serviceName != null && !serviceName.equals(svc.getName())) continue;
                if (con instanceof IMQConnection) {
                    totals.update(((IMQConnection)con).getMetricCounters());
                }
                ++n;
            }
        }
        ServiceManager sm = Globals.getServiceManager();
        Service svc = null;
        Iterator iter = null;
        if (serviceName == null) {
            Set s = sm.getAllActiveServices();
            if (s != null) {
                iter = s.iterator();
            }
        } else {
            Vector<String> v = new Vector<String>(1);
            v.add(serviceName);
            iter = v.iterator();
        }
        while (iter != null && iter.hasNext()) {
            svc = sm.getService((String)iter.next());
            if (!(svc instanceof IMQService)) continue;
            totals.threadsActive += ((IMQService)svc).getActiveThreadpool();
            totals.threadsHighWater += ((IMQService)svc).getMaxThreadpool();
            totals.threadsLowWater += ((IMQService)svc).getMinThreadpool();
        }
        Runtime rt = Runtime.getRuntime();
        totals.totalMemory = rt.totalMemory();
        totals.freeMemory = rt.freeMemory();
        totals.nConnections = n;
        totals.timeStamp = System.currentTimeMillis();
        return totals;
    }

    public synchronized MetricData getMetrics() {
        MetricData md = new MetricData();
        Runtime rt = Runtime.getRuntime();
        long currentTime = System.currentTimeMillis();
        float elapsedSecs = (float)(currentTime - this.lastSampleTime) / 1000.0f;
        MetricCounters totals = this.getMetricCounters(null);
        md.timestamp = currentTime;
        md.totalMemory = rt.totalMemory();
        md.freeMemory = rt.freeMemory();
        md.nConnections = totals.nConnections;
        md.setTotals(totals);
        md.rates.messagesIn = (long)((float)(totals.messagesIn - this.lastSample.messagesIn) / elapsedSecs);
        md.rates.messageBytesIn = (long)((float)(totals.messageBytesIn - this.lastSample.messageBytesIn) / elapsedSecs);
        md.rates.packetsIn = (long)((float)(totals.packetsIn - this.lastSample.packetsIn) / elapsedSecs);
        md.rates.packetBytesIn = (long)((float)(totals.packetBytesIn - this.lastSample.packetBytesIn) / elapsedSecs);
        md.rates.messagesOut = (long)((float)(totals.messagesOut - this.lastSample.messagesOut) / elapsedSecs);
        md.rates.messageBytesOut = (long)((float)(totals.messageBytesOut - this.lastSample.messageBytesOut) / elapsedSecs);
        md.rates.packetsOut = (long)((float)(totals.packetsOut - this.lastSample.packetsOut) / elapsedSecs);
        md.rates.packetBytesOut = (long)((float)(totals.packetBytesOut - this.lastSample.packetBytesOut) / elapsedSecs);
        this.lastSampleTime = currentTime;
        this.lastSample = totals;
        return md;
    }

    public class MetricTask
    extends TimerTask {
        @Override
        public void run() {
            MetricData md = MetricManager.this.getMetrics();
            MetricManager.this.logger.log(8, "\n" + md.toString());
        }
    }
}

