/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public class ConvertPacket {
    private Logger logger = Globals.getLogger();
    Hashtable consumer_to_interest = new Hashtable();
    Hashtable interest_to_consumer = new Hashtable();
    Hashtable consumer_to_deliver = new Hashtable();
    IMQConnection con = null;
    int oldversion = 0;
    int targetVersion = 0;
    static final int OLD_ACK_BLOCK_SIZE = 36;

    public ConvertPacket(IMQConnection con, int oldversion, int targetVersion) {
        this.con = con;
        this.oldversion = oldversion;
        this.targetVersion = targetVersion;
    }

    public void handleReadPacket(Packet msg) {
        if (this.oldversion == 200) {
            return;
        }
        msg.setVersion(this.targetVersion);
        int type = msg.getPacketType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.handleDataRead(msg);
                break;
            }
            case 16: {
                this.removeConsumerRequest(msg);
                break;
            }
            case 24: 
            case 32: {
                this.handleAcknowledgeRead(msg);
                break;
            }
            case 42: {
                this.handleDeliverRead(msg);
            }
        }
    }

    public void handleWritePacket(Packet msg) {
        msg.setVersion(this.oldversion);
        if (this.oldversion == 200) {
            return;
        }
        int type = msg.getPacketType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.handleDataWrite(msg);
                break;
            }
            case 15: {
                this.handleConsumerResponse(msg);
                break;
            }
        }
    }

    private void handleAcknowledgeRead(Packet msg) {
        if (msg.getTransactionID() != 0L) {
            TransactionHandler.convertPacketTid(this.con, msg);
        }
        DataInputStream is = new DataInputStream(msg.getMessageBodyStream());
        int size = msg.getMessageBodySize();
        int ackcount = size / 36;
        int[] clientids = new int[ackcount];
        SysMessageID[] sysids = new SysMessageID[ackcount];
        try {
            for (int i = 0; i < ackcount; ++i) {
                clientids[i] = is.readInt();
                sysids[i] = new SysMessageID();
                sysids[i].readID(is);
            }
        }
        catch (IOException ex) {
            this.logger.logStack(8, "bad sysmessageid ", ex);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            for (int i = 0; i < ackcount; ++i) {
                Long newid = (Long)this.interest_to_consumer.get(clientids[i]);
                if (newid == null) continue;
                dos.writeLong(newid);
                sysids[i].writeID(dos);
            }
            dos.flush();
            bos.flush();
        }
        catch (IOException ex) {
            this.logger.logStack(16, "Unable to convert  old packet ", ex);
        }
        msg.setMessageBody(bos.toByteArray());
    }

    private void handleDataRead(Packet msg) {
        if (msg.getTransactionID() != 0L) {
            TransactionHandler.convertPacketTid(this.con, msg);
        }
    }

    private void handleDataWrite(Packet msg) {
        Long newid = msg.getConsumerID();
        Integer oldid = (Integer)this.consumer_to_interest.get(newid);
        if (oldid == null && (oldid = (Integer)this.consumer_to_deliver.get(newid)) != null && msg.getIsLast()) {
            this.consumer_to_deliver.remove(newid);
        }
        if (oldid == null) {
            Globals.getLogger().log(4, "Throwing out packet, could not find old consumer id for new id " + newid);
            return;
        }
        msg.setConsumerID(oldid.intValue());
    }

    private void handleConsumerResponse(Packet msg) {
        Hashtable props;
        try {
            props = msg.getProperties();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "bad properties", ex);
            return;
        }
        Integer intr = (Integer)props.remove("JMQOldConsumerID");
        Long newcid = (Long)props.get("JMQConsumerID");
        if (newcid != null && intr != null) {
            this.consumer_to_interest.put(newcid, intr);
            this.interest_to_consumer.put(intr, newcid);
        }
    }

    private void handleDeliverRead(Packet msg) {
        Hashtable props;
        try {
            props = msg.getProperties();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "bad propertis", ex);
            return;
        }
        Integer oldid = (Integer)props.get("JMQConsumerID");
        if (oldid != null) {
            ConsumerUID newcid = new ConsumerUID();
            Long longcid = newcid.longValue();
            props.put("JMQConsumerID", longcid);
            this.consumer_to_deliver.put(longcid, oldid);
        }
    }

    private void removeConsumerRequest(Packet msg) {
        Hashtable props;
        try {
            props = msg.getProperties();
        }
        catch (Exception ex) {
            this.logger.logStack(16, "bad propertis ", ex);
            return;
        }
        Integer oldid = (Integer)props.get("JMQConsumerID");
        if (oldid != null) {
            Long newid = (Long)this.interest_to_consumer.get(oldid);
            props.put("JMQConsumerID", newid);
            this.consumer_to_interest.remove(newid);
            this.interest_to_consumer.remove(oldid);
        }
    }
}

