/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsselector;

import com.sun.messaging.jmq.jmsselector.InvalidJMSSelectorException;
import com.sun.messaging.jmq.jmsselector.NullMessageHeaderException;
import com.sun.messaging.jmq.jmsselector.SQLParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class JMSSelector
implements Serializable {
    private static final long serialVersionUID = 987679311016714425L;
    transient SQLParser parser;
    String selectorPattern;
    transient Hashtable msgHeader;
    transient int jmsDeliveryMode;
    transient int jmsPriority;
    transient String jmsMessageID;
    transient long jmsTimestamp;
    transient String jmsCorrelationID;
    transient String jmsType;

    public JMSSelector() {
        this(null, null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.msgHeader = new Hashtable();
        this.jmsDeliveryMode = 2;
        this.jmsPriority = 4;
        this.jmsMessageID = "";
        this.jmsTimestamp = 0L;
        this.jmsCorrelationID = "";
        this.jmsType = "";
    }

    public JMSSelector(String pattern, Hashtable header) {
        if (pattern == null) {
            pattern = "";
        }
        if (header == null) {
            header = new Hashtable();
        }
        this.msgHeader = header;
        this.selectorPattern = pattern;
        this.jmsDeliveryMode = 2;
        this.jmsPriority = 4;
        this.jmsMessageID = "";
        this.jmsTimestamp = 0L;
        this.jmsCorrelationID = "";
        this.jmsType = "";
        StringReader stream = new StringReader(this.selectorPattern);
        this.parser = new SQLParser(this, stream);
    }

    public int getJMSDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public void setJMSDeliveryMode(int deliveryMode) {
        this.jmsDeliveryMode = deliveryMode;
    }

    public int getJMSPriority() {
        return this.jmsPriority;
    }

    public void setJMSPriority(int priority) {
        this.jmsPriority = priority;
    }

    public String getJMSMessageID() {
        return this.jmsMessageID;
    }

    public void setJMSMessageID(String messageID) {
        this.jmsMessageID = messageID;
    }

    public long getJMSTimestamp() {
        return this.jmsTimestamp;
    }

    public void setJMSTimestamp(long timestamp) {
        this.jmsTimestamp = timestamp;
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public void setJMSCorrelationID(String correlationID) {
        this.jmsCorrelationID = correlationID;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public void setJMSType(String type) {
        this.jmsType = type;
    }

    public void setJMSHeaderFields(int deliveryMode, int priority, String messageID, long timestamp, String correlationID, String type) {
        this.jmsDeliveryMode = deliveryMode;
        this.jmsPriority = priority;
        this.jmsMessageID = messageID;
        this.jmsTimestamp = timestamp;
        this.jmsCorrelationID = correlationID;
        this.jmsType = type;
    }

    public String getSelectorPattern() {
        return this.selectorPattern;
    }

    public void setSelectorPattern(String pattern) {
        this.selectorPattern = pattern == null ? "" : pattern;
    }

    public void validateSelectorPattern(String pattern) throws InvalidJMSSelectorException, NullMessageHeaderException {
        if (pattern == null) {
            pattern = "";
        }
        this.selectorPattern = pattern;
        if ("".equals(this.selectorPattern)) {
            return;
        }
        try {
            this.match(this.msgHeader);
        }
        catch (NullMessageHeaderException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InvalidJMSSelectorException(this.selectorPattern);
        }
    }

    public boolean match(Hashtable header) throws InvalidJMSSelectorException, NullMessageHeaderException {
        boolean matched = false;
        if (this.selectorPattern.equals("")) {
            matched = true;
        } else {
            try {
                StringReader stream = new StringReader(this.selectorPattern);
                this.parser.reInit(stream);
                matched = this.parser.match(header == null ? this.msgHeader : header);
            }
            catch (NullMessageHeaderException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new InvalidJMSSelectorException(this.selectorPattern);
            }
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean matchPattern(String patternStr, String str, char escapeChar) {
        boolean matched = false;
        String escapeCharStr = String.valueOf(escapeChar);
        String wildCards = "_%";
        String delims = wildCards + escapeCharStr;
        boolean escaped = false;
        int index = 0;
        String tok = null;
        try {
            if (str != null) {
                StringTokenizer st = new StringTokenizer(patternStr, delims, true);
                ArrayList<String> tokens = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    tok = st.nextToken();
                    tokens.add(tok);
                }
                matched = true;
                int numTokens = tokens.size();
                block8: for (int i = 0; i < numTokens; ++i) {
                    tok = (String)tokens.get(i);
                    if (tok.equals(escapeCharStr) && !escaped) {
                        escaped = true;
                        continue;
                    }
                    if (tok.equals("%") && !escaped) {
                        if (i == numTokens - 1) {
                            index = str.length();
                            continue;
                        }
                        if (i == numTokens - 1) continue;
                        int _cnt = 0;
                        ++i;
                        while (i < numTokens) {
                            tok = (String)tokens.get(i);
                            if (tok.equals(escapeCharStr) && !escaped) {
                                escaped = true;
                            } else if (!tok.equals("%") || escaped) {
                                if (tok.equals("_") && !escaped) {
                                    ++_cnt;
                                } else {
                                    int oldIndex = index;
                                    if (i == numTokens - 1) {
                                        if (str.endsWith(tok)) {
                                            index = str.length() - tok.length();
                                        } else {
                                            matched = false;
                                        }
                                    } else {
                                        index = str.indexOf(tok, index);
                                    }
                                    if (index < 0) {
                                        matched = false;
                                    } else if (index - oldIndex >= _cnt) {
                                        index += tok.length();
                                    } else {
                                        matched = false;
                                    }
                                    escaped = false;
                                    continue block8;
                                }
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (tok.equals("_") && !escaped) {
                        ++index;
                        continue;
                    }
                    int tokLen = tok.length();
                    if (index + tokLen <= str.length()) {
                        String subStr = null;
                        try {
                            subStr = str.substring(index, index + tokLen);
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            matched = false;
                            break;
                        }
                        if (!subStr.equalsIgnoreCase(tok)) {
                            matched = false;
                            break;
                        }
                        index += tok.length();
                    } else {
                        matched = false;
                        break;
                    }
                    escaped = false;
                }
            }
            if (matched) {
                if (index != str.length()) {
                    matched = false;
                    return matched;
                }
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            matched = false;
            return matched;
        }
        finally {
            return matched;
        }
    }

    String processStringLiteral(String strLiteral) {
        int index = (strLiteral = strLiteral.substring(1, strLiteral.length() - 1)).indexOf("''");
        if (index > -1) {
            StringBuffer sb = new StringBuffer(strLiteral);
            while (index != -1) {
                sb.deleteCharAt(index);
                index = sb.indexOf("''");
            }
            strLiteral = sb.toString();
        }
        return strLiteral;
    }

    public String toString() {
        return "JMSSelector:\tPattern=\t`" + this.selectorPattern + "'\n    Headers:\tDeliveryMode\t" + this.jmsDeliveryMode + "\n\t\tPriority\t" + this.jmsPriority + "\n\t\tMessageID\t`" + this.jmsMessageID + "'\n\t\tTimestamp\t" + this.jmsTimestamp + "\n\t\tCorrelationID\t`" + this.jmsCorrelationID + "'\n\t\tType\t\t`" + this.jmsType + "'\n";
    }
}

