/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util.jmx;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import org.glassfish.admin.amx.util.jmx.JMXUtil;

public class NotificationBuilder {
    private long mSequenceNumber = 0L;
    private final String mNotificationType;
    private final Object mSource;

    protected synchronized long nextSequenceNumber() {
        return this.mSequenceNumber++;
    }

    public NotificationBuilder(String notificationType, Object source) {
        this.mNotificationType = notificationType;
        this.mSource = source;
    }

    public final String getNotificationType() {
        return this.mNotificationType;
    }

    public final Object getSource() {
        return this.mSource;
    }

    protected final long now() {
        return System.currentTimeMillis();
    }

    public Notification buildNewWithMap(String message, Map<String, Serializable> userDataMap) {
        Notification notif = new Notification(this.mNotificationType, this.mSource, this.nextSequenceNumber(), this.now(), message);
        if (userDataMap != null) {
            notif.setUserData(userDataMap);
        } else {
            notif.setUserData(new HashMap());
        }
        return notif;
    }

    public Notification buildNew() {
        return this.buildNew(this.mNotificationType);
    }

    public Notification buildNew(String message) {
        return this.buildNewWithMap(message, null);
    }

    public static final void putMapData(Notification notif, String keyToInsert, Serializable valueToInsert) {
        Map userData = JMXUtil.getUserDataMapString_Serializable(notif);
        userData.put(keyToInsert, valueToInsert);
    }

    public static final <T extends Serializable> void putAllMapData(Notification notif, Map<String, T> additionalUserData) {
        Map userData = JMXUtil.getUserDataMapString_Serializable(notif);
        userData.putAll(additionalUserData);
    }
}

