/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.node;

import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.MethodNode;
import com.sun.enterprise.deployment.node.XMLElement;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.ejb.deployment.descriptor.ConcurrentMethodDescriptor;
import org.glassfish.ejb.deployment.descriptor.TimeoutValueDescriptor;
import org.glassfish.ejb.deployment.node.TimeoutValueNode;
import org.w3c.dom.Node;

public class ConcurrentMethodNode
extends DeploymentDescriptorNode<ConcurrentMethodDescriptor> {
    private static final String WRITE_LOCK = "Write";
    private ConcurrentMethodDescriptor descriptor;

    public ConcurrentMethodNode() {
        this.registerElementHandler(new XMLElement("method"), MethodNode.class, "setConcurrentMethod");
        this.registerElementHandler(new XMLElement("access-timeout"), TimeoutValueNode.class, "setAccessTimeout");
    }

    public ConcurrentMethodDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ConcurrentMethodDescriptor();
        }
        return this.descriptor;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("lock".equals(element.getQName())) {
            this.descriptor.setWriteLock(value.equals(WRITE_LOCK));
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ConcurrentMethodDescriptor desc) {
        Node concurrentNode = super.writeDescriptor(parent, nodeName, (Descriptor)this.descriptor);
        MethodNode methodNode = new MethodNode();
        methodNode.writeJavaMethodDescriptor(concurrentNode, "method", desc.getConcurrentMethod());
        if (desc.hasLockMetadata()) {
            String lockType = desc.isWriteLocked() ? WRITE_LOCK : "Read";
            ConcurrentMethodNode.appendTextChild((Node)concurrentNode, (String)"lock", (String)lockType);
        }
        if (desc.hasAccessTimeout()) {
            TimeoutValueNode timeoutValueNode = new TimeoutValueNode();
            TimeoutValueDescriptor timeoutDesc = new TimeoutValueDescriptor();
            timeoutDesc.setValue(desc.getAccessTimeoutValue());
            timeoutDesc.setUnit(desc.getAccessTimeoutUnit());
            timeoutValueNode.writeDescriptor(concurrentNode, "access-timeout", timeoutDesc);
        }
        return concurrentNode;
    }
}

