/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.security.ssl.J2EEKeyManager;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.apache.catalina.net.ServerSocketFactory;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.SharedSecureRandom;

public class SSLSocketFactory
implements ServerSocketFactory {
    static Logger _logger = Logger.getLogger(SSLSocketFactory.class.getName(), "org.glassfish.main.web.security.LogMessages");
    private static final boolean clientAuth = false;
    private SSLContext context;
    private SSLServerSocketFactory factory;
    private String[] cipherSuites;
    private static KeyManager[] keyManagers;
    private static TrustManager[] trustManagers;
    private static boolean initialized;

    public SSLSocketFactory() {
        try {
            if (keyManagers == null || trustManagers == null) {
                SSLSocketFactory.initStoresAtStartup();
            }
            this.context = SSLContext.getInstance("TLS");
            this.context.init(keyManagers, trustManagers, SharedSecureRandom.SECURE_RANDOM);
            this.factory = this.context.getServerSocketFactory();
            for (String cipherSuite : this.cipherSuites = this.factory.getSupportedCipherSuites()) {
                _logger.log(Level.FINEST, "Suite: {0}", cipherSuite);
            }
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "Could not initialize the SSL Socket Factory!", e);
        }
    }

    public ServerSocket createSocket(int port) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        this.init(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket socket = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        this.init(socket);
        return socket;
    }

    public static synchronized void initStoresAtStartup() throws Exception {
        if (initialized) {
            return;
        }
        SSLUtils sslUtils = (SSLUtils)Globals.getDefaultHabitat().getService(SSLUtils.class, new Annotation[0]);
        keyManagers = sslUtils.getKeyManagers();
        trustManagers = sslUtils.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLS");
        String keyAlias = System.getProperty("com.sun.enterprise.security.httpsOutboundKeyAlias");
        KeyManager[] keyManagers = sslUtils.getKeyManagers();
        if (keyAlias != null && keyAlias.length() > 0 && keyManagers != null) {
            for (int i = 0; i < keyManagers.length; ++i) {
                keyManagers[i] = new J2EEKeyManager((X509KeyManager)keyManagers[i], keyAlias);
            }
        }
        sslContext.init(keyManagers, sslUtils.getTrustManagers(), null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslContext.getSocketFactory());
        initialized = true;
    }

    private void init(SSLServerSocket socket) {
        socket.setNeedClientAuth(false);
    }
}

