/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator;

import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;

class TypeMath {
    protected final ProcessingEnvironment env;
    final SimpleTypeVisitor6<TypeMirror, TypeElement> baseClassFinder = new SimpleTypeVisitor6<TypeMirror, TypeElement>(){

        @Override
        public TypeMirror visitDeclared(DeclaredType t, TypeElement sup) {
            TypeMirror r = this.onDeclaredType(t, sup);
            if (r != null) {
                return r;
            }
            Element e = t.asElement();
            switch (e.getKind()) {
                case CLASS: {
                    TypeMirror sc = ((TypeElement)e).getSuperclass();
                    if (!TypeKind.NONE.equals((Object)sc.getKind())) {
                        r = this.visitDeclared((DeclaredType)sc, sup);
                    }
                    if (r == null) break;
                    return r;
                }
            }
            return null;
        }

        @Override
        protected TypeMirror defaultAction(TypeMirror e, TypeElement typeElement) {
            return null;
        }

        private TypeMirror onDeclaredType(DeclaredType t, TypeElement sup) {
            if (t.asElement().equals(sup)) {
                return t;
            }
            for (TypeMirror typeMirror : TypeMath.this.env.getTypeUtils().directSupertypes(t)) {
                TypeMirror r = this.visitDeclared((DeclaredType)typeMirror, sup);
                if (r == null) continue;
                return r;
            }
            return null;
        }

        @Override
        public TypeMirror visitTypeVariable(TypeVariable t, TypeElement sup) {
            for (TypeMirror typeMirror : ((TypeParameterElement)t.asElement()).getBounds()) {
                TypeMirror m = (TypeMirror)this.visit(typeMirror, sup);
                if (m == null) continue;
                return m;
            }
            return null;
        }

        @Override
        public TypeMirror visitWildcard(WildcardType type, TypeElement sup) {
            return (TypeMirror)this.visit(type.getExtendsBound(), sup);
        }
    };
    final SimpleTypeVisitor6<JExpression, JExpression> simpleValueConverter = new SimpleTypeVisitor6<JExpression, JExpression>(){

        @Override
        public JExpression visitPrimitive(PrimitiveType type, JExpression param) {
            String kind = type.getKind().toString();
            return JExpr.invoke((String)("as" + kind.charAt(0) + kind.substring(1).toLowerCase(Locale.ENGLISH))).arg(param);
        }

        @Override
        public JExpression visitDeclared(DeclaredType type, JExpression param) {
            String qn = ((TypeElement)type.asElement()).getQualifiedName().toString();
            if (qn.equals("java.lang.String")) {
                return param;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        protected JExpression defaultAction(TypeMirror e, JExpression jExpression) {
            throw new UnsupportedOperationException();
        }
    };

    public TypeMath(ProcessingEnvironment env) {
        this.env = env;
    }

    TypeMirror isCollection(TypeMirror t) {
        TypeMirror collectionType = (TypeMirror)this.baseClassFinder.visit(t, this.env.getElementUtils().getTypeElement(Collection.class.getName()));
        if (collectionType != null) {
            DeclaredType d = (DeclaredType)collectionType;
            return d.getTypeArguments().iterator().next();
        }
        return null;
    }
}

