/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul.handler;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.main.jul.handler.LoggingOutputStream;

public class LoggingPrintStream
extends PrintStream {
    private final ThreadLocal<StackTrace> perThreadStackTraces = new ThreadLocal();

    public static LoggingPrintStream create(Logger logger, Level level, int bufferCapacity, Charset charset) {
        return new LoggingPrintStream(logger, level, bufferCapacity, charset);
    }

    private LoggingPrintStream(Logger logger, Level level, int bufferCapacity, Charset charset) {
        super(null, false, charset);
        this.out = new LoggingOutputStream(logger, level, bufferCapacity, charset);
    }

    private LoggingOutputStream getOutputStream() {
        return (LoggingOutputStream)this.out;
    }

    @Override
    public void println(Object object) {
        if (object instanceof Throwable) {
            this.getOutputStream().addRecord((Throwable)object);
            StackTrace stackTrace = new StackTrace((Throwable)object);
            this.perThreadStackTraces.set(stackTrace);
        } else {
            this.println(String.valueOf(object));
        }
    }

    @Override
    public PrintStream printf(String str, Object ... args) {
        return this.format(str, args);
    }

    @Override
    public PrintStream printf(Locale locale, String str, Object ... args) {
        return this.format(locale, str, args);
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        StringBuilder sb = new StringBuilder(format.length() + 128);
        try (Formatter formatter = new Formatter(sb, Locale.getDefault());){
            formatter.format(format, args);
        }
        this.print(sb.toString());
        return this;
    }

    @Override
    public PrintStream format(Locale locale, String format, Object ... args) {
        StringBuilder sb = new StringBuilder(format.length() + 128);
        try (Formatter formatter = new Formatter(sb, locale);){
            formatter.format(format, args);
        }
        this.print(sb.toString());
        return this;
    }

    @Override
    public void println() {
    }

    @Override
    public void println(String str) {
        StackTrace recentStacktrace = this.perThreadStackTraces.get();
        if (recentStacktrace == null) {
            super.println(str);
            this.flush();
            return;
        }
        if (!recentStacktrace.isStackTraceElement(str)) {
            this.perThreadStackTraces.set(null);
            super.println(str);
            this.flush();
            return;
        }
        if (recentStacktrace.isCompleted()) {
            this.perThreadStackTraces.set(null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        try {
            LoggingPrintStream loggingPrintStream = this;
            synchronized (loggingPrintStream) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(buf, off, len);
                this.out.flush();
            }
        }
        catch (InterruptedIOException x) {
            Thread.currentThread().interrupt();
        }
        catch (IOException x) {
            this.setError();
        }
    }

    public String toString() {
        return super.toString() + " using " + this.out.toString();
    }

    private static final class StackTrace {
        private final String[] stackTrace;
        private int lastIndex;

        private StackTrace(Throwable throwable) {
            this.stackTrace = (String[])Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).toArray(String[]::new);
        }

        boolean isStackTraceElement(String printedLine) {
            if (printedLine.contains(this.stackTrace[this.lastIndex])) {
                ++this.lastIndex;
                return true;
            }
            return false;
        }

        boolean isCompleted() {
            return this.lastIndex >= this.stackTrace.length;
        }
    }
}

