/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import org.jboss.logging.annotations.MessageBundle;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.processor.generator.model.ClassModel;
import org.jboss.logging.processor.generator.model.ClassModelHelper;
import org.jboss.logging.processor.generator.model.MessageBundleImplementor;
import org.jboss.logging.processor.generator.model.MessageBundleTranslator;
import org.jboss.logging.processor.generator.model.MessageLoggerImplementor;
import org.jboss.logging.processor.generator.model.MessageLoggerTranslator;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.util.TranslationHelper;

public class ClassModelFactory {
    private ClassModelFactory() {
    }

    public static ClassModel implementation(ProcessingEnvironment processingEnv, MessageInterface messageInterface) throws IllegalArgumentException {
        if (messageInterface.isAnnotatedWith(MessageBundle.class)) {
            return new MessageBundleImplementor(processingEnv, messageInterface);
        }
        if (messageInterface.isAnnotatedWith(MessageLogger.class)) {
            return new MessageLoggerImplementor(processingEnv, messageInterface);
        }
        throw new IllegalArgumentException(String.format("Message interface %s is not a valid message logger or message bundle.", messageInterface));
    }

    public static ClassModel translation(ProcessingEnvironment processingEnv, MessageInterface messageInterface, String translationSuffix, Map<MessageMethod, String> translations) throws IllegalArgumentException {
        String generatedClassName = ClassModelHelper.implementationClassName(messageInterface, translationSuffix);
        String superClassName = TranslationHelper.getEnclosingTranslationClassName(generatedClassName);
        String locale = translationSuffix.substring(1);
        if (messageInterface.isAnnotatedWith(MessageBundle.class)) {
            return new MessageBundleTranslator(processingEnv, messageInterface, generatedClassName, superClassName, locale, translations);
        }
        if (messageInterface.isAnnotatedWith(MessageLogger.class)) {
            return new MessageLoggerTranslator(processingEnv, messageInterface, generatedClassName, superClassName, locale, translations);
        }
        throw new IllegalArgumentException(String.format("Message interface %s is not a valid message logger or message bundle.", messageInterface));
    }
}

