/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.utility;

import com.sun.jdo.spi.persistence.utility.Linkable;

public class DoubleLinkedList {
    public Linkable head = null;
    public Linkable tail = null;
    public int size = 0;

    public synchronized Linkable getHead() {
        return this.head;
    }

    public synchronized Linkable getTail() {
        return this.tail;
    }

    public synchronized int getSize() {
        return this.size;
    }

    public synchronized void insertAtHead(Linkable node) {
        if (node instanceof Linkable) {
            if (this.head == null) {
                node.setNext(null);
                node.setPrevious(null);
                this.head = node;
            } else {
                Linkable oldHead = this.head;
                oldHead.setPrevious(node);
                node.setNext(oldHead);
                node.setPrevious(null);
                this.head = node;
            }
            if (this.tail == null) {
                this.tail = node;
            }
            ++this.size;
        }
    }

    public synchronized void insertAtTail(Linkable node) {
        if (node instanceof Linkable) {
            if (this.tail == null) {
                node.setNext(null);
                node.setPrevious(null);
                this.tail = node;
            } else {
                Linkable oldTail = this.tail;
                oldTail.setNext(node);
                node.setNext(null);
                node.setPrevious(oldTail);
                this.tail = node;
            }
            if (this.head == null) {
                this.head = node;
            }
            ++this.size;
        }
    }

    public synchronized Linkable removeFromHead() {
        Linkable node = this.head;
        if (node instanceof Linkable) {
            this.head = node.getNext();
            if (this.head == null) {
                this.tail = null;
            } else {
                this.head.setPrevious(null);
            }
            node.setNext(null);
            node.setPrevious(null);
            --this.size;
        }
        return node;
    }

    public synchronized Linkable removeFromTail() {
        Linkable node = this.tail;
        if (node instanceof Linkable) {
            this.tail = node.getPrevious();
            if (this.tail == null) {
                this.head = null;
            } else {
                this.tail.setNext(null);
            }
            node.setNext(null);
            node.setPrevious(null);
            --this.size;
        }
        return node;
    }

    public synchronized void removeFromList(Linkable node) {
        if (this.size <= 0 || this.head == null && this.tail == null) {
            return;
        }
        if (node instanceof Linkable) {
            Linkable p = node.getPrevious();
            Linkable n = node.getNext();
            if (p == null) {
                this.head = n;
            } else {
                p.setNext(n);
            }
            if (n == null) {
                this.tail = p;
            } else {
                n.setPrevious(p);
            }
            node.setNext(null);
            node.setPrevious(null);
            --this.size;
        }
    }

    public synchronized void insertIntoList(Linkable afternode, Linkable newnode) {
        if (newnode instanceof Linkable && afternode instanceof Linkable) {
            if (this.tail == afternode) {
                this.insertAtTail(newnode);
            } else {
                Linkable nextnode = afternode.getNext();
                newnode.setNext(nextnode);
                newnode.setPrevious(afternode);
                afternode.setNext(newnode);
                nextnode.setPrevious(newnode);
            }
            ++this.size;
        }
    }

    public synchronized String toString() {
        return null;
    }
}

