/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TransactionalDataListener;
import com.sun.data.provider.TransactionalDataProvider;
import com.sun.data.provider.impl.AbstractDataProvider;
import com.sun.data.provider.impl.AbstractTableDataProvider;
import com.sun.data.provider.impl.IndexRowKey;
import com.sun.data.provider.impl.ObjectFieldKeySupport;
import java.beans.Beans;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

public class ObjectListDataProvider
extends AbstractTableDataProvider
implements Serializable,
TransactionalDataProvider {
    private List appends = new ArrayList();
    private transient ResourceBundle bundle = null;
    private Set deletes = new TreeSet();
    private boolean includeFields = true;
    private List list = new ArrayList();
    private Class objectType;
    private Map updates = new HashMap();
    private boolean userResizable = true;
    private transient Constructor objectTypeConstructor = null;
    private transient ObjectFieldKeySupport support = null;

    public ObjectListDataProvider() {
        this.setObjectType(null);
    }

    public ObjectListDataProvider(List list) {
        this.setList(list);
    }

    public ObjectListDataProvider(List list, boolean includeFields) {
        this.setList(list);
        this.setIncludeFields(includeFields);
    }

    public ObjectListDataProvider(Class objectType) {
        this.setObjectType(objectType);
    }

    public ObjectListDataProvider(Class objectType, boolean includeFields) {
        this.setObjectType(objectType);
        this.setIncludeFields(includeFields);
    }

    public boolean isIncludeFields() {
        return this.includeFields;
    }

    public void setIncludeFields(boolean includeFields) {
        this.includeFields = includeFields;
        this.support = null;
    }

    public List getList() {
        return this.list;
    }

    public void setList(List list) {
        this.list = list;
        if (list != null && this.objectType == null && list.size() > 0) {
            this.setObjectType(list.get(0).getClass());
            return;
        }
        this.fireProviderChanged();
    }

    public Class getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Class objectType) {
        this.objectType = objectType;
        this.objectTypeConstructor = null;
        this.support = null;
        this.fireProviderChanged();
    }

    public boolean isUserResizable() {
        return this.userResizable;
    }

    public void setUserResizable(boolean resizable) {
        this.userResizable = resizable;
    }

    public void addObject(Object object) {
        if (this.objectType == null) {
            this.setObjectType(object.getClass());
        }
        this.appendRow(object);
    }

    public void clearObjectList() {
        this.list.clear();
        this.fireProviderChanged();
    }

    public Object getObject(RowKey row) {
        return this.list.get(this.getRowIndex(row));
    }

    public Object[] getObjects() {
        return this.list.toArray(new Object[this.list.size()]);
    }

    public boolean isRemoved(RowKey row) {
        return this.deletes.contains(row);
    }

    public void removeObject(Object object) {
        int index = this.list.indexOf(object);
        if (index > -1) {
            this.removeObject(this.getRowKey(index));
        }
    }

    public void removeObject(RowKey row) {
        this.removeRow(row);
    }

    public void setObject(RowKey row, Object object) {
        Object previous = this.getObject(row);
        this.list.set(this.getRowIndex(row), object);
        this.fireValueChanged(null, row, previous, object);
        if (this.getCursorRow() == row) {
            this.fireValueChanged(null, previous, object);
        }
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        FieldKey fieldKey = null;
        if (this.getSupport() != null) {
            fieldKey = this.getSupport().getFieldKey(fieldId);
        }
        if (fieldKey != null) {
            return fieldKey;
        }
        throw new IllegalArgumentException(fieldId);
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.getSupport() != null) {
            return this.getSupport().getFieldKeys();
        }
        return FieldKey.EMPTY_ARRAY;
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        return this.getSupport().getType(fieldKey);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        return this.getValue(fieldKey, this.getCursorRow());
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        this.setValue(fieldKey, this.getCursorRow(), value);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        return this.getSupport().isReadOnly(fieldKey);
    }

    public int getRowCount() throws DataProviderException {
        if (this.list == null) {
            return 0;
        }
        return this.list.size() - this.deletes.size();
    }

    public Object getValue(FieldKey fieldKey, RowKey rowKey) throws DataProviderException {
        Map fieldUpdates;
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        if (Beans.isDesignTime() && (this.list == null || this.list.isEmpty())) {
            this.list = (List)AbstractDataProvider.getFakeData(this.list.getClass(), this.objectType);
        }
        if ((fieldUpdates = (Map)this.updates.get(rowKey)) != null && fieldUpdates.containsKey(fieldKey)) {
            return fieldUpdates.get(fieldKey);
        }
        if (!this.isRowAvailable(rowKey) && !this.deletes.contains(rowKey)) {
            throw new IndexOutOfBoundsException("" + rowKey);
        }
        int index = this.getRowIndex(rowKey);
        if (index < this.list.size()) {
            return this.getSupport().getValue(fieldKey, this.list.get(index));
        }
        return this.getSupport().getValue(fieldKey, this.appends.get(index - this.getRowCount()));
    }

    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        if (this.deletes.contains(row)) {
            return false;
        }
        if (row instanceof IndexRowKey) {
            return this.list.size() + this.appends.size() > ((IndexRowKey)row).getIndex();
        }
        return false;
    }

    public void setValue(FieldKey fieldKey, RowKey rowKey, Object value) throws DataProviderException {
        if (this.getSupport() == null || this.getSupport().getFieldKey(fieldKey.getFieldId()) == null) {
            throw new IllegalArgumentException(fieldKey.toString());
        }
        if (this.getSupport().isReadOnly(fieldKey)) {
            throw new IllegalStateException(fieldKey.toString() + " " + this.getBundle().getString("IS_READ_ONLY"));
        }
        if (!this.isRowAvailable(rowKey) && !this.deletes.contains(rowKey)) {
            throw new IndexOutOfBoundsException(rowKey.toString());
        }
        Object previous = this.getValue(fieldKey, rowKey);
        if (previous == null && value == null || previous != null && value != null && previous.equals(value)) {
            return;
        }
        if (!this.getSupport().isAssignable(fieldKey, value)) {
            throw new IllegalArgumentException(fieldKey + " = " + value);
        }
        HashMap<FieldKey, Object> fieldUpdates = (HashMap<FieldKey, Object>)this.updates.get(rowKey);
        if (fieldUpdates == null) {
            fieldUpdates = new HashMap<FieldKey, Object>();
            this.updates.put(rowKey, fieldUpdates);
        }
        fieldUpdates.put(fieldKey, value);
        this.fireValueChanged(fieldKey, rowKey, previous, value);
        this.fireValueChanged(fieldKey, previous, value);
    }

    public boolean canAppendRow() throws DataProviderException {
        if (!this.userResizable) {
            return false;
        }
        if (this.objectType != null) {
            return this.getObjectTypeConstructor() != null;
        }
        return false;
    }

    public RowKey appendRow() throws DataProviderException {
        if (!this.canAppendRow()) {
            throw new IllegalStateException(this.getBundle().getString("OLDP_NOT_RESIZABLE"));
        }
        try {
            Constructor con = this.getObjectTypeConstructor();
            this.appends.add(con.newInstance(new Object[0]));
            RowKey rowKey = this.getRowKey(this.list.size() + this.appends.size() - 1);
            this.fireRowAdded(rowKey);
            return rowKey;
        }
        catch (Exception x) {
            throw new IllegalStateException(this.getBundle().getString("OLDP_NOT_RESIZABLE") + ":" + x.getMessage());
        }
    }

    public RowKey appendRow(Object object) throws DataProviderException {
        if (!this.userResizable) {
            throw new IllegalStateException(this.getBundle().getString("OLDP_NOT_RESIZABLE"));
        }
        this.appends.add(object);
        RowKey rowKey = this.getRowKey(this.list.size() + this.appends.size() - 1);
        this.fireRowAdded(rowKey);
        return rowKey;
    }

    public boolean canInsertRow(RowKey beforeRow) throws DataProviderException {
        return false;
    }

    public RowKey insertRow(RowKey beforeRow) throws DataProviderException {
        throw new UnsupportedOperationException();
    }

    public boolean canRemoveRow(RowKey row) throws DataProviderException {
        return this.userResizable;
    }

    public void removeRow(RowKey row) throws DataProviderException {
        if (!this.canRemoveRow(row)) {
            throw new IllegalStateException(this.getBundle().getString("OLDP_NOT_RESIZABLE"));
        }
        if (!this.isRowAvailable(row)) {
            throw new IllegalArgumentException(this.getBundle().getString("CAN_NOT_DELETE_ROW_KEY") + row);
        }
        this.deletes.add(row);
        this.fireRowRemoved(row);
        if (this.getCursorRow() == row) {
            this.fireValueChanged(null, this.list.get(this.getRowIndex(row)), null);
        }
    }

    public void commitChanges() throws DataProviderException {
        Iterator rowUpdates = this.updates.entrySet().iterator();
        while (rowUpdates.hasNext()) {
            Map.Entry rowUpdate = rowUpdates.next();
            RowKey rowKey = (RowKey)rowUpdate.getKey();
            int index = this.getRowIndex(rowKey);
            Object row = null;
            row = index < this.list.size() ? this.list.get(index) : this.appends.get(index - this.list.size());
            Iterator fieldUpdates = ((Map)rowUpdate.getValue()).entrySet().iterator();
            while (fieldUpdates.hasNext()) {
                Map.Entry fieldUpdate = fieldUpdates.next();
                this.getSupport().setValue((FieldKey)fieldUpdate.getKey(), row, fieldUpdate.getValue());
            }
        }
        this.updates.clear();
        RowKey[] deletes = this.deletes.toArray(new RowKey[this.deletes.size()]);
        for (int i = deletes.length - 1; i >= 0; --i) {
            this.list.remove(this.getRowIndex(deletes[i]));
        }
        this.deletes.clear();
        Iterator appendInstances = this.appends.iterator();
        while (appendInstances.hasNext()) {
            this.list.add(appendInstances.next());
        }
        this.appends.clear();
        this.fireChangesCommitted();
    }

    public void revertChanges() throws DataProviderException {
        this.updates.clear();
        this.deletes.clear();
        this.appends.clear();
        this.fireChangesReverted();
    }

    public void addTransactionalDataListener(TransactionalDataListener listener) {
        super.addDataListener(listener);
    }

    public TransactionalDataListener[] getTransactionalDataListeners() {
        if (this.dpListeners == null) {
            return new TransactionalDataListener[0];
        }
        ArrayList<DataListener> tdpList = new ArrayList<DataListener>();
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (!(this.dpListeners[i] instanceof TransactionalDataListener)) continue;
            tdpList.add(this.dpListeners[i]);
        }
        return tdpList.toArray(new TransactionalDataListener[tdpList.size()]);
    }

    public void removeTransactionalDataListener(TransactionalDataListener listener) {
        super.removeDataListener(listener);
    }

    private void fireChangesCommitted() {
        TransactionalDataListener[] listeners = this.getTransactionalDataListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].changesCommitted(this);
        }
    }

    private void fireChangesReverted() {
        TransactionalDataListener[] listeners = this.getTransactionalDataListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].changesReverted(this);
        }
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    private Constructor getObjectTypeConstructor() {
        if (this.objectTypeConstructor != null) {
            return this.objectTypeConstructor;
        }
        try {
            Constructor con = this.objectType.getConstructor(new Class[0]);
            if (con != null && Modifier.isPublic(con.getModifiers())) {
                this.objectTypeConstructor = con;
            }
        }
        catch (NoSuchMethodException e) {
            this.objectTypeConstructor = null;
        }
        return this.objectTypeConstructor;
    }

    private int getRowIndex(RowKey rowKey) {
        return ((IndexRowKey)rowKey).getIndex();
    }

    private RowKey getRowKey(int index) {
        return new IndexRowKey(index);
    }

    private ObjectFieldKeySupport getSupport() {
        if (this.support == null && this.objectType != null) {
            this.support = new ObjectFieldKeySupport(this.objectType, this.includeFields);
        }
        return this.support;
    }
}

