/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.jdbc.objects;

import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TxIsolationLevel {
    READ_UNCOMMITTED("read-uncommitted", 1),
    READ_COMMITTED("read-committed", 2),
    REPEATABLE_READ("repeatable-read", 4),
    SERIALIZABLE("serializable", 8);

    private String name;
    private int id;

    private TxIsolationLevel(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static TxIsolationLevel byId(int id) throws IllegalArgumentException {
        return Stream.of(TxIsolationLevel.values()).filter(v -> v.getId() == id).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid transaction isolation level id=" + id + "; possible values: " + Stream.of(TxIsolationLevel.values()).map(t -> Integer.toString(t.getId())).collect(Collectors.joining(", "))));
    }

    public static TxIsolationLevel byName(String name) throws IllegalArgumentException {
        return Stream.of(TxIsolationLevel.values()).filter(v -> v.getName().equals(name)).findAny().orElseThrow(() -> new IllegalArgumentException("Invalid transaction isolation level '" + name + "'; possible values: " + Stream.of(TxIsolationLevel.values()).map(TxIsolationLevel::getName).collect(Collectors.joining(", "))));
    }

    public static String[] getAllNames() {
        return (String[])Stream.of(TxIsolationLevel.values()).map(TxIsolationLevel::getName).toArray(String[]::new);
    }
}

