/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.ejb;

import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.api.persistence.support.PersistenceManagerFactory;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.ApplicationLifeCycleEventListener;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.TransactionHelper;
import jakarta.transaction.RollbackException;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import jakarta.transaction.UserTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class EJBHelper {
    private static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.Bundle", (ClassLoader)EJBHelper.class.getClassLoader());
    static TransactionHelper myHelper = DefaultTransactionHelper.getInstance();

    public static void registerTransactionHelper(TransactionHelper h) {
        myHelper = h;
        if (myHelper == null) {
            myHelper = DefaultTransactionHelper.getInstance();
        }
    }

    public static Transaction getTransaction() {
        return myHelper.getTransaction();
    }

    public static UserTransaction getUserTransaction() {
        return myHelper.getUserTransaction();
    }

    public static boolean isManaged() {
        return myHelper.isManaged();
    }

    public static int translateStatus(int st) {
        return myHelper.translateStatus(st);
    }

    public static PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory pmf) {
        return myHelper.replaceInternalPersistenceManagerFactory(pmf);
    }

    public static Object preInvoke(Object component) {
        return myHelper.preInvoke(component);
    }

    public static void postInvoke(Object im) {
        myHelper.postInvoke(im);
    }

    public static void registerSynchronization(Transaction jta, Synchronization sync) throws RollbackException, SystemException {
        myHelper.registerSynchronization(jta, sync);
    }

    public static Connection getConnection(Object resource, String username, char[] password) throws SQLException {
        return myHelper.getConnection(resource, username, password);
    }

    public static Connection getNonTransactionalConnection(Object resource, String username, char[] password) throws SQLException {
        return myHelper.getNonTransactionalConnection(resource, username, password);
    }

    public static TransactionManager getLocalTransactionManager() {
        return myHelper.getLocalTransactionManager();
    }

    public static Statement unwrapStatement(Statement stmt) {
        return myHelper.unwrapStatement(stmt);
    }

    public static void setPersistenceManagerFactoryDefaults(PersistenceManagerFactory pmf) {
        myHelper.setPersistenceManagerFactoryDefaults(pmf);
    }

    public static String getDDLNamePrefix(Object info) {
        return myHelper.getDDLNamePrefix(info);
    }

    public static void registerApplicationLifeCycleEventListener(ApplicationLifeCycleEventListener listener) {
        myHelper.registerApplicationLifeCycleEventListener(listener);
    }

    public static void notifyApplicationUnloaded(ClassLoader cl) {
        myHelper.notifyApplicationUnloaded(cl);
    }

    private static class DefaultTransactionHelper
    implements TransactionHelper {
        private static final DefaultTransactionHelper instance = new DefaultTransactionHelper();

        private DefaultTransactionHelper() {
        }

        public static DefaultTransactionHelper getInstance() {
            return instance;
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }

        @Override
        public UserTransaction getUserTransaction() {
            return null;
        }

        @Override
        public boolean isManaged() {
            return false;
        }

        @Override
        public int translateStatus(int st) {
            return st;
        }

        @Override
        public PersistenceManagerFactory replaceInternalPersistenceManagerFactory(PersistenceManagerFactory pmf) {
            return pmf;
        }

        @Override
        public Object preInvoke(Object component) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.ejbhelper.nonmanaged", (Object[])new Object[]{"preInvoke"}));
        }

        @Override
        public void postInvoke(Object im) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.ejbhelper.nonmanaged", (Object[])new Object[]{"postInvoke"}));
        }

        @Override
        public void registerSynchronization(Transaction jta, Synchronization sync) throws RollbackException, SystemException {
        }

        @Override
        public Connection getConnection(Object resource, String username, char[] password) throws SQLException {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.ejbhelper.nonmanaged", (Object[])new Object[]{"getConnection"}));
        }

        @Override
        public Connection getNonTransactionalConnection(Object resource, String username, char[] password) throws SQLException {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.ejbhelper.nonmanaged", (Object[])new Object[]{"getNonTransactionalConnection"}));
        }

        @Override
        public TransactionManager getLocalTransactionManager() {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.ejbhelper.nonmanaged", (Object[])new Object[]{"getLocalTransactionManager"}));
        }

        @Override
        public Statement unwrapStatement(Statement stmt) {
            return stmt;
        }

        @Override
        public void setPersistenceManagerFactoryDefaults(PersistenceManagerFactory pmf) {
        }

        @Override
        public String getDDLNamePrefix(Object info) {
            throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"ejb.ejbhelper.nonmanaged", (Object[])new Object[]{"getDDLNamePrefix"}));
        }

        @Override
        public void registerApplicationLifeCycleEventListener(ApplicationLifeCycleEventListener listener) {
        }

        @Override
        public void notifyApplicationUnloaded(ClassLoader cl) {
        }
    }
}

