/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices;

import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.glassfish.webservices.LogUtils;
import org.glassfish.webservices.SOAPMessageContext;

public class SOAPMessageContextImpl
implements SOAPMessageContext {
    private Packet packet = null;
    private SOAPMessage message = null;
    private static final Logger logger = LogUtils.getLogger();

    public SOAPMessageContextImpl(Packet pkt) {
        this.packet = pkt;
    }

    public void setPacket(Packet packet) {
        this.packet = packet;
        this.message = null;
    }

    public SOAPMessage getMessage() {
        if (this.message != null) {
            return this.message;
        }
        SOAPMessage soapMsg = null;
        try {
            if (this.packet.getMessage() != null) {
                Message mutable = this.packet.getMessage().copy();
                soapMsg = mutable.readAsSOAPMessage();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "AS-WSJSR109IMPL-00079", e);
        }
        this.message = soapMsg;
        return soapMsg;
    }

    public void setMessage(SOAPMessage newMsg) {
        this.message = newMsg;
        this.packet.setMessage(Messages.create((SOAPMessage)newMsg));
    }

    public Object[] getHeaders(QName header, JAXBContext jaxbContext, boolean allRoles) {
        return null;
    }

    public Set<String> getRoles() {
        return null;
    }

    public MessageContext.Scope getScope(String name) {
        return null;
    }

    public void setScope(String name, MessageContext.Scope scope) {
    }

    @Override
    public boolean isAlreadySoap() {
        return true;
    }

    public void clear() {
        this.packet.invocationProperties.clear();
    }

    public boolean containsKey(Object obj) {
        if (this.packet.supports(obj)) {
            return this.packet.containsKey(obj);
        }
        return this.packet.invocationProperties.containsKey(obj);
    }

    public boolean containsValue(Object obj) {
        return this.packet.invocationProperties.containsValue(obj);
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return this.packet.invocationProperties.entrySet();
    }

    public Object get(Object obj) {
        if (this.packet.supports(obj)) {
            return this.packet.get(obj);
        }
        return this.packet.invocationProperties.get(obj);
    }

    public boolean isEmpty() {
        return this.packet.invocationProperties.isEmpty();
    }

    public Set<String> keySet() {
        return this.packet.invocationProperties.keySet();
    }

    public Object put(String str, Object obj) {
        return this.packet.invocationProperties.put(str, obj);
    }

    public void putAll(Map<? extends String, ? extends Object> map) {
        this.packet.invocationProperties.putAll(map);
    }

    public Object remove(Object obj) {
        return this.packet.invocationProperties.remove(obj);
    }

    public int size() {
        return this.packet.invocationProperties.size();
    }

    public Collection<Object> values() {
        return this.packet.invocationProperties.values();
    }
}

