/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ModelSerializer;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.util.JSLValidationEventHandler;
import com.ibm.jbatch.jsl.util.ValidatorHelper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;

public class JobModelSerializerImpl
implements ModelSerializer<JSLJob> {
    @Override
    public String serializeModel(JSLJob model) {
        final JSLJob finalModel = model;
        String serializedModel = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return JobModelSerializerImpl.this.marshalJSLJob(finalModel);
            }
        });
        return serializedModel;
    }

    private String marshalJSLJob(JSLJob job) {
        String resultXML = null;
        JSLValidationEventHandler handler = new JSLValidationEventHandler();
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)"com.ibm.jbatch.jsl.model");
            Marshaller m = ctx.createMarshaller();
            m.setSchema(ValidatorHelper.getXJCLSchema());
            m.setEventHandler((ValidationEventHandler)handler);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            m.marshal((Object)new JAXBElement(new QName("https://jakarta.ee/xml/ns/jakartaee", "job"), JSLJob.class, (Object)job), (OutputStream)baos);
            resultXML = baos.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception while marshalling JSLJob", e);
        }
        return resultXML;
    }
}

