/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPOutputStream;
import org.apache.catalina.Container;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StoreBase;
import org.glassfish.web.ha.LogFacade;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;

public abstract class HAStoreBase
extends StoreBase {
    protected JavaEEIOUtils ioUtils;
    static final Logger _logger = LogFacade.getLogger();
    protected int _debug = 0;
    protected Level _logLevel = Level.FINE;
    protected String applicationId = null;
    protected String clusterId = null;

    public HAStoreBase(JavaEEIOUtils ioUtils) {
        this.ioUtils = ioUtils;
    }

    protected void debug(String message) {
        this.log(message);
    }

    protected void setLogLevel() {
        Level level;
        this._logLevel = level = _logger.getLevel();
        if (this._logLevel == null) {
            this._logLevel = Level.FINE;
        }
        this._debug = this._logLevel.equals(Level.FINE) ? 1 : (this._logLevel.equals(Level.FINER) ? 2 : (this._logLevel.equals(Level.FINEST) ? 5 : 0));
    }

    public String getApplicationId() {
        if (this.applicationId != null) {
            return this.applicationId;
        }
        StringBuffer sb = new StringBuffer(50);
        sb.append(this.getClusterId());
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (Container container = this.manager.getContainer(); container != null; container = container.getParent()) {
            if (container.getName() == null) continue;
            list.add((CallSite)((Object)(":" + container.getName())));
        }
        for (int i = list.size() - 1; i > -1; --i) {
            String nextString = (String)list.get(i);
            sb.append(nextString);
        }
        this.applicationId = sb.toString();
        return this.applicationId;
    }

    protected String getClusterIdFromConfig() {
        return null;
    }

    protected String getClusterId() {
        if (this.clusterId == null) {
            this.clusterId = this.getClusterIdFromConfig();
        }
        return this.clusterId;
    }

    public byte[] getByteArray(Session session) throws IOException {
        return this.getByteArray(session, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Session session, boolean compress) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        try (ObjectOutputStream oos = null;){
            bos = new ByteArrayOutputStream();
            try {
                oos = compress ? this.ioUtils.createObjectOutputStream((OutputStream)new GZIPOutputStream(new BufferedOutputStream(bos)), true) : this.ioUtils.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oos == null) {
                oos = compress ? new ObjectOutputStream(new GZIPOutputStream(new BufferedOutputStream(bos))) : new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            this.writeSession(session, oos);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        return obs;
    }

    public void remove(String id) throws IOException {
        if (this._debug > 0) {
            this.debug("in remove");
        }
        if (id == null) {
            if (this._debug > 0) {
                this.debug("In remove, got a null id");
            }
            return;
        }
        Manager mgr = this.getManager();
        if (mgr instanceof ReplicationManagerBase) {
            ReplicationManagerBase pMgr = (ReplicationManagerBase)mgr;
            pMgr.doRemove(id);
        } else {
            this.removeSynchronized(id);
        }
    }

    public void doRemove(String id) throws IOException {
    }

    public synchronized void removeSynchronized(String id) throws IOException {
    }

    public int getSize() throws IOException {
        return 0;
    }
}

