/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.AdminCallbackHandler;
import com.sun.enterprise.admin.util.AdminIndicatorPrincipal;
import com.sun.enterprise.admin.util.AdminLocalPasswordPrincipal;
import com.sun.enterprise.admin.util.AdminTokenPrincipal;
import com.sun.enterprise.admin.util.GenericAdminAuthenticator;
import com.sun.enterprise.admin.util.Strings;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminPrincipal;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.common.util.admin.AdminAuthenticator;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.common.util.admin.RestSessionManager;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.LocalPassword;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AdminLoginModule
implements LoginModule {
    private static final Logger logger = GenericAdminAuthenticator.ADMSEC_LOGGER;
    private static final Level PROGRESS_LEVEL = Level.FINE;
    @Inject
    private Domain domain;
    @Inject
    private AuthTokenManager authTokenManager;
    @Inject
    private LocalPassword localPassword;
    @Inject
    private RestSessionManager restSessionManager;
    private SecureAdmin secureAdmin = null;
    private boolean isAuthenticated;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private final Subject subjectToAssemble = new Subject();
    private final UsernamePasswordAuthenticator usernamePasswordAuth = new UsernamePasswordAuthenticator();
    private final PrincipalAuthenticator principalAuth = new PrincipalAuthenticator();
    private final AdminIndicatorAuthenticator adminIndicatorAuth = new AdminIndicatorAuthenticator();
    private final AdminTokenAuthenticator adminTokenAuth = new AdminTokenAuthenticator();
    private final RemoteHostAuthenticator remoteHostAuth = new RemoteHostAuthenticator();
    private final RestAdminAuthenticator restTokenAuthenticator = new RestAdminAuthenticator();
    private List<Callback> callbacks;
    private List<AdminAuthenticator> authenticators;

    public AdminLoginModule() {
        this.callbacks = new ArrayList<Callback>(Arrays.asList(this.usernamePasswordAuth.nameCB, this.usernamePasswordAuth.pwCB, this.principalAuth.cb, this.adminIndicatorAuth.cb, this.adminTokenAuth.cb, this.remoteHostAuth.cb, this.restTokenAuthenticator.restTokenCB, this.restTokenAuthenticator.remoteAddrCB));
        this.authenticators = new ArrayList<Authenticator>(Arrays.asList(this.usernamePasswordAuth, this.principalAuth, this.adminIndicatorAuth, this.adminTokenAuth, this.restTokenAuthenticator));
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        if (callbackHandler instanceof AdminCallbackHandler) {
            ServiceLocator sl = ((AdminCallbackHandler)callbackHandler).getServiceLocator();
            this.findServices(sl);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    private void findServices(ServiceLocator sl) {
        this.domain = (Domain)sl.getService(Domain.class, new Annotation[0]);
        this.secureAdmin = this.domain.getSecureAdmin();
        this.authTokenManager = (AuthTokenManager)sl.getService(AuthTokenManager.class, new Annotation[0]);
        this.localPassword = (LocalPassword)sl.getService(LocalPassword.class, new Annotation[0]);
        this.restSessionManager = (RestSessionManager)sl.getService(RestSessionManager.class, new Annotation[0]);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(Strings.get("secure.admin.noCallbackHandler"));
        }
        try {
            this.callbackHandler.handle(this.callbacks.toArray(new Callback[this.callbacks.size()]));
        }
        catch (Exception ex) {
            LoginException lex = new LoginException();
            lex.initCause(ex);
            throw lex;
        }
        this.isAuthenticated = false;
        for (AdminAuthenticator auth : this.authenticators) {
            this.isAuthenticated |= auth.identify(this.subjectToAssemble);
        }
        logger.log(PROGRESS_LEVEL, "login returning {0}", this.isAuthenticated);
        if (!this.isAuthenticated) {
            throw new LoginException();
        }
        return this.isAuthenticated;
    }

    private void updateFromSubject(Subject subjectToAddTo, Subject subjectToAddFrom) {
        subjectToAddTo.getPrincipals().addAll(subjectToAddFrom.getPrincipals());
        subjectToAddTo.getPrivateCredentials().addAll(subjectToAddFrom.getPrivateCredentials());
        subjectToAddTo.getPublicCredentials().addAll(subjectToAddFrom.getPublicCredentials());
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.isAuthenticated) {
            return false;
        }
        this.updateFromSubject(this.subject, this.subjectToAssemble);
        logger.log(PROGRESS_LEVEL, "commiting");
        Level dumpLevel = Level.FINER;
        if (logger.isLoggable(dumpLevel)) {
            logger.log(dumpLevel, "Following identity attached to subject: {0} principals, {1} private credentials, {2} public credentials", new Object[]{this.subjectToAssemble.getPrincipals().size(), this.subjectToAssemble.getPrivateCredentials().size(), this.subjectToAssemble.getPublicCredentials().size()});
            for (Principal p : this.subjectToAssemble.getPrincipals()) {
                logger.log(dumpLevel, "  principal: {0}", p.getName());
            }
            for (Object c : this.subjectToAssemble.getPrivateCredentials()) {
                logger.log(dumpLevel, "  private credential: {0}", c.toString());
            }
            for (Object c : this.subjectToAssemble.getPublicCredentials()) {
                logger.log(dumpLevel, "  public credential: {0}", c.toString());
            }
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.isAuthenticated) {
            return false;
        }
        logger.log(PROGRESS_LEVEL, "aborting");
        this.removeAddedInfo();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        logger.log(PROGRESS_LEVEL, "logging out");
        this.removeAddedInfo();
        return true;
    }

    private void removeAddedInfo() {
        this.subject.getPrincipals().removeAll(this.subjectToAssemble.getPrincipals());
        this.subject.getPrivateCredentials().removeAll(this.subjectToAssemble.getPrivateCredentials());
        this.subject.getPublicCredentials().removeAll(this.subjectToAssemble.getPublicCredentials());
    }

    class UsernamePasswordAuthenticator
    extends Authenticator {
        final NameCallback nameCB;
        final PasswordCallback pwCB;

        UsernamePasswordAuthenticator() {
            super(AdminAuthenticator.AuthenticatorType.USERNAME_PASSWORD, null);
            this.nameCB = new NameCallback("username");
            this.pwCB = new PasswordCallback("password", false);
        }

        boolean isActive() {
            return this.nameCB.getName() != null || this.pwCB.getPassword() != null;
        }

        public boolean identify(Subject subject) throws LoginException {
            if (AdminLoginModule.this.localPassword == null) {
                return false;
            }
            boolean result = AdminLoginModule.this.localPassword.isLocalPassword(new String(this.pwCB.getPassword()));
            if (result) {
                subject.getPrincipals().add(new AdminLocalPasswordPrincipal());
                logger.log(PROGRESS_LEVEL, "AdminLoginModule detected local password");
            }
            return result;
        }

        @Override
        public List<Callback> callbacks() {
            return new ArrayList<Serializable>(Arrays.asList(this.nameCB, this.pwCB));
        }
    }

    class PrincipalAuthenticator
    extends Authenticator {
        private final PrincipalCallback pcb;

        PrincipalAuthenticator() {
            super(AdminAuthenticator.AuthenticatorType.PRINCIPAL, new PrincipalCallback());
            this.pcb = (PrincipalCallback)this.cb;
        }

        public boolean identify(Subject subject) {
            Principal p = this.pcb.getPrincipal();
            if (p != null) {
                if (this.isPrincipalFromGlassFish(p) && AdminLoginModule.this.usernamePasswordAuth.isActive()) {
                    logger.log(PROGRESS_LEVEL, "Detected console request - not adding SSL principal to the subject");
                    return false;
                }
                subject.getPrincipals().add(p);
                logger.log(PROGRESS_LEVEL, "Attaching Principal {0}", p.getName());
            }
            return p != null;
        }

        private boolean isPrincipalFromGlassFish(Principal p) {
            for (SecureAdminPrincipal sap : AdminLoginModule.this.secureAdmin.getSecureAdminPrincipal()) {
                if (!sap.getDn().equals(p.getName())) continue;
                return true;
            }
            return false;
        }
    }

    class AdminIndicatorAuthenticator
    extends TextAuthenticator {
        AdminIndicatorAuthenticator() {
            super(AdminAuthenticator.AuthenticatorType.ADMIN_INDICATOR);
        }

        public boolean identify(Subject subject) throws LoginException {
            if (AdminLoginModule.this.secureAdmin == null) {
                return false;
            }
            String providedIndicator = this.textCB.getText();
            SpecialAdminIndicatorChecker checker = new SpecialAdminIndicatorChecker(providedIndicator, AdminLoginModule.this.secureAdmin.getSpecialAdminIndicator(), AdminLoginModule.this.remoteHostAuth.textCB.getText());
            if (checker.result() == SpecialAdminIndicatorChecker.Result.MISMATCHED) {
                throw new LoginException();
            }
            if (checker.result() == SpecialAdminIndicatorChecker.Result.MATCHED) {
                subject.getPrincipals().add(new AdminIndicatorPrincipal(providedIndicator));
                return true;
            }
            return false;
        }
    }

    class AdminTokenAuthenticator
    extends TextAuthenticator {
        AdminTokenAuthenticator() {
            super(AdminAuthenticator.AuthenticatorType.ADMIN_TOKEN);
        }

        public boolean identify(Subject subject) throws LoginException {
            if (AdminLoginModule.this.authTokenManager == null) {
                return false;
            }
            Subject s = null;
            String token = this.textCB.getText();
            if (token != null && (s = AdminLoginModule.this.authTokenManager.findToken(token)) != null) {
                logger.log(PROGRESS_LEVEL, "Recognized valid limited-use token");
                AdminLoginModule.this.updateFromSubject(subject, s);
                subject.getPrincipals().add(new AdminTokenPrincipal(token));
            }
            return s != null;
        }
    }

    class RemoteHostAuthenticator
    extends TextAuthenticator {
        RemoteHostAuthenticator() {
            super(AdminAuthenticator.AuthenticatorType.REMOTE_HOST);
        }

        public boolean identify(Subject subject) throws LoginException {
            return false;
        }
    }

    class RestAdminAuthenticator
    extends Authenticator {
        private TextInputCallback restTokenCB;
        private TextInputCallback remoteAddrCB;

        RestAdminAuthenticator() {
            super(AdminAuthenticator.AuthenticatorType.REST_TOKEN, null);
            this.restTokenCB = new TextInputCallback("REST_TOKEN");
            this.remoteAddrCB = new TextInputCallback("REMOTE_ADDR");
        }

        @Override
        public List<Callback> callbacks() {
            return new ArrayList<Callback>(Arrays.asList(this.cb, this.remoteAddrCB));
        }

        public boolean identify(Subject subject) throws LoginException {
            Subject s;
            if (AdminLoginModule.this.restSessionManager == null) {
                return false;
            }
            boolean result = false;
            String token = this.restTokenCB.getText();
            String remoteAddr = this.remoteAddrCB.getText();
            if (token != null && remoteAddr != null && (s = AdminLoginModule.this.restSessionManager.authenticate(token, remoteAddr)) != null) {
                result = true;
                AdminLoginModule.this.updateFromSubject(subject, s);
                logger.log(PROGRESS_LEVEL, "Detected ReST token");
            }
            return result;
        }
    }

    abstract class Authenticator
    implements AdminAuthenticator {
        private final AdminAuthenticator.AuthenticatorType type;
        final Callback cb;

        Authenticator(AdminAuthenticator.AuthenticatorType type, Callback cb) {
            this.type = type;
            this.cb = cb;
        }

        public List<Callback> callbacks() {
            return new ArrayList<Callback>(Arrays.asList(this.cb));
        }

        public AdminAuthenticator.AuthenticatorType type() {
            return this.type;
        }
    }

    abstract class TextAuthenticator
    extends Authenticator {
        final TextInputCallback textCB;

        TextAuthenticator(AdminAuthenticator.AuthenticatorType type) {
            super(type, new TextInputCallback(type.name()));
            this.textCB = (TextInputCallback)this.cb;
        }
    }

    private static class SpecialAdminIndicatorChecker {
        private final Result _result;

        private SpecialAdminIndicatorChecker(String actualIndicator, String expectedIndicator, String originHost) {
            Level dumpLevel = Level.FINER;
            if (actualIndicator != null) {
                if (actualIndicator.equals(expectedIndicator)) {
                    this._result = Result.MATCHED;
                    logger.log(dumpLevel, "Admin request contains expected domain ID");
                } else {
                    logger.log(Level.WARNING, "NCLS-ADMIN-00014", new Object[]{originHost, actualIndicator, expectedIndicator});
                    this._result = Result.MISMATCHED;
                }
            } else {
                logger.log(dumpLevel, "Admin request contains no domain ID; this is OK - continuing");
                this._result = Result.NOT_IN_REQUEST;
            }
        }

        private Result result() {
            return this._result;
        }

        private static enum Result {
            NOT_IN_REQUEST,
            MATCHED,
            MISMATCHED;

        }
    }

    static class PrincipalCallback
    implements Callback,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Principal p;

        PrincipalCallback() {
        }

        public void setPrincipal(Principal p) {
            this.p = p;
        }

        public Principal getPrincipal() {
            return this.p;
        }
    }
}

