/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch.spi.impl;

import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.sun.enterprise.config.serverbeans.Config;
import jakarta.inject.Inject;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.jvnet.hk2.annotations.Service;

@Service
public class GlassFishBatchSecurityHelper
implements BatchSecurityHelper {
    @Inject
    private InvocationManager invocationManager;
    @Inject
    Config config;
    private ThreadLocal<Boolean> invocationPrivilege = new ThreadLocal();

    public void markInvocationPrivilege(boolean isAdmin) {
        this.invocationPrivilege.set(isAdmin);
    }

    public String getCurrentTag() {
        ComponentInvocation compInv = this.invocationManager.getCurrentInvocation();
        return compInv == null ? null : this.config.getName() + ":" + compInv.getAppName();
    }

    public boolean isAdmin(String tag) {
        Boolean result = this.invocationPrivilege.get();
        return result != null ? result : tag == null;
    }

    public boolean isVisibleToThisInstance(String tagName) {
        return tagName.startsWith(this.config.getName());
    }
}

