/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import java.beans.Introspector;
import java.lang.ref.Reference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.ResourceBundle;
import org.glassfish.web.loader.LogFacade;
import org.glassfish.web.loader.ResourceEntry;
import org.glassfish.web.loader.WebappClassLoader;
import org.glassfish.web.util.IntrospectionUtils;

class ReferenceCleaner {
    private static final System.Logger LOG = LogFacade.getSysLogger(ReferenceCleaner.class);
    private final WebappClassLoader loader;

    ReferenceCleaner(WebappClassLoader loader) {
        this.loader = loader;
    }

    void clearReferences(Collection<ResourceEntry> resourceEntries) {
        ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.loader));
            this.clearReferencesJdbc();
            this.checkThreadLocalsForLeaks();
            if (resourceEntries != null) {
                this.clearReferencesStaticFinal(resourceEntries);
            }
            IntrospectionUtils.clear();
            ResourceBundle.clearCache((ClassLoader)((Object)this.loader));
            Introspector.flushCaches();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCl);
        }
    }

    private void clearReferencesJdbc() {
        LOG.log(System.Logger.Level.TRACE, "clearReferencesJdbc()");
        DriverManager.drivers().filter(driver -> driver.getClass().getClassLoader() == this.loader).forEach(this::deregisterDriver);
    }

    private void deregisterDriver(Driver driver) {
        try {
            DriverManager.deregisterDriver(driver);
            LOG.log(System.Logger.Level.WARNING, "AS-WEB-UTIL-00007", this.loader.getName(), driver.getClass());
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, LogFacade.getString("AS-WEB-UTIL-00008", this.loader.getName()), (Throwable)e);
        }
    }

    private void checkThreadLocalsForLeaks() {
        LOG.log(System.Logger.Level.TRACE, "checkThreadLocalsForLeaks()");
        try {
            Thread[] threads;
            Field threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            ReferenceCleaner.setAccessible(threadLocalsField);
            Field inheritableThreadLocalsField = Thread.class.getDeclaredField("inheritableThreadLocals");
            ReferenceCleaner.setAccessible(inheritableThreadLocalsField);
            Class<?> tlmClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
            Field tableField = tlmClass.getDeclaredField("table");
            ReferenceCleaner.setAccessible(tableField);
            Method expungeStaleEntriesMethod = tlmClass.getDeclaredMethod("expungeStaleEntries", new Class[0]);
            ReferenceCleaner.setAccessible(expungeStaleEntriesMethod);
            for (Thread thread : threads = this.getThreads()) {
                Object inheritableMap;
                if (thread == null) continue;
                Object threadLocalMap = threadLocalsField.get(thread);
                if (threadLocalMap != null) {
                    expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
                    this.checkThreadLocalMapForLeaks(threadLocalMap, tableField);
                }
                if ((inheritableMap = inheritableThreadLocalsField.get(thread)) == null) continue;
                expungeStaleEntriesMethod.invoke(inheritableMap, new Object[0]);
                this.checkThreadLocalMapForLeaks(inheritableMap, tableField);
            }
        }
        catch (InaccessibleObjectException e) {
            LOG.log(System.Logger.Level.WARNING, LogFacade.getString("AS-WEB-UTIL-00012", this.loader.getName()));
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, LogFacade.getString("AS-WEB-UTIL-00011", this.loader.getName()), (Throwable)e);
        }
    }

    private Thread[] getThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    private void checkThreadLocalMapForLeaks(Object threadLocalMap, Field internalTableField) throws IllegalAccessException, NoSuchFieldException {
        Object[] table = (Object[])internalTableField.get(threadLocalMap);
        if (table == null) {
            return;
        }
        for (Object element : table) {
            if (element == null) continue;
            Object key = ((Reference)element).get();
            boolean keyLeak = this.isLeaked(key);
            Field valueField = element.getClass().getDeclaredField("value");
            ReferenceCleaner.setAccessible(valueField);
            Object value = valueField.get(element);
            boolean valueLeak = this.isLeaked(value);
            if (!keyLeak && !valueLeak) continue;
            String keyDescription = ReferenceCleaner.describe(key);
            if (keyLeak) {
                LOG.log(System.Logger.Level.ERROR, "AS-WEB-UTIL-00015", this.loader.getName(), keyDescription);
            }
            if (!valueLeak) continue;
            LOG.log(System.Logger.Level.ERROR, "AS-WEB-UTIL-00016", this.loader.getName(), keyDescription, ReferenceCleaner.describe(value));
        }
    }

    private void clearReferencesStaticFinal(Collection<ResourceEntry> resourceEntries) {
        Field[] fields;
        Class<?> clazz;
        LOG.log(System.Logger.Level.TRACE, "clearReferencesStaticFinal(resourceEntries={0})", resourceEntries);
        Iterator<ResourceEntry> loadedClasses = resourceEntries.iterator();
        block6: while (loadedClasses.hasNext()) {
            clazz = loadedClasses.next().loadedClass;
            if (clazz == null) continue;
            try {
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!Modifier.isStatic(field.getModifiers())) continue;
                    ReferenceCleaner.setAccessible(field);
                    field.get(null);
                    continue block6;
                }
            }
            catch (Exception t) {
                LOG.log(System.Logger.Level.TRACE, () -> MessageFormat.format("Failed to clear references for {0}.", clazz), (Throwable)t);
            }
        }
        loadedClasses = resourceEntries.iterator();
        while (loadedClasses.hasNext()) {
            clazz = loadedClasses.next().loadedClass;
            if (clazz == null) continue;
            try {
                for (Field field : fields = clazz.getDeclaredFields()) {
                    int mods = field.getModifiers();
                    if (field.isEnumConstant() || field.getType().isPrimitive() || field.getName().indexOf(36) != -1 || !Modifier.isStatic(mods)) continue;
                    try {
                        ReferenceCleaner.setAccessible(field);
                        if (Modifier.isFinal(mods)) {
                            if (field.getType().getName().startsWith("java.") || field.getType().getName().startsWith("javax.")) continue;
                            this.nullInstance(field.get(null));
                            continue;
                        }
                        field.set(null, null);
                        LOG.log(System.Logger.Level.TRACE, "Set field {0} to null in {1}", field.getName(), clazz);
                    }
                    catch (Exception e) {
                        LOG.log(System.Logger.Level.TRACE, () -> MessageFormat.format("Could not set field {0} to null in {1}", field.getName(), clazz), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.DEBUG, () -> MessageFormat.format("Could not clean fields for {0}", clazz), (Throwable)e);
            }
        }
    }

    private boolean isLeaked(Object object) {
        if (object == null) {
            return false;
        }
        if (this.loader.equals(object)) {
            return true;
        }
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        for (ClassLoader cl = clazz.getClassLoader(); cl != null; cl = cl.getParent()) {
            if (cl != this.loader) continue;
            return true;
        }
        if (object instanceof Iterable) {
            for (Object entry : (Iterable)object) {
                if (!this.isLeaked(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private void nullInstance(Object instance) {
        Field[] fields;
        if (instance == null) {
            return;
        }
        for (Field field : fields = instance.getClass().getDeclaredFields()) {
            int mods = field.getModifiers();
            if (field.getType().isPrimitive() || field.getName().indexOf("$") != -1) continue;
            try {
                Class<?> valueClass;
                if (Modifier.isStatic(mods) && Modifier.isFinal(mods)) continue;
                ReferenceCleaner.setAccessible(field);
                Object value = field.get(instance);
                if (value == null || !this.isLeaked(valueClass = value.getClass())) continue;
                field.set(instance, null);
                LOG.log(System.Logger.Level.TRACE, "Set field {0}, to null in {1}", field.getName(), instance.getClass());
            }
            catch (Exception t) {
                LOG.log(System.Logger.Level.DEBUG, () -> MessageFormat.format("Could not set field {0} to null in object instance of {1}", field.getName(), instance.getClass()), (Throwable)t);
            }
        }
    }

    private static void setAccessible(AccessibleObject acessible) {
        if (System.getSecurityManager() == null) {
            acessible.setAccessible(true);
        } else {
            PrivilegedAction<Void> action = () -> {
                acessible.setAccessible(true);
                return null;
            };
            AccessController.doPrivileged(action);
        }
    }

    private static String describe(Object object) {
        if (object == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(128);
        b.append(ReferenceCleaner.getClass(object)).append(" (toString: ").append(ReferenceCleaner.toString(object)).append(')');
        return b.toString();
    }

    private static Class<?> getClass(Object object) {
        try {
            return object.getClass();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.DEBUG, "Getting class failed, using null.", (Throwable)e);
            return null;
        }
    }

    private static String toString(Object object) {
        try {
            return object.toString();
        }
        catch (NullPointerException e) {
            LOG.log(System.Logger.Level.WARNING, "The object's toString failed, using 'unknown'.", (Throwable)e);
            return "unknown";
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.DEBUG, "The object's toString failed, using 'unknown'.", (Throwable)e);
            return "unknown";
        }
    }
}

