/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.web.loader.LogFacade;

public final class IntrospectionUtils {
    private static final Logger log = LogFacade.getLogger();
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");
    static Hashtable<Class<?>, Method[]> objectMethods = new Hashtable();
    static Object[] emptyArray = new Object[0];

    public static void execute(Object proxy, String method) throws Exception {
        Class[] params;
        Method executeM = null;
        Class<?> c = proxy.getClass();
        executeM = IntrospectionUtils.findMethod(c, method, params = new Class[0]);
        if (executeM == null) {
            throw new RuntimeException("No execute in " + String.valueOf(proxy.getClass()));
        }
        executeM.invoke(proxy, (Object[])null);
    }

    public static void setAttribute(Object proxy, String n, Object v) throws Exception {
        if (proxy instanceof AttributeHolder) {
            ((AttributeHolder)proxy).setAttribute(n, v);
            return;
        }
        Method executeM = null;
        Class<?> c = proxy.getClass();
        Class[] params = new Class[]{String.class, Object.class};
        executeM = IntrospectionUtils.findMethod(c, "setAttribute", params);
        if (executeM == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No setAttribute in " + String.valueOf(proxy.getClass()));
            }
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("Setting " + n + "=" + String.valueOf(v) + "  in " + String.valueOf(proxy));
        }
        executeM.invoke(proxy, n, v);
    }

    public static Object getAttribute(Object proxy, String n) throws Exception {
        Method executeM = null;
        Class<?> c = proxy.getClass();
        Class[] params = new Class[]{String.class};
        executeM = IntrospectionUtils.findMethod(c, "getAttribute", params);
        if (executeM == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("No getAttribute in " + String.valueOf(proxy.getClass()));
            }
            return null;
        }
        return executeM.invoke(proxy, n);
    }

    public static ClassLoader getURLClassLoader(URL[] urls, ClassLoader parent) {
        try {
            Class<?> urlCL = Class.forName("java.net.URLClassLoader");
            Class[] paramT = new Class[]{urls.getClass(), ClassLoader.class};
            Method m = IntrospectionUtils.findMethod(urlCL, "newInstance", paramT);
            if (m == null) {
                return null;
            }
            ClassLoader cl = (ClassLoader)m.invoke(urlCL, urls, parent);
            return cl;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String guessInstall(String installSysProp, String homeSysProp, String jarName) {
        return IntrospectionUtils.guessInstall(installSysProp, homeSysProp, jarName, null);
    }

    public static String guessInstall(String installSysProp, String homeSysProp, String jarName, String classFile) {
        String install = null;
        String home = null;
        if (installSysProp != null) {
            install = System.getProperty(installSysProp);
        }
        if (homeSysProp != null) {
            home = System.getProperty(homeSysProp);
        }
        if (install != null) {
            if (home == null) {
                System.getProperties().put(homeSysProp, install);
            }
            return install;
        }
        String cpath = System.getProperty("java.class.path");
        String pathSep = System.getProperty("path.separator");
        StringTokenizer st = new StringTokenizer(cpath, pathSep);
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            if (path.endsWith(jarName)) {
                home = path.substring(0, path.length() - jarName.length());
                try {
                    if ("".equals(home)) {
                        home = new File("./").getCanonicalPath();
                    } else if (home.endsWith(File.separator)) {
                        home = home.substring(0, home.length() - 1);
                    }
                    File f = new File(home);
                    String parentDir = f.getParent();
                    if (parentDir == null) {
                        parentDir = home;
                    }
                    File f1 = new File(parentDir);
                    install = f1.getCanonicalPath();
                    if (installSysProp != null) {
                        System.getProperties().put(installSysProp, install);
                    }
                    if (homeSysProp != null) {
                        System.getProperties().put(homeSysProp, install);
                    }
                    return install;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    continue;
                }
            }
            String fname = path + (path.endsWith("/") ? "" : "/") + classFile;
            if (!new File(fname).exists()) continue;
            try {
                File f = new File(path);
                String parentDir = f.getParent();
                if (parentDir == null) {
                    parentDir = path;
                }
                File f1 = new File(parentDir);
                install = f1.getCanonicalPath();
                if (installSysProp != null) {
                    System.getProperties().put(installSysProp, install);
                }
                if (home == null && homeSysProp != null) {
                    System.getProperties().put(homeSysProp, install);
                }
                return install;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (home != null) {
            System.getProperties().put(installSysProp, home);
            return home;
        }
        return null;
    }

    public static void displayClassPath(String msg, URL[] cp) {
        if (log.isLoggable(Level.FINE)) {
            log.fine(msg);
            for (URL element : cp) {
                log.fine(element.getFile());
            }
        }
    }

    public static String classPathAdd(URL[] urls, String cp) {
        if (urls == null) {
            return cp;
        }
        for (URL url : urls) {
            cp = cp != null ? (String)cp + PATH_SEPARATOR + url.getFile() : url.getFile();
        }
        return cp;
    }

    public static boolean setProperty(Object o, String name, String value) {
        return IntrospectionUtils.setProperty(o, name, value, true);
    }

    public static boolean setProperty(Object o, String name, String value, boolean invokeSetProperty) {
        block34: {
            if (log.isLoggable(Level.FINE)) {
                log.fine("IntrospectionUtils: setProperty(" + String.valueOf(o.getClass()) + " " + name + "=" + value + ")");
            }
            String setter = "set" + IntrospectionUtils.capitalize(name);
            try {
                Method[] methods = IntrospectionUtils.findMethods(o.getClass());
                Method setPropertyMethodVoid = null;
                Method setPropertyMethodBool = null;
                for (Method method : methods) {
                    Class<?>[] paramT = method.getParameterTypes();
                    if (!setter.equals(method.getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                    method.invoke(o, value);
                    return true;
                }
                for (Method method : methods) {
                    boolean ok = true;
                    if (setter.equals(method.getName()) && method.getParameterTypes().length == 1) {
                        Class<?> paramType = method.getParameterTypes()[0];
                        Object[] params = new Object[1];
                        if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                            try {
                                params[0] = Integer.valueOf(value);
                            }
                            catch (NumberFormatException ex) {
                                ok = false;
                            }
                        } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                            try {
                                params[0] = Long.valueOf(value);
                            }
                            catch (NumberFormatException ex) {
                                ok = false;
                            }
                        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                            params[0] = Boolean.valueOf(value);
                        } else if ("java.net.InetAddress".equals(paramType.getName())) {
                            try {
                                params[0] = InetAddress.getByName(value);
                            }
                            catch (UnknownHostException exc) {
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("IntrospectionUtils: Unable to resolve host name:" + value);
                                }
                                ok = false;
                            }
                        } else if (log.isLoggable(Level.FINE)) {
                            log.fine("IntrospectionUtils: Unknown type " + paramType.getName());
                        }
                        if (ok) {
                            method.invoke(o, params);
                            return true;
                        }
                    }
                    if (!"setProperty".equals(method.getName())) continue;
                    if (method.getReturnType() == Boolean.TYPE) {
                        setPropertyMethodBool = method;
                        continue;
                    }
                    setPropertyMethodVoid = method;
                }
                if (invokeSetProperty && (setPropertyMethodBool != null || setPropertyMethodVoid != null)) {
                    Object[] params = new Object[]{name, value};
                    if (setPropertyMethodBool != null) {
                        try {
                            return (Boolean)setPropertyMethodBool.invoke(o, params);
                        }
                        catch (IllegalArgumentException biae) {
                            if (setPropertyMethodVoid != null) {
                                setPropertyMethodVoid.invoke(o, params);
                                return true;
                            }
                            throw biae;
                        }
                    }
                    setPropertyMethodVoid.invoke(o, params);
                    return true;
                }
            }
            catch (IllegalArgumentException ex2) {
                log.log(Level.WARNING, "IAE " + String.valueOf(o) + " " + name + " " + value, ex2);
            }
            catch (SecurityException ex1) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "IntrospectionUtils: SecurityException for " + String.valueOf(o.getClass()) + " " + name + "=" + value + ")", ex1);
                }
            }
            catch (IllegalAccessException iae) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "IntrospectionUtils: IllegalAccessException for " + String.valueOf(o.getClass()) + " " + name + "=" + value + ")", iae);
                }
            }
            catch (InvocationTargetException ie) {
                if (!log.isLoggable(Level.FINE)) break block34;
                log.log(Level.FINE, "IntrospectionUtils: InvocationTargetException for " + String.valueOf(o.getClass()) + " " + name + "=" + value + ")", ie);
            }
        }
        return false;
    }

    public static Object getProperty(Object o, String name) {
        block11: {
            String getter = "get" + IntrospectionUtils.capitalize(name);
            String isGetter = "is" + IntrospectionUtils.capitalize(name);
            try {
                Method[] methods = IntrospectionUtils.findMethods(o.getClass());
                Method getPropertyMethod = null;
                for (Method method : methods) {
                    Class<?>[] paramT = method.getParameterTypes();
                    if (getter.equals(method.getName()) && paramT.length == 0) {
                        return method.invoke(o, (Object[])null);
                    }
                    if (isGetter.equals(method.getName()) && paramT.length == 0) {
                        return method.invoke(o, (Object[])null);
                    }
                    if (!"getProperty".equals(method.getName())) continue;
                    getPropertyMethod = method;
                }
                if (getPropertyMethod != null) {
                    Object[] params = new Object[]{name};
                    return getPropertyMethod.invoke(o, params);
                }
            }
            catch (IllegalArgumentException ex2) {
                log.log(Level.WARNING, "IAE " + String.valueOf(o) + " " + name, ex2);
            }
            catch (SecurityException ex1) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "IntrospectionUtils: SecurityException for " + String.valueOf(o.getClass()) + " " + name + ")", ex1);
                }
            }
            catch (IllegalAccessException iae) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "IntrospectionUtils: IllegalAccessException for " + String.valueOf(o.getClass()) + " " + name + ")", iae);
                }
            }
            catch (InvocationTargetException ie) {
                if (!log.isLoggable(Level.FINE)) break block11;
                log.log(Level.FINE, "IntrospectionUtils: InvocationTargetException for " + String.valueOf(o.getClass()) + " " + name + ")");
            }
        }
        return null;
    }

    public static void setProperty(Object o, String name) {
        block3: {
            String setter = "set" + IntrospectionUtils.capitalize(name);
            try {
                Method[] methods;
                for (Method method : methods = IntrospectionUtils.findMethods(o.getClass())) {
                    Class<?>[] paramT = method.getParameterTypes();
                    if (!setter.equals(method.getName()) || paramT.length != 0) continue;
                    method.invoke(o, new Object[0]);
                    return;
                }
            }
            catch (Exception ex1) {
                if (!log.isLoggable(Level.FINE)) break block3;
                log.log(Level.FINE, "IntrospectionUtils: Exception for " + String.valueOf(o.getClass()) + " " + name, ex1);
            }
        }
    }

    public static String replaceProperties(String value, Hashtable<Object, Object> staticProp, PropertySource[] dynamicProp) {
        int pos;
        if (value.indexOf("$") < 0) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                sb.append(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                sb.append('$');
                prev = pos + 1;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                sb.append(value.substring(pos));
                prev = value.length();
                continue;
            }
            String n = value.substring(pos + 2, endName);
            Object v = null;
            if (staticProp != null) {
                v = (String)staticProp.get(n);
            }
            if (v == null && dynamicProp != null) {
                PropertySource element;
                PropertySource[] propertySourceArray = dynamicProp;
                int n2 = propertySourceArray.length;
                for (int i = 0; i < n2 && (v = (element = propertySourceArray[i]).getProperty(n)) == null; ++i) {
                }
            }
            if (v == null) {
                v = "${" + n + "}";
            }
            sb.append((String)v);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            sb.append(value.substring(prev));
        }
        return sb.toString();
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static void addToClassPath(Vector<URL> cpV, String dir) {
        try {
            String[] cpComp = IntrospectionUtils.getFilesByExt(dir, ".jar");
            if (cpComp != null) {
                int jarCount = cpComp.length;
                for (int i = 0; i < jarCount; ++i) {
                    URL url = IntrospectionUtils.getURL(dir, cpComp[i]);
                    if (url == null) continue;
                    cpV.addElement(url);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void addToolsJar(Vector<URL> v) {
        try {
            String javaHome = System.getProperty(GlassFishVariable.JAVA_HOME.getSystemPropertyName());
            File f = new File(javaHome + "/lib/tools.jar");
            if (!f.exists()) {
                f = new File(javaHome + "/../lib/tools.jar");
            }
            v.addElement(new URL("file", "", f.getAbsolutePath()));
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
    }

    public static String[] getFilesByExt(String ld, String ext) {
        File dir = new File(ld);
        String[] names = null;
        String lext = ext;
        if (dir.isDirectory()) {
            names = dir.list((d, name) -> name.endsWith(lext));
        }
        return names;
    }

    public static URL getURL(String base, String file) {
        try {
            File baseF = new File(base);
            File f = new File(baseF, file);
            Object path = f.getCanonicalPath();
            if (f.isDirectory()) {
                path = (String)path + "/";
            }
            if (!f.exists()) {
                return null;
            }
            return new URL("file", "", (String)path);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void addJarsFromClassPath(Vector<URL> jars, String cp) throws IOException, MalformedURLException {
        String sep = System.getProperty("path.separator");
        if (cp != null) {
            StringTokenizer st = new StringTokenizer(cp, sep);
            while (st.hasMoreTokens()) {
                URL url;
                File f = new File(st.nextToken());
                Object path = f.getCanonicalPath();
                if (f.isDirectory()) {
                    path = (String)path + "/";
                }
                if (jars.contains(url = new URL("file", "", (String)path))) continue;
                jars.addElement(url);
            }
        }
    }

    public static URL[] getClassPath(Vector<URL> v) {
        URL[] urls = new URL[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            urls[i] = v.elementAt(i);
        }
        return urls;
    }

    public static URL[] getClassPath(String dir, String cpath, String cpathProp, boolean addTools) throws IOException, MalformedURLException {
        Vector<URL> jarsV = new Vector<URL>();
        if (dir != null) {
            URL url = IntrospectionUtils.getURL(dir, "classes");
            if (url != null) {
                jarsV.addElement(url);
            }
            IntrospectionUtils.addToClassPath(jarsV, dir);
        }
        if (cpath != null) {
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath);
        }
        if (cpathProp != null) {
            String cpath1 = System.getProperty(cpathProp);
            IntrospectionUtils.addJarsFromClassPath(jarsV, cpath1);
        }
        if (addTools) {
            IntrospectionUtils.addToolsJar(jarsV);
        }
        return IntrospectionUtils.getClassPath(jarsV);
    }

    public static void clear() {
        objectMethods.clear();
    }

    public static Method[] findMethods(Class<?> c) {
        Method[] methods = objectMethods.get(c);
        if (methods != null) {
            return methods;
        }
        methods = c.getMethods();
        objectMethods.put(c, methods);
        return methods;
    }

    public static Method findMethod(Class<?> c, String name, Class<?>[] params) {
        Method[] methods;
        for (Method method : methods = IntrospectionUtils.findMethods(c)) {
            if (!method.getName().equals(name)) continue;
            Class<?>[] methodParams = method.getParameterTypes();
            if (params == null) {
                if (methodParams.length != 0) continue;
                return method;
            }
            if (params.length != methodParams.length) continue;
            boolean found = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == methodParams[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    public static boolean hasHook(Object obj, String methodN) {
        try {
            Method[] myMethods;
            for (Method myMethod : myMethods = IntrospectionUtils.findMethods(obj.getClass())) {
                Class<?> declaring;
                Class<?> parentOfDeclaring;
                if (!methodN.equals(myMethod.getName()) || "java.lang.Object".equals((parentOfDeclaring = (declaring = myMethod.getDeclaringClass()).getSuperclass()).getName())) continue;
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static void callMain(Class<?> c, String[] args) throws Exception {
        Class[] p = new Class[]{args.getClass()};
        Method m = c.getMethod("main", p);
        m.invoke(c, new Object[]{args});
    }

    public static Object callMethod1(Object target, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target == null) {
            throw new IllegalArgumentException("IntrospectionUtils: Assert: Illegal params null target");
        }
        if (param1 == null) {
            throw new IllegalArgumentException("IntrospectionUtils: Assert: Illegal params null param1");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("IntrospectionUtils: callMethod1 " + target.getClass().getName() + " " + param1.getClass().getName() + " " + typeParam1);
        }
        Class[] params = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, param1);
    }

    public static Object callMethod0(Object target, String methodN) throws Exception {
        if (target == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("IntrospectionUtils: Assert: Illegal params null");
            }
            return null;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("IntrospectionUtils: callMethod0 " + target.getClass().getName() + "." + methodN);
        }
        Class[] params = new Class[]{};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, emptyArray);
    }

    public static Object callMethodN(Object target, String methodN, Object[] params, Class<?>[] typeParams) throws Exception {
        Method m = null;
        m = IntrospectionUtils.findMethod(target.getClass(), methodN, typeParams);
        if (m == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("IntrospectionUtils: Can't find method " + methodN + " in " + String.valueOf(target) + " CLASS " + String.valueOf(target.getClass()));
            }
            return null;
        }
        Object o = m.invoke(target, params);
        if (log.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(target.getClass().getName() + "." + methodN + "( ");
            for (int i = 0; i < params.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(params[i]);
            }
            sb.append(")");
            log.fine("IntrospectionUtils:" + sb.toString());
        }
        return o;
    }

    public static Object convert(String object, Class<?> paramType) {
        Object result = null;
        if ("java.lang.String".equals(paramType.getName())) {
            result = object;
        } else if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
            try {
                result = Integer.valueOf(object);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
            result = Boolean.valueOf(object);
        } else if ("java.net.InetAddress".equals(paramType.getName())) {
            try {
                result = InetAddress.getByName(object);
            }
            catch (UnknownHostException exc) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("IntrospectionUtils: Unable to resolve host name:" + object);
                }
            }
        } else if (log.isLoggable(Level.FINE)) {
            log.fine("IntrospectionUtils: Unknown type " + paramType.getName());
        }
        if (result == null) {
            throw new IllegalArgumentException("Can't convert argument: " + object);
        }
        return result;
    }

    public static interface AttributeHolder {
        public void setAttribute(String var1, Object var2);
    }

    public static interface PropertySource {
        public String getProperty(String var1);
    }
}

