/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.PacketProperties;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;

public class ClusterDestInfo {
    private Destination d = null;
    private GPacket pkt = null;
    private String destName = null;
    private int destType = -1;
    private ChangeRecordInfo shareccInfo = null;

    private ClusterDestInfo(Destination d) {
        this.d = d;
    }

    private ClusterDestInfo(GPacket pkt) {
        assert (pkt.getType() == 15 || pkt.getType() == 13);
        this.pkt = pkt;
        this.destName = (String)pkt.getProp((Object)"N");
        this.destType = (Integer)pkt.getProp((Object)"DT");
        if (pkt.getProp((Object)"shareccSeq") != null) {
            this.shareccInfo = new ChangeRecordInfo();
            this.shareccInfo.setSeq((Long)pkt.getProp((Object)"shareccSeq"));
            this.shareccInfo.setUUID((String)pkt.getProp((Object)"shareccUUID"));
            this.shareccInfo.setResetUUID((String)pkt.getProp((Object)"shareccResetUUID"));
            this.shareccInfo.setType(pkt.getType());
        }
    }

    public static ClusterDestInfo newInstance(Destination d) {
        return new ClusterDestInfo(d);
    }

    public static ClusterDestInfo newInstance(GPacket pkt) {
        return new ClusterDestInfo(pkt);
    }

    public GPacket getGPacket(short protocol, boolean changeRecord) {
        assert (this.d != null);
        assert (protocol == 15 || protocol == 13);
        GPacket gp = GPacket.getInstance();
        gp.setType(protocol);
        gp.putProp((Object)"N", (Object)this.d.getDestinationName());
        gp.putProp((Object)"DT", (Object)this.d.getType());
        switch (protocol) {
            case 15: {
                ChangeRecordInfo cri = this.d.getCurrentChangeRecordInfo(15);
                if (cri == null) break;
                gp.putProp((Object)"shareccSeq", (Object)cri.getSeq());
                gp.putProp((Object)"shareccUUID", (Object)cri.getUUID());
                gp.putProp((Object)"shareccResetUUID", (Object)cri.getResetUUID());
                break;
            }
            case 13: {
                HashMap props;
                ConnectionUID cuid;
                ChangeRecordInfo cri = this.d.getCurrentChangeRecordInfo(13);
                if (cri != null) {
                    gp.putProp((Object)"shareccSeq", (Object)cri.getSeq());
                    gp.putProp((Object)"shareccUUID", (Object)cri.getUUID());
                    gp.putProp((Object)"shareccResetUUID", (Object)cri.getResetUUID());
                }
                if (DestType.isTemporary((int)this.d.getType()) && (cuid = this.d.getConnectionUID()) != null) {
                    gp.putProp((Object)"connectionUID", (Object)cuid.longValue());
                }
                if ((props = this.d.getDestinationProperties()) == null) {
                    props = new HashMap();
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                try {
                    PacketProperties.write(props, (OutputStream)bos);
                    bos.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] buf = bos.toByteArray();
                gp.setPayload(ByteBuffer.wrap(buf));
            }
        }
        if (changeRecord) {
            gp.putProp((Object)"M", (Object)Boolean.TRUE);
        }
        return gp;
    }

    public DestinationUID getDestUID() throws BrokerException {
        assert (this.destName != null);
        return DestinationUID.getUID(this.destName, DestType.isQueue((int)this.destType));
    }

    public int getDestType() {
        assert (this.pkt != null);
        return this.destType;
    }

    public String getDestName() {
        assert (this.pkt != null);
        return this.destName;
    }

    public ChangeRecordInfo getShareccInfo() {
        return this.shareccInfo;
    }

    public Hashtable getDestProps() throws IOException, ClassNotFoundException {
        assert (this.pkt != null);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.pkt.getPayload().array());
        return PacketProperties.parseProperties((InputStream)bis);
    }
}

