/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterTransferFileRequestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;

public class TransferFileRequestHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public TransferFileRequestHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "TransferFileRequestHandler");
        }
        if (pkt.getType() == 63) {
            this.handleTransferFileRequest(sender, pkt);
        } else if (pkt.getType() == 64) {
            this.handleTransferFileRequestReply(sender, pkt);
        } else {
            this.logger.log(16, "TakeoverMEHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    private void handleTransferFileRequest(BrokerAddress sender, GPacket pkt) {
        String reason;
        int status;
        block4: {
            status = 200;
            reason = null;
            try {
                this.p.receivedTransferFileRequest(sender, pkt);
            }
            catch (Exception e) {
                status = 500;
                reason = e.getMessage();
                if (e instanceof BrokerException) break block4;
                Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
                reason = this.br.getKString("B3269", args);
                this.logger.log(32, reason);
            }
        }
        ClusterTransferFileRequestInfo tfr = ClusterTransferFileRequestInfo.newInstance(pkt);
        try {
            this.c.unicast(sender, tfr.getReplyGPacket(status, reason));
        }
        catch (IOException e) {
            Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(64), sender, tfr.toString()};
            this.logger.logStack(32, this.br.getKString("B3192", (Object)args), (Throwable)e);
        }
    }

    private void handleTransferFileRequestReply(BrokerAddress sender, GPacket pkt) {
        this.p.receivedTransferFileRequestReply(sender, pkt);
    }
}

