/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.io.Packet;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;

public final class GrizzlyMQPacketList {
    private static final ThreadCache.CachedTypeIndex<GrizzlyMQPacketList> CACHED_IDX = ThreadCache.obtainIndex(GrizzlyMQPacketList.class, (int)1);
    private final List<Packet> packets = new ArrayList<Packet>();
    private Buffer packetsBuffer;

    private GrizzlyMQPacketList() {
    }

    public static GrizzlyMQPacketList create() {
        GrizzlyMQPacketList list = (GrizzlyMQPacketList)ThreadCache.takeFromCache(CACHED_IDX);
        if (list == null) {
            list = new GrizzlyMQPacketList();
        }
        return list;
    }

    public List<Packet> getPackets() {
        return this.packets;
    }

    public void setPacketsBuffer(Buffer packetsBuffer) {
        this.packetsBuffer = packetsBuffer;
    }

    public Buffer getPacketsBuffer() {
        return this.packetsBuffer;
    }

    public void recycle(boolean isDisposeBuffer) {
        if (isDisposeBuffer && this.packetsBuffer != null) {
            this.packetsBuffer.dispose();
        }
        this.packetsBuffer = null;
        this.packets.clear();
        ThreadCache.putToCache(CACHED_IDX, (Object)this);
    }
}

