/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.shared.common.error;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class ExceptionUtil {
    public static String getSQLStateFromIdentifier(String string) {
        if (string.length() == 5) {
            return string;
        }
        return string.substring(0, 5);
    }

    public static int getSeverityFromIdentifier(String string) {
        int n = 0;
        block0 : switch (string.length()) {
            case 5: {
                block3 : switch (string.charAt(0)) {
                    case '0': {
                        switch (string.charAt(1)) {
                            case '1': {
                                n = 10000;
                                break;
                            }
                            case '7': 
                            case 'A': {
                                n = 20000;
                                break;
                            }
                            case '8': {
                                n = 40000;
                            }
                        }
                        break;
                    }
                    case '2': 
                    case '3': {
                        n = 20000;
                        break;
                    }
                    case '4': {
                        switch (string.charAt(1)) {
                            case '0': {
                                n = 30000;
                                break block3;
                            }
                            case '2': {
                                n = 20000;
                            }
                        }
                    }
                }
                break;
            }
            default: {
                switch (string.charAt(6)) {
                    case 'M': {
                        n = 50000;
                        break block0;
                    }
                    case 'D': {
                        n = 45000;
                        break block0;
                    }
                    case 'C': {
                        n = 40000;
                        break block0;
                    }
                    case 'T': {
                        n = 30000;
                        break block0;
                    }
                    case 'S': {
                        n = 20000;
                        break block0;
                    }
                    case 'U': {
                        n = 0;
                    }
                }
            }
        }
        return n;
    }

    public static String dumpThreads() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        try {
            Thread.class.getMethod("getAllStackTraces", new Class[0]);
            Class<?> clazz = Class.forName("org.apache.derby.shared.common.sanity.ThreadDump");
            final Method method = clazz.getMethod("getStackDumpString", new Class[0]);
            String string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                    return method.invoke(null, (Object[])null);
                }
            });
            printWriter.print("---------------\nStack traces for all live threads:");
            printWriter.println("\n" + string);
            printWriter.println("---------------");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            printWriter.println("(Skipping thread dump because it is not supported on JVM 1.4)");
        }
        catch (Exception exception) {
            if (exception instanceof PrivilegedActionException && exception.getCause() instanceof InvocationTargetException && exception.getCause().getCause() instanceof AccessControlException) {
                printWriter.println("(Skipping thread dump because of insufficient permissions:\n" + exception.getCause().getCause() + ")\n");
            }
            printWriter.println("\nAssertFailure tried to do a thread dump, but there was an error:");
            exception.getCause().printStackTrace(printWriter);
        }
        return stringWriter.toString();
    }

    public static boolean isDeferredConstraintViolation(String string) {
        return string.equals(ExceptionUtil.getSQLStateFromIdentifier("23506.T.1")) || string.equals(ExceptionUtil.getSQLStateFromIdentifier("23514.T.1"));
    }
}

