/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import org.jboss.weld.bean.proxy.ProxiedMethodFilter;
import org.jboss.weld.util.reflection.Reflections;

public final class CommonProxiedMethodFilters {
    public static final ProxiedMethodFilter NON_STATIC = (m, c) -> !Modifier.isStatic(m.getModifiers());
    public static final ProxiedMethodFilter NON_FINAL = (m, c) -> !Modifier.isFinal(m.getModifiers());
    public static final ProxiedMethodFilter OBJECT_TO_STRING = (m, c) -> m.getDeclaringClass() != Object.class || m.getName().equals("toString");
    public static final ProxiedMethodFilter NON_PRIVATE = (m, c) -> !Modifier.isPrivate(m.getModifiers());
    public static final ProxiedMethodFilter NON_JDK_PACKAGE_PRIVATE = new ProxiedMethodFilter(){

        @Override
        public boolean accept(Method method, Class<?> proxySuperclass) {
            Package pack;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass != null && (pack = declaringClass.getPackage()) != null && pack.getName().startsWith("java")) {
                Class<?>[] parameterTypes;
                if (Reflections.isPackagePrivate(method.getModifiers())) {
                    return false;
                }
                for (Class<?> parameterType : parameterTypes = method.getParameterTypes()) {
                    if (!Reflections.isPackagePrivate(parameterType.getModifiers())) continue;
                    return false;
                }
            }
            return true;
        }
    };
    public static final ProxiedMethodFilter NON_PRIVATE_WITHOUT_PACK_PRIVATE_PARAMS = new ProxiedMethodFilter(){

        @Override
        public boolean accept(Method method, Class<?> proxySuperclass) {
            if (Modifier.isPrivate(method.getModifiers())) {
                for (Parameter param : method.getParameters()) {
                    Class<?> paramClass = param.getType();
                    if (Modifier.isProtected(paramClass.getModifiers()) || Modifier.isPublic(paramClass.getModifiers()) || Modifier.isPrivate(paramClass.getModifiers())) continue;
                    return false;
                }
            }
            return true;
        }
    };

    private CommonProxiedMethodFilters() {
    }
}

