/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CLIUtil;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-system-properties")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@I18n(value="create.system.properties")
public class CreateSystemProperties
implements AdminCommand,
AdminCommandSecurity.Preauthorization,
AdminCommandSecurity.AccessCheckProvider {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateSystemProperties.class);
    @Param(optional=true, defaultValue="server")
    String target;
    @Param(name="name_value", primary=true, separator=58)
    Properties properties;
    @Inject
    Domain domain;
    private SystemPropertyBag spb;

    public boolean preAuthorization(AdminCommandContext context) {
        this.spb = CLIUtil.chooseTarget(this.domain, this.target);
        if (this.spb == null) {
            ActionReport report = context.getActionReport();
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            String msg = localStrings.getLocalString("invalid.target.sys.props", "Invalid target:{0}. Valid targets types are domain, config, cluster, default server, clustered instance, stand alone instance", new Object[]{this.target});
            report.setMessage(msg);
            return false;
        }
        return true;
    }

    public Collection<? extends AccessRequired.AccessCheck> getAccessChecks() {
        ArrayList<AccessRequired.AccessCheck> result = new ArrayList<AccessRequired.AccessCheck>();
        result.add(new AccessRequired.AccessCheck(AccessRequired.Util.resourceNameFromConfigBeanProxy((ConfigBeanProxy)this.spb), "update"));
        return result;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        String sysPropName = "";
        try {
            for (Object key : this.properties.keySet()) {
                final String propName = (String)key;
                sysPropName = propName;
                if (this.spb.containsProperty(sysPropName) && this.spb.getSystemProperty(sysPropName).getValue().equals(this.properties.getProperty(propName))) continue;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SystemPropertyBag>(){

                    public Object run(SystemPropertyBag param) throws PropertyVetoException, TransactionFailure {
                        for (SystemProperty sysProperty : param.getSystemProperty()) {
                            if (!sysProperty.getName().equals(propName)) continue;
                            Transaction t = Transaction.getTransaction((ConfigBeanProxy)param);
                            sysProperty = (SystemProperty)t.enroll((ConfigBeanProxy)sysProperty);
                            sysProperty.setValue(CreateSystemProperties.this.properties.getProperty(propName));
                            return sysProperty;
                        }
                        SystemProperty newSysProp = (SystemProperty)param.createChild(SystemProperty.class);
                        newSysProp.setName(propName);
                        newSysProp.setValue(CreateSystemProperties.this.properties.getProperty(propName));
                        param.getSystemProperty().add(newSysProp);
                        return newSysProp;
                    }
                }, (ConfigBeanProxy)this.spb);
                report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            }
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("create.system.properties.failed", "System property {0} creation failed", new Object[]{sysPropName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)tfe);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.system.properties.failed", "System property {0} creation failed", new Object[]{sysPropName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

