/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.util.List;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Descriptor;
import org.glassfish.hk2.api.Filter;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class ObjectInputStreamWithServiceLocator
extends ObjectInputStream {
    private final ServiceLocator serviceLocator;

    public ObjectInputStreamWithServiceLocator(InputStream in, ServiceLocator serviceLocator) throws IOException, StreamCorruptedException {
        super(in);
        if (serviceLocator == null) {
            throw new IllegalArgumentException("Illegal null argument to ObjectInputStreamWithLoader");
        }
        this.serviceLocator = serviceLocator;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass classDesc) throws IOException, ClassNotFoundException {
        try {
            return super.resolveClass(classDesc);
        }
        catch (ClassNotFoundException e) {
            String cname = classDesc.getName();
            if (cname.startsWith("[")) {
                int dcount = 1;
                while (cname.charAt(dcount) == '[') {
                    ++dcount;
                }
                if (cname.charAt(dcount) != 'L') {
                    throw new ClassNotFoundException(cname);
                }
                Class<?> component = this.loadClass(cname.substring(dcount + 1, cname.length() - 1));
                int[] dim = new int[dcount];
                for (int i = 0; i < dcount; ++i) {
                    dim[i] = 0;
                }
                return Array.newInstance(component, dim).getClass();
            }
            return this.loadClass(cname);
        }
    }

    private Class<?> loadClass(String cname) throws ClassNotFoundException {
        List<ActiveDescriptor<?>> descriptors = "com.oracle.cloudlogic.accountmanager.cli.AccountAwareJobImpl".equals(cname) ? this.getDescriptors("com.oracle.cloudlogic.accountmanager.cli.AccountAwareJobCreator") : this.getDescriptors(cname);
        if (descriptors.size() > 0) {
            return descriptors.get(0).getLoader().loadClass(cname);
        }
        throw new ClassNotFoundException(cname);
    }

    private List<ActiveDescriptor<?>> getDescriptors(final String cname) throws ClassNotFoundException {
        return this.serviceLocator.getDescriptors(new Filter(){

            public boolean matches(Descriptor d) {
                return d.getImplementation().equals(cname);
            }
        });
    }
}

