/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.server.CommonClassLoaderServiceImpl;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.glassfish.main.jdke.cl.GlassfishUrlClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class AppLibClassLoaderServiceImpl
implements EventListener {
    private static final System.Logger LOG = System.getLogger(AppLibClassLoaderServiceImpl.class.getName());
    private final Map<Library, DelegatingClassLoader.ClassFinder> classFinderRegistry = new ConcurrentHashMap<Library, DelegatingClassLoader.ClassFinder>();
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private CommonClassLoaderServiceImpl commonClassLoaderService;
    @Inject
    private Events events;

    @PostConstruct
    public void postConstruct() {
        this.events.register((EventListener)this);
    }

    public void event(@RestrictTo(value="prepare_shutdown") EventListener.Event<?> event) {
        for (DelegatingClassLoader.ClassFinder classFinder : this.classFinderRegistry.values()) {
            try {
                ((GlassfishUrlClassLoader)classFinder).close();
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.WARNING, () -> "Could not close class finder " + String.valueOf(classFinder), (Throwable)e);
            }
        }
        for (Library library : this.classFinderRegistry.keySet()) {
            library.close();
        }
    }

    public ClassLoader getAppLibClassLoader(String application, List<URI> libURIs) throws MalformedURLException {
        ClassLoaderHierarchy classLoaderHierarchy = (ClassLoaderHierarchy)this.serviceLocator.getService(ClassLoaderHierarchy.class, new Annotation[0]);
        DelegatingClassLoader connectorClassLoader = classLoaderHierarchy.getConnectorClassLoader(application);
        if (libURIs == null || libURIs.isEmpty()) {
            return connectorClassLoader;
        }
        ClassLoader commonClassLoader = this.commonClassLoaderService.getCommonClassLoader();
        PrivilegedAction<DelegatingClassLoader> action = () -> new DelegatingClassLoader(commonClassLoader);
        DelegatingClassLoader appLibClassLoader = AccessController.doPrivileged(action);
        for (DelegatingClassLoader.ClassFinder classFinder : connectorClassLoader.getDelegates()) {
            appLibClassLoader.addDelegate(classFinder);
        }
        this.addDelegates(libURIs, appLibClassLoader);
        return appLibClassLoader;
    }

    public DelegatingClassLoader.ClassFinder getAppLibClassFinder(Collection<URI> libURIs) throws MalformedURLException {
        ClassLoader commonClassLoader = this.commonClassLoaderService.getCommonClassLoader();
        DelegatingClassFinder appLibClassFinder = AccessController.doPrivileged(() -> new DelegatingClassFinder(commonClassLoader));
        this.addDelegates(libURIs, appLibClassFinder);
        return appLibClassFinder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDelegates(Collection<URI> libURIs, DelegatingClassLoader holder) throws MalformedURLException {
        ClassLoader commonClassLoader = this.commonClassLoaderService.getCommonClassLoader();
        for (URI libURI : libURIs) {
            AppLibClassLoaderServiceImpl appLibClassLoaderServiceImpl = this;
            synchronized (appLibClassLoaderServiceImpl) {
                Library library = new Library(libURI);
                DelegatingClassLoader.ClassFinder classFinder = this.classFinderRegistry.get(library);
                if (classFinder == null) {
                    ServerEnvironment serverEnvironment = (ServerEnvironment)this.serviceLocator.getService(ServerEnvironment.class, new Annotation[0]);
                    classFinder = new URLClassFinder(library.getURL(serverEnvironment), commonClassLoader);
                    this.classFinderRegistry.put(library, classFinder);
                } else {
                    library.close();
                }
                holder.addDelegate(classFinder);
            }
        }
    }

    private static class Library {
        private static final System.Logger LOG;
        private static final Method readAttributesMethod;
        private static final Field nativeDescriptorField;
        private final URI originalSource;
        private final BasicFileAttributes attributes;
        private FileInputStream fileInputStream;
        private URI source;

        Library(URI libURI) {
            Object nativeDescriptor;
            this.originalSource = libURI;
            try {
                this.fileInputStream = new FileInputStream(new File(libURI));
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.WARNING, () -> "Could not open input stream for application library " + String.valueOf(libURI), (Throwable)e);
            }
            BasicFileAttributes attributes = null;
            if (this.fileInputStream != null && (nativeDescriptor = this.getNativeDescriptor(this.fileInputStream)) != null) {
                attributes = this.readAttributes(nativeDescriptor);
            }
            if (attributes == null) {
                attributes = this.readAttributes(libURI);
            }
            this.attributes = attributes;
        }

        public URL getURL(ServerEnvironment serverEnvironment) throws MalformedURLException {
            if (this.source == null) {
                File snapshot = this.createSnapshot(serverEnvironment);
                if (snapshot != null) {
                    LOG.log(System.Logger.Level.TRACE, "Created snapshot {0} for application library {1}", snapshot.getAbsolutePath(), this.originalSource);
                    this.source = snapshot.toURI();
                } else {
                    this.source = this.originalSource;
                }
            }
            return this.source.toURL();
        }

        public void close() {
            if (this.fileInputStream != null) {
                try {
                    this.fileInputStream.close();
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.WARNING, () -> "Could not close input stream for application library " + String.valueOf(this.originalSource), (Throwable)e);
                }
            }
            if (this.hasSnapshot()) {
                try {
                    Files.delete(Path.of(this.source));
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.WARNING, () -> "Could not delete snapshot for library " + String.valueOf(this), (Throwable)e);
                }
            }
        }

        private boolean hasSnapshot() {
            return this.source != null && this.source != this.originalSource;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Library)) {
                return false;
            }
            Library library = (Library)obj;
            if (!this.originalSource.equals(library.originalSource)) {
                return false;
            }
            if (this.attributes == null || library.attributes == null) {
                return this.attributes == library.attributes;
            }
            if (this.attributes.size() != library.attributes.size()) {
                return false;
            }
            if (!Objects.equals(this.attributes.lastModifiedTime(), library.attributes.lastModifiedTime())) {
                return false;
            }
            return Objects.equals(this.attributes.fileKey(), library.attributes.fileKey());
        }

        public int hashCode() {
            int hash = this.originalSource.hashCode();
            if (this.attributes != null) {
                hash = 31 * hash + Long.hashCode(this.attributes.size());
                hash = 31 + hash + Objects.hashCode(this.attributes.lastModifiedTime());
                hash = 31 + hash + Objects.hashCode(this.attributes.fileKey());
            }
            return hash;
        }

        private Object getNativeDescriptor(FileInputStream fileInputStream) {
            Object nativeDescriptor = null;
            if (nativeDescriptorField != null) {
                try {
                    FileDescriptor fileDescriptor = fileInputStream.getFD();
                    if (fileDescriptor.valid()) {
                        nativeDescriptor = nativeDescriptorField.get(fileDescriptor);
                        LOG.log(System.Logger.Level.TRACE, "Returning nativeDescriptor={0} for application library {1}", nativeDescriptor, this.originalSource);
                    }
                }
                catch (IOException | IllegalAccessException e) {
                    LOG.log(System.Logger.Level.WARNING, () -> "Could not obtain native descriptor for application library " + String.valueOf(this.originalSource), (Throwable)e);
                }
            }
            return nativeDescriptor;
        }

        private BasicFileAttributes readAttributes(Object nativeDescriptor) {
            LOG.log(System.Logger.Level.DEBUG, "readAttributes(nativeDescriptor={0})", nativeDescriptor);
            BasicFileAttributes attributes = null;
            if (readAttributesMethod != null) {
                try {
                    attributes = (BasicFileAttributes)readAttributesMethod.invoke(null, nativeDescriptor);
                }
                catch (Exception e) {
                    LOG.log(System.Logger.Level.WARNING, () -> "Could not read file attributes for nativeDescriptor=" + String.valueOf(nativeDescriptor), (Throwable)e);
                }
            }
            return attributes;
        }

        private BasicFileAttributes readAttributes(URI libURI) {
            LOG.log(System.Logger.Level.DEBUG, "readAttributes(libURI={0})", libURI);
            try {
                return Files.readAttributes(Path.of(libURI), BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.WARNING, () -> "Could not read file attributes for libURI=" + String.valueOf(libURI), (Throwable)e);
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File createSnapshot(ServerEnvironment serverEnvironment) {
            LOG.log(System.Logger.Level.DEBUG, "createSnapshot()");
            File snapshotsDir = new File(serverEnvironment.getLibPath(), "snapshots");
            File originalFile = new File(this.originalSource);
            File snapshot = null;
            try {
                String snapshotPrefix = FileUtils.removeExtension((File)originalFile) + "-";
                String snapshotSuffix = FileUtils.getExtension((File)originalFile);
                snapshot = Files.createTempFile(snapshotsDir.toPath(), snapshotPrefix, snapshotSuffix, new FileAttribute[0]).toFile();
                if (!this.copy(this.fileInputStream, snapshot)) {
                    FileUtils.copy((File)originalFile, (File)snapshot);
                }
                snapshot.deleteOnExit();
            }
            catch (IOException e) {
                LOG.log(System.Logger.Level.WARNING, () -> "Could not create snapshot for application library " + String.valueOf(this.originalSource), (Throwable)e);
                FileUtils.deleteFileMaybe(snapshot);
            }
            finally {
                this.fileInputStream = null;
            }
            return snapshot;
        }

        private boolean copy(InputStream inputStream, File file) {
            boolean bl;
            block9: {
                if (inputStream == null) {
                    return false;
                }
                InputStream inputStream2 = inputStream;
                try {
                    FileUtils.copy((InputStream)inputStream, (File)file);
                    bl = true;
                    if (inputStream2 == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                inputStream2.close();
            }
            return bl;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("[");
            sb.append("originalSource=").append(this.originalSource).append(", ");
            sb.append("source=").append(this.source);
            if (this.attributes != null) {
                sb.append(", ");
                sb.append("size=").append(this.attributes.size());
                FileTime lastModifiedTime = this.attributes.lastModifiedTime();
                if (lastModifiedTime != null) {
                    sb.append(", ");
                    sb.append("lastModifiedTime=").append(lastModifiedTime);
                }
            }
            sb.append("]");
            return sb.toString();
        }

        static {
            Field field;
            Method method;
            LOG = System.getLogger(Library.class.getName());
            try {
                if (OS.isWindows()) {
                    Class<?> attributesClass = Class.forName("sun.nio.fs.WindowsFileAttributes");
                    method = attributesClass.getDeclaredMethod("readAttributes", Long.TYPE);
                    field = FileDescriptor.class.getDeclaredField("handle");
                } else {
                    Class<?> attributesClass = Class.forName("sun.nio.fs.UnixFileAttributes");
                    method = attributesClass.getDeclaredMethod("get", Integer.TYPE);
                    field = FileDescriptor.class.getDeclaredField("fd");
                }
                method.setAccessible(true);
                field.setAccessible(true);
            }
            catch (InaccessibleObjectException e) {
                LOG.log(System.Logger.Level.WARNING, () -> "Could not access specialized 'sun.nio.fs' APIs. Try opening the package with the JVM argument '--add-opens=java.base/sun.nio.fs=ALL-UNNAMED' to the JVM options. We will now fallback to using basic file attributes. Error: " + e.getMessage());
                method = null;
                field = null;
            }
            catch (Exception e) {
                Supplier<String> messageSupplier = () -> "Could not initialize sun.nio.fs. We will now fallback to using basic file attributes. Error: " + e.getMessage();
                if (e instanceof ReflectiveOperationException) {
                    LOG.log(System.Logger.Level.WARNING, messageSupplier);
                } else {
                    LOG.log(System.Logger.Level.WARNING, messageSupplier, (Throwable)e);
                }
                method = null;
                field = null;
            }
            readAttributesMethod = method;
            nativeDescriptorField = field;
        }
    }

    private static class DelegatingClassFinder
    extends DelegatingClassLoader
    implements DelegatingClassLoader.ClassFinder {
        DelegatingClassFinder(ClassLoader parent) {
            super(parent);
        }

        public Class<?> findExistingClass(String name) {
            return null;
        }

        public URL findResource(String name) {
            return super.findResource(name);
        }

        public Enumeration<URL> findResources(String name) throws IOException {
            return super.findResources(name);
        }

        static {
            DelegatingClassFinder.registerAsParallelCapable();
        }
    }

    private static class URLClassFinder
    extends GlassfishUrlClassLoader
    implements DelegatingClassLoader.ClassFinder {
        private static final URLStreamHandler urlStreamHandler;
        private final Set<String> notFoundResources = ConcurrentHashMap.newKeySet();

        URLClassFinder(URL url, ClassLoader parent) {
            super("AppLib(" + url.getFile() + ")", new URL[]{url}, parent);
        }

        public Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                this.notFoundResources.add(name);
                throw e;
            }
        }

        public Class<?> findExistingClass(String name) {
            if (this.notFoundResources.contains(name)) {
                return null;
            }
            return this.findLoadedClass(name);
        }

        public URL findResource(String name) {
            if (this.notFoundResources.contains(name)) {
                return null;
            }
            URL resourceURL = super.findResource(name);
            if (resourceURL != null) {
                try {
                    resourceURL = new URL(resourceURL, resourceURL.toExternalForm(), urlStreamHandler);
                }
                catch (MalformedURLException e) {
                    resourceURL = null;
                }
            }
            if (resourceURL == null) {
                this.notFoundResources.add(name);
            }
            return resourceURL;
        }

        public Enumeration<URL> findResources(String name) {
            URL resourceURL = this.findResource(name);
            return resourceURL != null ? Collections.enumeration(List.of(resourceURL)) : Collections.emptyEnumeration();
        }

        static {
            URLClassFinder.registerAsParallelCapable();
            urlStreamHandler = new NonCachingURLStreamHandler();
        }
    }

    private static class NonCachedURLConnection
    extends JarURLConnection {
        private JarURLConnection jarURLConnection;

        private NonCachedURLConnection(URL url) throws MalformedURLException {
            super(url);
        }

        @Override
        public void connect() throws IOException {
            if (this.jarURLConnection == null) {
                URLConnection urlConnection = new URL(this.url.toExternalForm()).openConnection();
                urlConnection.setUseCaches(false);
                this.jarURLConnection = (JarURLConnection)urlConnection;
            }
        }

        @Override
        public JarFile getJarFile() throws IOException {
            this.connect();
            return this.jarURLConnection.getJarFile();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            return this.jarURLConnection.getInputStream();
        }

        @Override
        public void setUseCaches(boolean useCaches) {
        }
    }

    private static class NonCachingURLStreamHandler
    extends URLStreamHandler {
        private NonCachingURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            return new NonCachedURLConnection(url);
        }
    }
}

