/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import jakarta.faces.model.DataModel;
import jakarta.faces.model.DataModelEvent;
import jakarta.faces.model.DataModelListener;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class TableDataProviderDataModel
extends DataModel {
    private FieldKey[] fieldKeys = null;
    private int rowIndex = -1;
    private TableDataProvider tdp = null;

    public TableDataProviderDataModel() {
        this(null);
    }

    public TableDataProviderDataModel(TableDataProvider newTdp) {
        this.setTableDataProvider(newTdp);
    }

    public TableDataProvider getTableDataProvider() {
        return this.tdp;
    }

    public void setTableDataProvider(TableDataProvider newTdp) {
        this.tdp = newTdp;
        if (newTdp == null) {
            this.fieldKeys = null;
            this.rowIndex = -1;
        } else {
            this.fieldKeys = newTdp.getFieldKeys();
        }
    }

    public boolean isRowAvailable() {
        if (this.getTableDataProvider() == null) {
            return false;
        }
        return this.getTableDataProvider().isRowAvailable(this.getRowKey());
    }

    public int getRowCount() {
        if (this.getTableDataProvider() == null) {
            return -1;
        }
        return this.getTableDataProvider().getRowCount();
    }

    public Object getRowData() {
        if (this.getTableDataProvider() == null) {
            return null;
        }
        if (!this.getTableDataProvider().isRowAvailable(this.getRowKey())) {
            throw new IllegalArgumentException("" + this.getRowIndex());
        }
        TableDataProviderMap map = new TableDataProviderMap();
        for (FieldKey fieldKey : this.fieldKeys) {
            map.put(fieldKey.getFieldId(), this.tdp.getValue(fieldKey, this.getRowKey()));
        }
        return map;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public RowKey getRowKey() {
        int i = this.getRowIndex();
        RowKey[] rks = this.tdp.getRowKeys(i + 1, null);
        if (rks.length > i) {
            return rks[i];
        }
        return null;
    }

    public void setRowIndex(int newRowIndex) {
        if (newRowIndex < -1) {
            throw new IllegalArgumentException("" + newRowIndex);
        }
        int oldIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.getTableDataProvider() == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != newRowIndex && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, newRowIndex, rowData);
            for (DataModelListener listener : listeners) {
                listener.rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.getTableDataProvider();
    }

    public void setWrappedData(Object data) {
        this.setTableDataProvider((TableDataProvider)data);
    }

    private final class TableDataProviderValuesIterator
    implements Iterator {
        private TableDataProviderMap map = null;
        private Iterator keys = null;

        TableDataProviderValuesIterator(TableDataProviderMap newMap) {
            this.map = newMap;
            this.keys = newMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.map.get(this.keys.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class TableDataProviderValues
    extends AbstractCollection {
        private TableDataProviderMap map = null;

        TableDataProviderValues(TableDataProviderMap newMap) {
            this.map = newMap;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Iterator iterator() {
            return new TableDataProviderValuesIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private final class TableDataProviderKeysIterator
    implements Iterator {
        private TableDataProviderMap map = null;
        private Iterator keys = null;

        TableDataProviderKeysIterator(TableDataProviderMap newMap) {
            this.map = newMap;
            this.keys = newMap.realKeys();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.keys.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class TableDataProviderKeys
    extends AbstractSet {
        private TableDataProviderMap map = null;

        TableDataProviderKeys(TableDataProviderMap newMap) {
            this.map = newMap;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new TableDataProviderKeysIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private final class TableDataProviderEntry
    implements Map.Entry {
        private TableDataProviderMap map = null;
        private Object key = null;

        TableDataProviderEntry(TableDataProviderMap newMap, Object newKey) {
            this.map = newMap;
            this.key = newKey;
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            Object v = this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.map.get(this.key);
        }

        @Override
        public int hashCode() {
            Object value = this.map.get(this.key);
            if (this.key == null) {
                return 0;
            }
            if (value == null) {
                return this.key.hashCode();
            }
            return this.key.hashCode() ^ value.hashCode();
        }

        public Object setValue(Object value) {
            Object previous = this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    private final class TableDataProviderIterator
    implements Iterator {
        private TableDataProviderMap map = null;
        private Iterator keys = null;

        TableDataProviderIterator(TableDataProviderMap newMap) {
            this.map = newMap;
            this.keys = newMap.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            Object key = this.keys.next();
            return new TableDataProviderEntry(this.map, key);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class TableDataProviderEntries
    extends AbstractSet {
        private TableDataProviderMap map = null;

        TableDataProviderEntries(TableDataProviderMap newMap) {
            this.map = newMap;
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Iterator iterator() {
            return new TableDataProviderIterator(this.map);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.map.size();
        }
    }

    private final class TableDataProviderMap
    extends AbstractMap {
        private final int rowIndex;
        private final RowKey rowKey;
        private final FieldKey[] fieldKeys;
        private final TableDataProvider tdp;

        TableDataProviderMap() {
            this.fieldKeys = TableDataProviderDataModel.this.fieldKeys;
            this.tdp = TableDataProviderDataModel.this.tdp;
            this.rowIndex = TableDataProviderDataModel.this.getRowIndex();
            this.rowKey = TableDataProviderDataModel.this.getRowKey();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsValue(Object value) {
            for (Object key : this.keySet()) {
                Object contained = this.get(key);
                if (!(value == null ? contained == null : value.equals(contained))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Set entrySet() {
            return new TableDataProviderEntries(this);
        }

        @Override
        public Object get(Object key) {
            int columnIndex = this.index(key);
            if (columnIndex < 0) {
                return null;
            }
            return this.tdp.getValue(this.fieldKeys[columnIndex], this.rowKey);
        }

        @Override
        public Set keySet() {
            return new TableDataProviderKeys(this);
        }

        @Override
        public Object put(Object key, Object value) {
            int columnIndex = this.index(key);
            if (columnIndex < 0) {
                return null;
            }
            Object previous = this.tdp.getValue(this.fieldKeys[columnIndex], this.rowKey);
            this.tdp.setValue(this.fieldKeys[columnIndex], this.rowKey, value);
            return previous;
        }

        @Override
        public void putAll(Map map) {
            for (Object key : map.keySet()) {
                this.put(key, map.get(key));
            }
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection values() {
            return new TableDataProviderValues(this);
        }

        private int index(Object key) {
            int index = -1;
            for (int i = 0; i < this.fieldKeys.length; ++i) {
                if (!key.equals(this.fieldKeys[i].getFieldId())) continue;
                index = i;
                break;
            }
            return index;
        }

        Object realKey(Object key) {
            return super.get(key);
        }

        Iterator realKeys() {
            return super.keySet().iterator();
        }
    }
}

