/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.webui.jsf.component.ProgressBar;
import com.sun.webui.jsf.util.JsonUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.Renderer;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public final class ProgressBarRenderer
extends Renderer {
    public void decode(FacesContext context, UIComponent component) {
        String buttonId;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String id = component.getClientId(context);
        Map params = context.getExternalContext().getRequestParameterMap();
        Object valueObject = params.get(buttonId = id + "_controlType");
        if (valueObject != null) {
            String value = ((String)valueObject).trim();
            ProgressBar progressBar = (ProgressBar)component;
            if ("stopped".equals(value)) {
                progressBar.setTaskState("stopped");
            } else if ("paused".equals(value)) {
                progressBar.setTaskState("paused");
            } else if ("resumed".equals(value)) {
                progressBar.setTaskState("resumed");
            } else if ("canceled".equals(value)) {
                progressBar.setTaskState("canceled");
            }
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        UIComponent bottomTextFacet;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return;
        }
        ProgressBar progressBar = (ProgressBar)component;
        int progress = progressBar.getProgress();
        String status = progressBar.getStatus();
        String topText = progressBar.getDescription();
        String logMessage = progressBar.getLogMessage();
        String failedStateText = progressBar.getFailedStateText();
        UIComponent topTextFacet = component.getFacet("progressTextTop");
        if (topTextFacet != null) {
            topText = null;
        }
        if ((bottomTextFacet = component.getFacet("progressTextBottom")) != null) {
            status = null;
        }
        JsonObject json = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("taskState", progressBar.getTaskState()).add("progress", progress).add("status", status).add("topText", topText).add("logMessage", logMessage).add("failedStateText", failedStateText).build();
        JsonUtilities.writeJsonObject(json, (Writer)context.getResponseWriter());
    }
}

